/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.cache;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CacheDirUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheDirUtil.class);

    CacheDirUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryMarkCacheDirectoryByTag(Path dir) {
        OutputStream stream;
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        Path cacheDirTag = dir.resolve("CACHEDIR.TAG");
        try {
            stream = Files.newOutputStream(cacheDirTag, StandardOpenOption.CREATE_NEW);
        }
        catch (IOException e) {
            if (Files.exists(cacheDirTag, new LinkOption[0])) {
                return;
            }
            LOGGER.debug("Failed to write cache directory tag file: " + cacheDirTag, (Throwable)e);
            return;
        }
        try {
            try {
                stream.write("Signature: 8a477f597d28d172789f06886806bc55\n# This file is a cache directory tag created by Gradle.\n# For information about cache directory tags, see:\n#\thttps://bford.info/cachedir/".getBytes("UTF-8"));
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            LOGGER.debug("Failed to write cache directory tag file: " + cacheDirTag, (Throwable)e);
            try {
                Files.deleteIfExists(cacheDirTag);
            }
            catch (IOException e1) {
                LOGGER.warn("Failed to delete partial cache directory tag file: " + cacheDirTag, (Throwable)e1);
            }
        }
    }
}

