/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.rtcp.SdesItem;
import org.jitsi.rtp.rtcp.SdesItemType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/rtp/rtcp/UnknownSdesItem;", "Lorg/jitsi/rtp/rtcp/SdesItem;", "sdesTypeValue", "", "buf", "", "offset", "length", "<init>", "(I[BII)V", "dataField", "sizeBytes", "getSizeBytes", "()I", "toString", "", "rtp"})
public final class UnknownSdesItem
extends SdesItem {
    private final int sdesTypeValue;
    @NotNull
    private final byte[] dataField;
    private final int sizeBytes;

    public UnknownSdesItem(int sdesTypeValue, @NotNull byte[] buf, int offset, int length) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        super(SdesItemType.UNKNOWN);
        this.sdesTypeValue = sdesTypeValue;
        this.dataField = SdesItem.Companion.copyData(buf, offset, length);
        this.sizeBytes = 2 + this.dataField.length;
    }

    @Override
    public int getSizeBytes() {
        return this.sizeBytes;
    }

    @NotNull
    public String toString() {
        return "Unknown SDES type(" + this.sdesTypeValue + ") data = " + ByteArrayExtensionsKt.toHex$default(this.dataField, 0, 0, 3, null);
    }
}

