/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.datatypes.UInt32;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.util.InternetAddress;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.XmppDateTime;

public class ParserUtils {
    public static final String JID = "jid";

    public static void assertAtStartTag(XmlPullParser parser2) throws XmlPullParserException {
        assert (parser2.getEventType() == XmlPullParser.Event.START_ELEMENT);
    }

    public static void assertAtStartTag(XmlPullParser parser2, String name) throws XmlPullParserException {
        ParserUtils.assertAtStartTag(parser2);
        assert (name.equals(parser2.getName()));
    }

    public static void assertAtEndTag(XmlPullParser parser2) throws XmlPullParserException {
        assert (parser2.getEventType() == XmlPullParser.Event.END_ELEMENT);
    }

    public static void forwardToStartElement(XmlPullParser parser2) throws XmlPullParserException, IOException {
        XmlPullParser.Event event = parser2.getEventType();
        while (event != XmlPullParser.Event.START_ELEMENT) {
            if (event == XmlPullParser.Event.END_DOCUMENT) {
                throw new IllegalArgumentException("Document contains no start tag");
            }
            event = parser2.next();
        }
    }

    public static void forwardToEndTagOfDepth(XmlPullParser parser2, int depth) throws XmlPullParserException, IOException {
        XmlPullParser.Event event = parser2.getEventType();
        while (event != XmlPullParser.Event.END_ELEMENT || parser2.getDepth() != depth) {
            assert (event != XmlPullParser.Event.END_DOCUMENT);
            event = parser2.next();
        }
    }

    public static Jid getJidAttribute(XmlPullParser parser2) throws XmppStringprepException {
        return ParserUtils.getJidAttribute(parser2, JID);
    }

    public static Jid getJidAttribute(XmlPullParser parser2, String name) throws XmppStringprepException {
        String jidString = parser2.getAttributeValue("", name);
        if (jidString == null) {
            return null;
        }
        return JidCreate.from(jidString);
    }

    public static EntityBareJid getBareJidAttribute(XmlPullParser parser2) throws XmppStringprepException {
        return ParserUtils.getBareJidAttribute(parser2, JID);
    }

    public static EntityBareJid getBareJidAttribute(XmlPullParser parser2, String name) throws XmppStringprepException {
        String jidString = parser2.getAttributeValue("", name);
        if (jidString == null) {
            return null;
        }
        return JidCreate.entityBareFrom(jidString);
    }

    public static EntityFullJid getFullJidAttribute(XmlPullParser parser2) throws XmppStringprepException {
        return ParserUtils.getFullJidAttribute(parser2, JID);
    }

    public static EntityFullJid getFullJidAttribute(XmlPullParser parser2, String name) throws XmppStringprepException {
        String jidString = parser2.getAttributeValue("", name);
        if (jidString == null) {
            return null;
        }
        return JidCreate.entityFullFrom(jidString);
    }

    public static EntityJid getEntityJidAttribute(XmlPullParser parser2, String name) throws XmppStringprepException {
        String jidString = parser2.getAttributeValue("", name);
        if (jidString == null) {
            return null;
        }
        Jid jid = JidCreate.from(jidString);
        if (!jid.hasLocalpart()) {
            return null;
        }
        EntityFullJid fullJid = jid.asEntityFullJidIfPossible();
        if (fullJid != null) {
            return fullJid;
        }
        EntityBareJid bareJid = jid.asEntityBareJidIfPossible();
        return bareJid;
    }

    public static Resourcepart getResourcepartAttribute(XmlPullParser parser2, String name) throws XmppStringprepException {
        String resourcepartString = parser2.getAttributeValue("", name);
        if (resourcepartString == null) {
            return null;
        }
        return Resourcepart.from(resourcepartString);
    }

    public static boolean parseXmlBoolean(String booleanString) {
        switch (booleanString) {
            case "true": 
            case "1": {
                return true;
            }
            case "false": 
            case "0": {
                return false;
            }
        }
        throw new IllegalArgumentException(booleanString + " is not a valid boolean string");
    }

    public static Boolean getBooleanAttribute(XmlPullParser parser2, String name) {
        String valueString = parser2.getAttributeValue("", name);
        if (valueString == null) {
            return null;
        }
        valueString = valueString.toLowerCase(Locale.US);
        return ParserUtils.parseXmlBoolean(valueString);
    }

    public static boolean getBooleanAttribute(XmlPullParser parser2, String name, boolean defaultValue) {
        Boolean bool = ParserUtils.getBooleanAttribute(parser2, name);
        if (bool == null) {
            return defaultValue;
        }
        return bool;
    }

    public static Byte getByteAttributeFromNextText(XmlPullParser parser2) throws IOException, XmlPullParserException {
        String nextText = parser2.nextText();
        return Byte.valueOf(nextText);
    }

    public static int getIntegerAttributeOrThrow(XmlPullParser parser2, String name, String throwMessage) throws IOException {
        Integer res = ParserUtils.getIntegerAttribute(parser2, name);
        if (res == null) {
            throw new IOException(throwMessage);
        }
        return res;
    }

    public static Integer getIntegerAttribute(XmlPullParser parser2, String name) {
        String valueString = parser2.getAttributeValue("", name);
        if (valueString == null) {
            return null;
        }
        return Integer.valueOf(valueString);
    }

    public static int getIntegerAttribute(XmlPullParser parser2, String name, int defaultValue) {
        Integer integer = ParserUtils.getIntegerAttribute(parser2, name);
        if (integer == null) {
            return defaultValue;
        }
        return integer;
    }

    public static UInt16 getUInt16Attribute(XmlPullParser parser2, String name) {
        Integer integer = ParserUtils.getIntegerAttribute(parser2, name);
        if (integer == null) {
            return null;
        }
        return UInt16.from(integer);
    }

    public static UInt16 getRequiredUInt16Attribute(XmlPullParser parser2, String name) throws SmackParsingException.RequiredAttributeMissingException {
        UInt16 uint16 = ParserUtils.getUInt16Attribute(parser2, name);
        if (uint16 == null) {
            throw new SmackParsingException.RequiredAttributeMissingException(name);
        }
        return uint16;
    }

    public static int getIntegerFromNextText(XmlPullParser parser2) throws XmlPullParserException, IOException {
        String intString = parser2.nextText();
        return Integer.valueOf(intString);
    }

    public static Long getLongAttribute(XmlPullParser parser2, String name) {
        String valueString = parser2.getAttributeValue("", name);
        if (valueString == null) {
            return null;
        }
        return Long.valueOf(valueString);
    }

    public static long getLongAttribute(XmlPullParser parser2, String name, long defaultValue) {
        Long l = ParserUtils.getLongAttribute(parser2, name);
        if (l == null) {
            return defaultValue;
        }
        return l;
    }

    public static UInt32 getUInt32Attribute(XmlPullParser parser2, String name) {
        Long l = ParserUtils.getLongAttribute(parser2, name);
        if (l == null) {
            return null;
        }
        return UInt32.from(l);
    }

    public static double getDoubleFromNextText(XmlPullParser parser2) throws XmlPullParserException, IOException {
        String doubleString = parser2.nextText();
        return Double.valueOf(doubleString);
    }

    public static Double getDoubleAttribute(XmlPullParser parser2, String name) {
        String valueString = parser2.getAttributeValue("", name);
        if (valueString == null) {
            return null;
        }
        return Double.valueOf(valueString);
    }

    public static double getDoubleAttribute(XmlPullParser parser2, String name, long defaultValue) {
        Double d = ParserUtils.getDoubleAttribute(parser2, name);
        if (d == null) {
            return defaultValue;
        }
        return d;
    }

    public static Short getShortAttribute(XmlPullParser parser2, String name) {
        String valueString = parser2.getAttributeValue("", name);
        if (valueString == null) {
            return null;
        }
        return Short.valueOf(valueString);
    }

    public static short getShortAttribute(XmlPullParser parser2, String name, short defaultValue) {
        Short s2 = ParserUtils.getShortAttribute(parser2, name);
        if (s2 == null) {
            return defaultValue;
        }
        return s2;
    }

    public static Date getDateFromOptionalXep82String(String dateString) throws SmackParsingException.SmackTextParseException {
        if (dateString == null) {
            return null;
        }
        return ParserUtils.getDateFromXep82String(dateString);
    }

    public static Date getDateFromXep82String(String dateString) throws SmackParsingException.SmackTextParseException {
        try {
            return XmppDateTime.parseXEP0082Date(dateString);
        }
        catch (ParseException e) {
            throw new SmackParsingException.SmackTextParseException(e);
        }
    }

    public static Date getDateFromString(String dateString) throws SmackParsingException.SmackTextParseException {
        try {
            return XmppDateTime.parseDate(dateString);
        }
        catch (ParseException e) {
            throw new SmackParsingException.SmackTextParseException(e);
        }
    }

    public static Date getDateFromNextText(XmlPullParser parser2) throws XmlPullParserException, IOException, SmackParsingException.SmackTextParseException {
        String dateString = parser2.nextText();
        return ParserUtils.getDateFromString(dateString);
    }

    public static URI getUriFromNextText(XmlPullParser parser2) throws XmlPullParserException, IOException, SmackParsingException.SmackUriSyntaxParsingException {
        String uriString = parser2.nextText();
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new SmackParsingException.SmackUriSyntaxParsingException(e);
        }
    }

    public static String getRequiredAttribute(XmlPullParser parser2, String name) throws IOException {
        String value2 = parser2.getAttributeValue("", name);
        if (StringUtils.isNullOrEmpty((CharSequence)value2)) {
            throw new IOException("Attribute " + name + " is null or empty (" + value2 + ')');
        }
        return value2;
    }

    public static String getRequiredNextText(XmlPullParser parser2) throws XmlPullParserException, IOException {
        String text = parser2.nextText();
        if (StringUtils.isNullOrEmpty((CharSequence)text)) {
            throw new IOException("Next text is null or empty (" + text + ')');
        }
        return text;
    }

    public static String getXmlLang(XmlPullParser parser2, XmlEnvironment xmlEnvironment) {
        String currentXmlLang = ParserUtils.getXmlLang(parser2);
        if (currentXmlLang != null) {
            return currentXmlLang;
        }
        return xmlEnvironment.getEffectiveLanguage();
    }

    public static String getXmlLang(XmlPullParser parser2) {
        return parser2.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
    }

    @Deprecated
    public static QName getQName(XmlPullParser parser2) {
        return parser2.getQName();
    }

    public static InternetAddress getInternetAddressIngoringZoneIdAttribute(XmlPullParser parser2, String attribute) {
        String inetAddressString = parser2.getAttributeValue(attribute);
        if (inetAddressString == null) {
            return null;
        }
        return InternetAddress.fromIgnoringZoneId(inetAddressString);
    }
}

