/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_msl_shader_input")
public class SpvcMslShaderInput
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOCATION;
    public static final int FORMAT;
    public static final int BUILTIN;
    public static final int VECSIZE;

    public SpvcMslShaderInput(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SpvcMslShaderInput.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int location() {
        return SpvcMslShaderInput.nlocation(this.address());
    }

    @NativeType(value="spvc_msl_vertex_format")
    public int format() {
        return SpvcMslShaderInput.nformat(this.address());
    }

    @NativeType(value="SpvBuiltIn")
    public int builtin() {
        return SpvcMslShaderInput.nbuiltin(this.address());
    }

    @NativeType(value="unsigned")
    public int vecsize() {
        return SpvcMslShaderInput.nvecsize(this.address());
    }

    public SpvcMslShaderInput location(@NativeType(value="unsigned") int value) {
        SpvcMslShaderInput.nlocation(this.address(), value);
        return this;
    }

    public SpvcMslShaderInput format(@NativeType(value="spvc_msl_vertex_format") int value) {
        SpvcMslShaderInput.nformat(this.address(), value);
        return this;
    }

    public SpvcMslShaderInput builtin(@NativeType(value="SpvBuiltIn") int value) {
        SpvcMslShaderInput.nbuiltin(this.address(), value);
        return this;
    }

    public SpvcMslShaderInput vecsize(@NativeType(value="unsigned") int value) {
        SpvcMslShaderInput.nvecsize(this.address(), value);
        return this;
    }

    public SpvcMslShaderInput set(int location, int format, int builtin, int vecsize) {
        this.location(location);
        this.format(format);
        this.builtin(builtin);
        this.vecsize(vecsize);
        return this;
    }

    public SpvcMslShaderInput set(SpvcMslShaderInput src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SpvcMslShaderInput malloc() {
        return (SpvcMslShaderInput)SpvcMslShaderInput.wrap(SpvcMslShaderInput.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static SpvcMslShaderInput calloc() {
        return (SpvcMslShaderInput)SpvcMslShaderInput.wrap(SpvcMslShaderInput.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static SpvcMslShaderInput create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (SpvcMslShaderInput)SpvcMslShaderInput.wrap(SpvcMslShaderInput.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static SpvcMslShaderInput create(long address) {
        return (SpvcMslShaderInput)SpvcMslShaderInput.wrap(SpvcMslShaderInput.class, (long)address);
    }

    @Nullable
    public static SpvcMslShaderInput createSafe(long address) {
        return address == 0L ? null : (SpvcMslShaderInput)SpvcMslShaderInput.wrap(SpvcMslShaderInput.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)SpvcMslShaderInput.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)SpvcMslShaderInput.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)SpvcMslShaderInput.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcMslShaderInput.__create((int)capacity, (int)SIZEOF);
        return (Buffer)SpvcMslShaderInput.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)SpvcMslShaderInput.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)SpvcMslShaderInput.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static SpvcMslShaderInput malloc(MemoryStack stack) {
        return (SpvcMslShaderInput)SpvcMslShaderInput.wrap(SpvcMslShaderInput.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SpvcMslShaderInput calloc(MemoryStack stack) {
        return (SpvcMslShaderInput)SpvcMslShaderInput.wrap(SpvcMslShaderInput.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)SpvcMslShaderInput.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)SpvcMslShaderInput.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nlocation(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOCATION);
    }

    public static int nformat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static int nbuiltin(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUILTIN);
    }

    public static int nvecsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)VECSIZE);
    }

    public static void nlocation(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LOCATION, value);
    }

    public static void nformat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FORMAT, value);
    }

    public static void nbuiltin(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUILTIN, value);
    }

    public static void nvecsize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VECSIZE, value);
    }

    static {
        Struct.Layout layout = SpvcMslShaderInput.__struct((Struct.Member[])new Struct.Member[]{SpvcMslShaderInput.__member((int)4), SpvcMslShaderInput.__member((int)4), SpvcMslShaderInput.__member((int)4), SpvcMslShaderInput.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOCATION = layout.offsetof(0);
        FORMAT = layout.offsetof(1);
        BUILTIN = layout.offsetof(2);
        VECSIZE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SpvcMslShaderInput, Buffer>
    implements NativeResource {
        private static final SpvcMslShaderInput ELEMENT_FACTORY = SpvcMslShaderInput.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected SpvcMslShaderInput getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned")
        public int location() {
            return SpvcMslShaderInput.nlocation(this.address());
        }

        @NativeType(value="spvc_msl_vertex_format")
        public int format() {
            return SpvcMslShaderInput.nformat(this.address());
        }

        @NativeType(value="SpvBuiltIn")
        public int builtin() {
            return SpvcMslShaderInput.nbuiltin(this.address());
        }

        @NativeType(value="unsigned")
        public int vecsize() {
            return SpvcMslShaderInput.nvecsize(this.address());
        }

        public Buffer location(@NativeType(value="unsigned") int value) {
            SpvcMslShaderInput.nlocation(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="spvc_msl_vertex_format") int value) {
            SpvcMslShaderInput.nformat(this.address(), value);
            return this;
        }

        public Buffer builtin(@NativeType(value="SpvBuiltIn") int value) {
            SpvcMslShaderInput.nbuiltin(this.address(), value);
            return this;
        }

        public Buffer vecsize(@NativeType(value="unsigned") int value) {
            SpvcMslShaderInput.nvecsize(this.address(), value);
            return this;
        }
    }
}

