/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spec;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.Response;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.spec.ClientRequestContextImpl;
import org.apache.cxf.jaxrs.client.spec.ClientResponseContextImpl;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;

public class ClientResponseFilterInterceptor
extends AbstractInDatabindingInterceptor {
    public ClientResponseFilterInterceptor() {
        super("pre-protocol-frontend");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message inMessage) throws Fault {
        ClientProviderFactory pf = ClientProviderFactory.getInstance(inMessage);
        if (pf == null) {
            return;
        }
        List<ProviderInfo<ClientResponseFilter>> filters = pf.getClientResponseFilters();
        if (!filters.isEmpty()) {
            ClientRequestContextImpl reqContext = new ClientRequestContextImpl(inMessage.getExchange().getOutMessage(), true);
            ResponseImpl response = (ResponseImpl)this.getResponse(inMessage);
            ClientResponseContextImpl respContext = new ClientResponseContextImpl(response, inMessage);
            for (ProviderInfo<ClientResponseFilter> filter : filters) {
                InjectionUtils.injectContexts((Object)filter.getProvider(), filter, (Message)inMessage);
                try {
                    ((ClientResponseFilter)filter.getProvider()).filter((ClientRequestContext)reqContext, (ClientResponseContext)respContext);
                }
                catch (IOException | RuntimeException ex) {
                    if (!inMessage.getExchange().isOneWay()) {
                        Exchange exchange = inMessage.getExchange();
                        synchronized (exchange) {
                            inMessage.getExchange().put((Object)"IN_CHAIN_COMPLETE", (Object)Boolean.TRUE);
                        }
                    }
                    throw new ResponseProcessingException((Response)response, (Throwable)ex);
                }
            }
        }
    }

    protected Response getResponse(Message inMessage) {
        Response resp = (Response)inMessage.getExchange().get(Response.class);
        if (resp != null) {
            return JAXRSUtils.copyResponseIfNeeded((Response)resp);
        }
        Response.ResponseBuilder rb = JAXRSUtils.toResponseBuilder((int)((Integer)inMessage.get((Object)Message.RESPONSE_CODE)));
        rb.entity(inMessage.get(InputStream.class));
        Map protocolHeaders = (Map)inMessage.get((Object)Message.PROTOCOL_HEADERS);
        for (Map.Entry entry : protocolHeaders.entrySet()) {
            if (null == entry.getKey() || ((List)entry.getValue()).size() <= 0) continue;
            for (String val : (List)entry.getValue()) {
                rb.header((String)entry.getKey(), (Object)val);
            }
        }
        return rb.build();
    }
}

