/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.series;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.knowm.xchart.internal.series.MarkerSeries;
import org.knowm.xchart.internal.series.Series;

public abstract class AxesChartSeriesCategory
extends MarkerSeries {
    List<?> xData;
    List<? extends Number> yData;
    List<? extends Number> extraValues;

    public AxesChartSeriesCategory(String name, List<?> xData, List<? extends Number> yData, List<? extends Number> extraValues, Series.DataType xAxisDataType) {
        super(name, xAxisDataType);
        this.xData = xData;
        this.yData = yData;
        this.extraValues = extraValues;
        this.calculateMinMax();
    }

    public void replaceData(List<?> newXData, List<? extends Number> newYData, List<? extends Number> newExtraValues) {
        if (newExtraValues != null && newExtraValues.size() != newYData.size()) {
            throw new IllegalArgumentException("error bars and Y-Axis sizes are not the same!!!");
        }
        if (newXData.size() != newYData.size()) {
            throw new IllegalArgumentException("X and Y-Axis sizes are not the same!!!");
        }
        this.xData = newXData;
        this.yData = newYData;
        this.extraValues = newExtraValues;
        this.calculateMinMax();
    }

    public void replaceData(List<? extends Number> newYData) {
        this.yData = newYData;
        this.calculateMinMax();
    }

    @Override
    protected void calculateMinMax() {
        double[] xMinMax = this.findMinMax(this.xData, this.xAxisDataType);
        this.xMin = xMinMax[0];
        this.xMax = xMinMax[1];
        double[] yMinMax = this.extraValues == null ? this.findMinMax(this.yData, this.yAxisType) : this.findMinMaxWithErrorBars(this.yData, this.extraValues);
        this.yMin = yMinMax[0];
        this.yMax = yMinMax[1];
    }

    private double[] findMinMaxWithErrorBars(Collection<? extends Number> data, Collection<? extends Number> errorBars) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        Iterator<? extends Number> itr = data.iterator();
        Iterator<? extends Number> ebItr = errorBars.iterator();
        while (itr.hasNext()) {
            double eb;
            double bigDecimal = itr.next().doubleValue();
            if (bigDecimal - (eb = ebItr.next().doubleValue()) < min) {
                min = bigDecimal - eb;
            }
            if (!(bigDecimal + eb > max)) continue;
            max = bigDecimal + eb;
        }
        return new double[]{min, max};
    }

    double[] findMinMax(Collection<?> data, Series.DataType dataType) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (Object dataPoint : data) {
            if (dataPoint == null) continue;
            double value = 0.0;
            if (dataType == Series.DataType.Number) {
                value = ((Number)dataPoint).doubleValue();
            } else if (dataType == Series.DataType.Date) {
                Date date = (Date)dataPoint;
                value = date.getTime();
            } else if (dataType == Series.DataType.String) {
                return new double[]{Double.NaN, Double.NaN};
            }
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        return new double[]{min, max};
    }

    public Collection<?> getXData() {
        return this.xData;
    }

    public Collection<? extends Number> getYData() {
        return this.yData;
    }

    public Collection<? extends Number> getExtraValues() {
        return this.extraValues;
    }
}

