/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.types;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import javax.measure.quantity.Dimensionless;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.HSBType;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.library.types.OpenClosedType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.library.types.UpDownType;
import org.openhab.core.library.unit.Units;
import org.openhab.core.types.State;

@NonNullByDefault
public class PercentType
extends DecimalType {
    private static final long serialVersionUID = -9066279845951780879L;
    public static final PercentType ZERO = new PercentType(0);
    public static final PercentType HUNDRED = new PercentType(100);

    public PercentType() {
        this(0);
    }

    public PercentType(int value) {
        super(value);
        this.validateValue(this.value);
    }

    public PercentType(String value) {
        this(value, Locale.ENGLISH);
    }

    public PercentType(String value, Locale locale) {
        super(value, locale);
        this.validateValue(this.value);
    }

    public PercentType(BigDecimal value) {
        super(value);
        this.validateValue(this.value);
    }

    private void validateValue(BigDecimal value) {
        if (BigDecimal.ZERO.compareTo(value) > 0 || BIG_DECIMAL_HUNDRED.compareTo(value) < 0) {
            throw new IllegalArgumentException("Value must be between 0 and 100");
        }
    }

    public static PercentType valueOf(String value) {
        return new PercentType(value);
    }

    @Override
    public <T extends State> @Nullable T as(@Nullable Class<T> target) {
        if (target == OnOffType.class) {
            return (T)((State)target.cast(OnOffType.from(!this.equals(ZERO))));
        }
        if (target == DecimalType.class) {
            return (T)((State)target.cast(new DecimalType(this.toBigDecimal().divide(BIG_DECIMAL_HUNDRED, 8, RoundingMode.UP))));
        }
        if (target == UpDownType.class) {
            if (this.equals(ZERO)) {
                return (T)((State)target.cast(UpDownType.UP));
            }
            if (this.equals(HUNDRED)) {
                return (T)((State)target.cast(UpDownType.DOWN));
            }
            return null;
        }
        if (target == OpenClosedType.class) {
            if (this.equals(ZERO)) {
                return (T)((State)target.cast(OpenClosedType.CLOSED));
            }
            if (this.equals(HUNDRED)) {
                return (T)((State)target.cast(OpenClosedType.OPEN));
            }
            return null;
        }
        if (target == HSBType.class) {
            return (T)((State)target.cast(new HSBType(DecimalType.ZERO, ZERO, this)));
        }
        if (target == QuantityType.class) {
            return (T)((State)target.cast(new QuantityType<Dimensionless>(this.toBigDecimal(), Units.PERCENT)));
        }
        return this.defaultConversion(target);
    }
}

