/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util.collections;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class NodeList<N extends Node<N>> {
    @Nullable
    private N first;
    @Nullable
    private N last;
    private int size;

    public void add(@NotNull N node) {
        assert (((Node)node).prev == null);
        assert (((Node)node).next == null);
        N last = this.last;
        if (last == null) {
            this.last = node;
            this.first = this.last;
        } else {
            ((Node)last).next = node;
            ((Node)node).prev = last;
            this.last = node;
        }
        ++this.size;
    }

    public void addFirst(@NotNull N node) {
        assert (((Node)node).prev == null);
        assert (((Node)node).next == null);
        N first = this.first;
        if (first == null) {
            this.last = node;
            this.first = this.last;
        } else {
            ((Node)first).prev = node;
            ((Node)node).next = first;
            this.first = node;
        }
        ++this.size;
    }

    public void remove(@NotNull N node) {
        assert (((Node)node).prev != null || node == this.first);
        assert (((Node)node).next != null || node == this.last);
        assert (this.size > 0);
        Object prev = ((Node)node).prev;
        Object next = ((Node)node).next;
        if (prev == null) {
            this.first = next;
        } else {
            ((Node)prev).next = next;
        }
        if (next == null) {
            this.last = prev;
        } else {
            ((Node)next).prev = prev;
        }
        --this.size;
    }

    public void replace(@NotNull N oldNode, @NotNull N newNode) {
        assert (((Node)oldNode).prev != null || oldNode == this.first);
        assert (((Node)oldNode).next != null || oldNode == this.last);
        assert (((Node)newNode).prev == null);
        assert (((Node)newNode).next == null);
        assert (this.size > 0);
        Object prev = ((Node)oldNode).prev;
        Object next = ((Node)oldNode).next;
        ((Node)newNode).prev = prev;
        ((Node)newNode).next = next;
        if (prev == null) {
            this.first = newNode;
        } else {
            ((Node)prev).next = newNode;
        }
        if (next == null) {
            this.last = newNode;
        } else {
            ((Node)next).prev = newNode;
        }
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.first = null;
        this.last = null;
        this.size = 0;
    }

    @Nullable
    public N getFirst() {
        return this.first;
    }

    @Nullable
    public N getLast() {
        return this.last;
    }

    public static abstract class Node<N extends Node<N>> {
        @Nullable
        N prev;
        @Nullable
        N next;

        @Nullable
        public N getPrev() {
            return this.prev;
        }

        @Nullable
        public N getNext() {
            return this.next;
        }
    }
}

