untrusted comment: verify with openbsd-63-base.pub
RWRxzbLwAd76ZUM+dt82fUaHAN0qXuHwjCHllGJzUStloc3vj82tVpQYGU1vyxdB7qer+gTdbV59TSaeboaV6BO+70xK++IAcQg=

OpenBSD 6.3 errata 017, August 24, 2018:

State from the FPU of one user land process could be exposed to
other processes.

Apply by doing:
    signify -Vep /etc/signify/openbsd-63-base.pub -x 017_fpufork.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/amd64/amd64/vm_machdep.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/amd64/vm_machdep.c,v
retrieving revision 1.41.2.1
diff -u -p -r1.41.2.1 vm_machdep.c
--- sys/arch/amd64/amd64/vm_machdep.c	16 Jun 2018 20:37:22 -0000	1.41.2.1
+++ sys/arch/amd64/amd64/vm_machdep.c	21 Aug 2018 19:43:49 -0000
@@ -65,13 +65,15 @@ void
 cpu_fork(struct proc *p1, struct proc *p2, void *stack, void *tcb,
     void (*func)(void *), void *arg)
 {
+	struct cpu_info *ci = curcpu();
 	struct pcb *pcb = &p2->p_addr->u_pcb;
 	struct pcb *pcb1 = &p1->p_addr->u_pcb;
 	struct trapframe *tf;
 	struct switchframe *sf;
 
 	/* Save the fpu h/w state to p1's pcb so that we can copy it. */
-	fpusave(&pcb1->pcb_savefpu);
+	if (p1 != &proc0 && (ci->ci_flags & CPUF_USERXSTATE))
+		fpusave(&pcb1->pcb_savefpu);
 
 	p2->p_md.md_flags = p1->p_md.md_flags;
 
