untrusted comment: verify with openbsd-64-base.pub
RWQq6XmS4eDAcah3IsnruoS7xhEuKhRgSGk/JeFBW+k348zmpNsAGJsKtf6Bqk8n4d5sLmhh/Dq3H1xGRB3nLRime1Ij/4N64gE=

OpenBSD 6.4 errata 026, October 5, 2019:

dhcpd leaks 4-bytes of stack to the network.

Apply by doing:
    signify -Vep /etc/signify/openbsd-64-base.pub -x 026_dhcpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install dhcpd:

    cd /usr/src/usr.sbin/dhcpd
    make obj
    make
    make install

Index: usr.sbin/dhcpd/icmp.c
===================================================================
RCS file: /cvs/src/usr.sbin/dhcpd/icmp.c,v
diff -u -p -r1.18 icmp.c
--- usr.sbin/dhcpd/icmp.c	13 Feb 2017 23:04:05 -0000	1.18
+++ usr.sbin/dhcpd/icmp.c	3 Oct 2019 14:26:11 -0000
@@ -107,10 +107,8 @@ icmp_echorequest(struct iaddr *addr)
 	to.sin_family = AF_INET;
 	memcpy(&to.sin_addr, addr->iabuf, sizeof to.sin_addr);	/* XXX */
 
+	memset(&icmp, 0, sizeof(icmp));
 	icmp.icmp_type = ICMP_ECHO;
-	icmp.icmp_code = 0;
-	icmp.icmp_cksum = 0;
-	icmp.icmp_seq = 0;
 	icmp.icmp_id = getpid() & 0xffff;
 
 	icmp.icmp_cksum = wrapsum(checksum((unsigned char *)&icmp,
