untrusted comment: verify with openbsd-66-base.pub
RWSvK/c+cFe24AAVIKUHyFk+Oq8bEygM1dNcin1jc5L9sRM29hPtVLVICfx2Ijbec4FnO5GT3/M1dur1pSsQ1CjUYcVrRGftxgQ=

OpenBSD 6.6 errata 022, March 10, 2020:

Missing input validation in sysctl(2) can be used to crash the kernel.

Apply by doing:
    signify -Vep /etc/signify/openbsd-66-base.pub -x 022_sysctl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/kern_sysctl.c
===================================================================
RCS file: /var/cvs/src/sys/kern/kern_sysctl.c,v
retrieving revision 1.366
diff -u -p -r1.366 kern_sysctl.c
--- sys/kern/kern_sysctl.c	21 Aug 2019 20:44:09 -0000	1.366
+++ sys/kern/kern_sysctl.c	10 Mar 2020 03:40:48 -0000
@@ -1494,7 +1494,7 @@ sysctl_doproc(int *name, u_int namelen, 
 	buflen = where != NULL ? *sizep : 0;
 	needed = error = 0;
 
-	if (namelen != 4 || name[2] < 0 || name[3] < 0 ||
+	if (namelen != 4 || name[2] <= 0 || name[3] < 0 ||
 	    name[2] > sizeof(*kproc))
 		return (EINVAL);
 	op = name[0];
