untrusted comment: verify with openbsd-66-base.pub
RWSvK/c+cFe24DlK1w9Vb7zo+dUEjn6kHDMFmKN0stczXVpvq8s60Ijg+vrlweT7QqxTeIXEqDPRzRm/YHpTf9sGuC+iAXZA4wE=

OpenBSD 6.6 errata 009, December 3, 2019:

Environment-provided paths are used for dlopen() in mesa, resulting in
escalation to the auth group in xlock(1).

Apply by doing:
    signify -Vep /etc/signify/openbsd-66-base.pub -x 009_mesaxlock.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then compile and rebuild Mesa and xlock
    cd /usr/xenocara/lib/mesa
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build
    cd /usr/xenocara/app/xlockmore
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: lib/mesa/src/loader/loader.c
===================================================================
RCS file: /cvs/xenocara/lib/mesa/src/loader/loader.c,v
diff -u -p -u -r1.7 loader.c
--- lib/mesa/src/loader/loader.c	23 May 2019 05:33:29 -0000	1.7
+++ lib/mesa/src/loader/loader.c	3 Dec 2019 01:03:52 -0000
@@ -445,7 +445,7 @@ loader_get_driver_for_fd(int fd)
     * user's problem, but this allows vc4 simulator to run on an i965 host,
     * and may be useful for some touch testing of i915 on an i965 host.
     */
-   if (geteuid() == getuid()) {
+   if (issetugid() == 0 && geteuid() == getuid()) {
       driver = getenv("MESA_LOADER_DRIVER_OVERRIDE");
       if (driver)
          return strdup(driver);
@@ -533,7 +533,7 @@ loader_open_driver(const char *driver_na
    const struct __DRIextensionRec **(*get_extensions)(void);
 
    search_paths = NULL;
-   if (geteuid() == getuid() && search_path_vars) {
+   if (issetugid() == 0 && geteuid() == getuid() && search_path_vars) {
       for (int i = 0; search_path_vars[i] != NULL; i++) {
          search_paths = getenv(search_path_vars[i]);
          if (search_paths)
Index: app/xlockmore/Makefile.bsd-wrapper
===================================================================
RCS file: /cvs/xenocara/app/xlockmore/Makefile.bsd-wrapper,v
diff -u -p -u -r1.13 Makefile.bsd-wrapper
--- app/xlockmore/Makefile.bsd-wrapper	7 Mar 2017 21:35:57 -0000	1.13
+++ app/xlockmore/Makefile.bsd-wrapper	3 Dec 2019 01:03:56 -0000
@@ -17,6 +17,7 @@ config.status:
 		--enable-appdefaultdir=${X11BASE}/share/X11/app-defaults \
 		--enable-syslog --without-motif --without-ttf \
 		--without-gtk2 --without-gtk --without-esound \
-		--without-rplay --without-ftgl
+		--without-rplay --without-ftgl \
+		--without-opengl --without-mesa
 
 .include <bsd.xorg.mk>
