untrusted comment: verify with openbsd-68-base.pub
RWQZj25CSG5R2vniFPUQGDibH0VESLI2wHb/lX6d7WGqlquiJhbF0PGD67evt0aJooGPYbwWDvHHCfSK/A99dihk4M4aQny+0QY=

OpenBSD 6.8 errata 018, April 13, 2021:

Input validation failures in X server XInput extension can lead to
privileges elevations for authorized clients.

Apply by doing:
    signify -Vep /etc/signify/openbsd-68-base.pub -x 018_xi.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then compile and rebuild the X server
    cd /usr/xenocara/xserver
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: xserver/Xi/chgfctl.c
===================================================================
RCS file: /cvs/xenocara/xserver/Xi/chgfctl.c,v
retrieving revision 1.7
diff -u -p -r1.7 chgfctl.c
--- xserver/Xi/chgfctl.c	27 Jul 2019 07:57:08 -0000	1.7
+++ xserver/Xi/chgfctl.c	5 Apr 2021 22:24:13 -0000
@@ -464,8 +464,11 @@ ProcXChangeFeedbackControl(ClientPtr cli
         break;
     case StringFeedbackClass:
     {
-        xStringFeedbackCtl *f = ((xStringFeedbackCtl *) &stuff[1]);
+        xStringFeedbackCtl *f;
 
+        REQUEST_AT_LEAST_EXTRA_SIZE(xChangeFeedbackControlReq,
+                                    sizeof(xStringFeedbackCtl));
+        f = ((xStringFeedbackCtl *) &stuff[1]);
         if (client->swapped) {
             if (len < bytes_to_int32(sizeof(xStringFeedbackCtl)))
                 return BadLength;
