untrusted comment: verify with openbsd-71-base.pub
RWR2eHwZTOEiTde5g4Es9gN/MpoeURhIOTeUPUUscI6nKa+FJvpzC1pW0ocOR+g+Vj2AAfVbmHR9IQrouS4GR38YJoC2yS+Jxwg=

OpenBSD 7.1 errata 001, April 22, 2022:

Many wireless network drivers could not scan access points correctly.

Apply by doing:
    signify -Vep /etc/signify/openbsd-71-base.pub -x 001_wifi.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/ic/acx.c
===================================================================
RCS file: /cvs/src/sys/dev/ic/acx.c,v
retrieving revision 1.126
diff -u -p -r1.126 acx.c
--- sys/dev/ic/acx.c	9 Jan 2022 05:42:38 -0000	1.126
+++ sys/dev/ic/acx.c	21 Apr 2022 22:24:17 -0000
@@ -1354,7 +1354,7 @@ acx_rxeof(struct acx_softc *sc)
 			    sc->chip_rxbuf_exhdr);
 			wh = mtod(m, struct ieee80211_frame *);
 
-			rxi.rxi_flags = 0;
+			memset(&rxi, 0, sizeof(rxi));
 			if ((wh->i_fc[1] & IEEE80211_FC1_WEP) &&
 			    sc->chip_hw_crypt) {
 				/* Short circuit software WEP */
Index: sys/dev/ic/an.c
===================================================================
RCS file: /cvs/src/sys/dev/ic/an.c,v
retrieving revision 1.78
diff -u -p -r1.78 an.c
--- sys/dev/ic/an.c	25 Feb 2021 02:48:20 -0000	1.78
+++ sys/dev/ic/an.c	21 Apr 2022 22:24:17 -0000
@@ -462,7 +462,7 @@ an_rxeof(struct an_softc *sc)
 #endif /* NBPFILTER > 0 */
 
 	wh = mtod(m, struct ieee80211_frame *);
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	if (wh->i_fc[1] & IEEE80211_FC1_WEP) {
 		/*
 		 * WEP is decrypted by hardware. Clear WEP bit
Index: sys/dev/ic/ar5008.c
===================================================================
RCS file: /cvs/src/sys/dev/ic/ar5008.c,v
retrieving revision 1.69
diff -u -p -r1.69 ar5008.c
--- sys/dev/ic/ar5008.c	11 Oct 2021 09:01:05 -0000	1.69
+++ sys/dev/ic/ar5008.c	21 Apr 2022 22:24:17 -0000
@@ -1039,7 +1039,7 @@ ar5008_rx_process(struct athn_softc *sc,
 	m_adj(m, -IEEE80211_CRC_LEN);
 
 	/* Send the frame to the 802.11 layer. */
-	rxi.rxi_flags = 0;	/* XXX */
+	memset(&rxi, 0, sizeof(rxi));
 	rxi.rxi_rssi = MS(ds->ds_status4, AR_RXS4_RSSI_COMBINED);
 	rxi.rxi_rssi += AR_DEFAULT_NOISE_FLOOR;
 	rxi.rxi_tstamp = ds->ds_status2;
Index: sys/dev/ic/ar9003.c
===================================================================
RCS file: /cvs/src/sys/dev/ic/ar9003.c,v
retrieving revision 1.54
diff -u -p -r1.54 ar9003.c
--- sys/dev/ic/ar9003.c	9 Jan 2022 05:42:38 -0000	1.54
+++ sys/dev/ic/ar9003.c	21 Apr 2022 22:24:18 -0000
@@ -1026,7 +1026,7 @@ ar9003_rx_process(struct athn_softc *sc,
 	m_adj(m, -IEEE80211_CRC_LEN);
 
 	/* Send the frame to the 802.11 layer. */
-	rxi.rxi_flags = 0;	/* XXX */
+	memset(&rxi, 0, sizeof(rxi));
 	rxi.rxi_rssi = MS(ds->ds_status5, AR_RXS5_RSSI_COMBINED);
 	rxi.rxi_tstamp = ds->ds_status3;
 	ieee80211_inputm(ifp, m, ni, &rxi, ml);
Index: sys/dev/ic/ath.c
===================================================================
RCS file: /cvs/src/sys/dev/ic/ath.c,v
retrieving revision 1.122
diff -u -p -r1.122 ath.c
--- sys/dev/ic/ath.c	11 Oct 2020 07:05:28 -0000	1.122
+++ sys/dev/ic/ath.c	21 Apr 2022 22:24:18 -0000
@@ -1936,7 +1936,7 @@ ath_rx_proc(void *arg, int npending)
 #endif
 		m_adj(m, -IEEE80211_CRC_LEN);
 		wh = mtod(m, struct ieee80211_frame *);
-		rxi.rxi_flags = 0;
+		memset(&rxi, 0, sizeof(rxi));
 		if (!ath_softcrypto && (wh->i_fc[1] & IEEE80211_FC1_WEP)) {
 			/*
 			 * WEP is decrypted by hardware. Clear WEP bit
Index: sys/dev/ic/atw.c
===================================================================
RCS file: /cvs/src/sys/dev/ic/atw.c,v
retrieving revision 1.99
diff -u -p -r1.99 atw.c
--- sys/dev/ic/atw.c	9 Jan 2022 05:42:38 -0000	1.99
+++ sys/dev/ic/atw.c	21 Apr 2022 22:24:18 -0000
@@ -3175,7 +3175,7 @@ atw_rxintr(struct atw_softc *sc)
 
 		wh = mtod(m, struct ieee80211_frame *);
 		ni = ieee80211_find_rxnode(ic, wh);
-		rxi.rxi_flags = 0;
+		memset(&rxi, 0, sizeof(rxi));
 #if 0
 		if (atw_hw_decrypted(sc, wh)) {
 			wh->i_fc[1] &= ~IEEE80211_FC1_WEP;
@@ -3183,7 +3183,6 @@ atw_rxintr(struct atw_softc *sc)
 		}
 #endif
 		rxi.rxi_rssi = (int)rssi;
-		rxi.rxi_tstamp = 0;
 		ieee80211_inputm(ifp, m, ni, &rxi, &ml);
 		/*
 		 * The frame may have caused the node to be marked for
Index: sys/dev/ic/bwfm.c
===================================================================
RCS file: /cvs/src/sys/dev/ic/bwfm.c,v
retrieving revision 1.102
diff -u -p -r1.102 bwfm.c
--- sys/dev/ic/bwfm.c	20 Mar 2022 12:01:58 -0000	1.102
+++ sys/dev/ic/bwfm.c	21 Apr 2022 22:24:19 -0000
@@ -2439,9 +2439,7 @@ bwfm_rx_auth_ind(struct bwfm_softc *sc, 
 
 	/* Finalize mbuf. */
 	m->m_pkthdr.len = m->m_len = pktlen;
-	rxi.rxi_flags = 0;
-	rxi.rxi_rssi = 0;
-	rxi.rxi_tstamp = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	ieee80211_input(ifp, m, ic->ic_bss, &rxi);
 }
 
@@ -2495,9 +2493,7 @@ bwfm_rx_assoc_ind(struct bwfm_softc *sc,
 		m_freem(m);
 		return;
 	}
-	rxi.rxi_flags = 0;
-	rxi.rxi_rssi = 0;
-	rxi.rxi_tstamp = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	ieee80211_input(ifp, m, ni, &rxi);
 }
 
@@ -2550,9 +2546,7 @@ bwfm_rx_leave_ind(struct bwfm_softc *sc,
 		m_freem(m);
 		return;
 	}
-	rxi.rxi_flags = 0;
-	rxi.rxi_rssi = 0;
-	rxi.rxi_tstamp = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	ieee80211_input(ifp, m, ni, &rxi);
 }
 #endif
@@ -2740,9 +2734,8 @@ bwfm_scan_node(struct bwfm_softc *sc, st
 	/* Channel mask equals IEEE80211_CHAN_MAX */
 	chanidx = bwfm_spec2chan(sc, letoh32(bss->chanspec));
 	/* Supply RSSI */
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	rxi.rxi_rssi = (int16_t)letoh16(bss->rssi);
-	rxi.rxi_tstamp = 0;
 	rxi.rxi_chan = chanidx;
 	ieee80211_input(ifp, m, ni, &rxi);
 	/* Node is no longer needed. */
Index: sys/dev/ic/bwi.c
===================================================================
RCS file: /cvs/src/sys/dev/ic/bwi.c,v
retrieving revision 1.132
diff -u -p -r1.132 bwi.c
--- sys/dev/ic/bwi.c	9 Jan 2022 05:42:38 -0000	1.132
+++ sys/dev/ic/bwi.c	21 Apr 2022 22:24:19 -0000
@@ -8454,6 +8454,7 @@ bwi_rxeof(struct bwi_softc *sc, int end_
 		ni = ieee80211_find_rxnode(ic, wh);
 		type = wh->i_fc[0] & IEEE80211_FC0_TYPE_MASK;
 
+		memset(&rxi, 0, sizeof(rxi));
 		rxi.rxi_rssi = hdr->rxh_rssi;
 		rxi.rxi_tstamp = letoh16(hdr->rxh_tsf);
 		ieee80211_inputm(ifp, m, ni, &rxi, &ml);
Index: sys/dev/ic/malo.c
===================================================================
RCS file: /cvs/src/sys/dev/ic/malo.c,v
retrieving revision 1.122
diff -u -p -r1.122 malo.c
--- sys/dev/ic/malo.c	9 Jan 2022 05:42:38 -0000	1.122
+++ sys/dev/ic/malo.c	21 Apr 2022 22:24:20 -0000
@@ -1709,9 +1709,8 @@ malo_rx_intr(struct malo_softc *sc)
 		ni = ieee80211_find_rxnode(ic, wh);
 
 		/* send the frame to the 802.11 layer */
-		rxi.rxi_flags = 0;
+		memset(&rxi, 0, sizeof(rxi));
 		rxi.rxi_rssi = desc->rssi;
-		rxi.rxi_tstamp = 0;	/* unused */
 		ieee80211_inputm(ifp, m, ni, &rxi, &ml);
 
 		/* node is no longer needed */
Index: sys/dev/ic/pgt.c
===================================================================
RCS file: /cvs/src/sys/dev/ic/pgt.c,v
retrieving revision 1.102
diff -u -p -r1.102 pgt.c
--- sys/dev/ic/pgt.c	9 Jan 2022 05:42:38 -0000	1.102
+++ sys/dev/ic/pgt.c	21 Apr 2022 22:24:20 -0000
@@ -1019,7 +1019,7 @@ input:
 				bpf_mtap(sc->sc_drvbpf, &mb, BPF_DIRECTION_IN);
 			}
 #endif
-			rxi.rxi_flags = 0;
+			memset(&rxi, 0, sizeof(rxi));
 			ni->ni_rssi = rxi.rxi_rssi = rssi;
 			ni->ni_rstamp = rxi.rxi_tstamp = rstamp;
 			ieee80211_inputm(ifp, m, ni, &rxi, &ml);
Index: sys/dev/ic/rt2560.c
===================================================================
RCS file: /cvs/src/sys/dev/ic/rt2560.c,v
retrieving revision 1.89
diff -u -p -r1.89 rt2560.c
--- sys/dev/ic/rt2560.c	9 Jan 2022 05:42:38 -0000	1.89
+++ sys/dev/ic/rt2560.c	21 Apr 2022 22:24:20 -0000
@@ -1196,7 +1196,7 @@ rt2560_decryption_intr(struct rt2560_sof
 		ni = ieee80211_find_rxnode(ic, wh);
 
 		/* send the frame to the 802.11 layer */
-		rxi.rxi_flags = 0;
+		memset(&rxi, 0, sizeof(rxi));
 		rxi.rxi_rssi = desc->rssi;
 		rxi.rxi_tstamp = 0;	/* unused */
 		ieee80211_inputm(ifp, m, ni, &rxi, &ml);
Index: sys/dev/ic/rt2661.c
===================================================================
RCS file: /cvs/src/sys/dev/ic/rt2661.c,v
retrieving revision 1.98
diff -u -p -r1.98 rt2661.c
--- sys/dev/ic/rt2661.c	20 Jul 2020 07:45:44 -0000	1.98
+++ sys/dev/ic/rt2661.c	21 Apr 2022 22:24:20 -0000
@@ -1271,9 +1271,8 @@ rt2661_rx_intr(struct rt2661_softc *sc)
 		ni = ieee80211_find_rxnode(ic, wh);
 
 		/* send the frame to the 802.11 layer */
-		rxi.rxi_flags = 0;
+		memset(&rxi, 0, sizeof(rxi));
 		rxi.rxi_rssi = desc->rssi;
-		rxi.rxi_tstamp = 0;	/* unused */
 		ieee80211_inputm(ifp, m, ni, &rxi, &ml);
 
 		/*-
Index: sys/dev/ic/rt2860.c
===================================================================
RCS file: /cvs/src/sys/dev/ic/rt2860.c,v
retrieving revision 1.101
diff -u -p -r1.101 rt2860.c
--- sys/dev/ic/rt2860.c	12 Dec 2020 11:48:52 -0000	1.101
+++ sys/dev/ic/rt2860.c	21 Apr 2022 22:24:20 -0000
@@ -1349,7 +1349,7 @@ rt2860_rx_intr(struct rt2860_softc *sc)
 		m->m_pkthdr.len = m->m_len = letoh16(rxwi->len) & 0xfff;
 
 		wh = mtod(m, struct ieee80211_frame *);
-		rxi.rxi_flags = 0;
+		memset(&rxi, 0, sizeof(rxi));
 		if (wh->i_fc[1] & IEEE80211_FC1_PROTECTED) {
 			/* frame is decrypted by hardware */
 			wh->i_fc[1] &= ~IEEE80211_FC1_PROTECTED;
@@ -1413,7 +1413,6 @@ skipbpf:
 
 		/* send the frame to the 802.11 layer */
 		rxi.rxi_rssi = rssi;
-		rxi.rxi_tstamp = 0;	/* unused */
 		ieee80211_inputm(ifp, m, ni, &rxi, &ml);
 
 		/* node is no longer needed */
Index: sys/dev/ic/rtw.c
===================================================================
RCS file: /cvs/src/sys/dev/ic/rtw.c,v
retrieving revision 1.102
diff -u -p -r1.102 rtw.c
--- sys/dev/ic/rtw.c	9 Jan 2022 05:42:39 -0000	1.102
+++ sys/dev/ic/rtw.c	21 Apr 2022 22:24:21 -0000
@@ -1287,7 +1287,7 @@ rtw_intr_rx(struct rtw_softc *sc, u_int1
 		}
 #endif /* NBPFILTER > 0 */
 
-		rxi.rxi_flags = 0;
+		memset(&rxi, 0, sizeof(rxi));
 		rxi.rxi_rssi = rssi;
 		rxi.rxi_tstamp = htsftl;
 		ieee80211_inputm(&sc->sc_if, m, ni, &rxi, &ml);
Index: sys/dev/pci/if_ipw.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/if_ipw.c,v
retrieving revision 1.131
diff -u -p -r1.131 if_ipw.c
--- sys/dev/pci/if_ipw.c	11 Mar 2022 18:00:45 -0000	1.131
+++ sys/dev/pci/if_ipw.c	21 Apr 2022 22:24:21 -0000
@@ -907,9 +907,8 @@ ipw_data_intr(struct ipw_softc *sc, stru
 	ni = ieee80211_find_rxnode(ic, wh);
 
 	/* send the frame to the upper layer */
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	rxi.rxi_rssi = status->rssi;
-	rxi.rxi_tstamp = 0;	/* unused */
 	ieee80211_inputm(ifp, m, ni, &rxi, ml);
 
 	ieee80211_release_node(ic, ni);
Index: sys/dev/pci/if_iwi.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/if_iwi.c,v
retrieving revision 1.146
diff -u -p -r1.146 if_iwi.c
--- sys/dev/pci/if_iwi.c	11 Mar 2022 18:00:45 -0000	1.146
+++ sys/dev/pci/if_iwi.c	21 Apr 2022 22:24:21 -0000
@@ -960,9 +960,8 @@ iwi_frame_intr(struct iwi_softc *sc, str
 	ni = ieee80211_find_rxnode(ic, wh);
 
 	/* send the frame to the upper layer */
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	rxi.rxi_rssi = frame->rssi_dbm;
-	rxi.rxi_tstamp = 0;	/* unused */
 	ieee80211_inputm(ifp, m, ni, &rxi, ml);
 
 	/* node is no longer needed */
Index: sys/dev/pci/if_iwn.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/if_iwn.c,v
retrieving revision 1.257
diff -u -p -r1.257 if_iwn.c
--- sys/dev/pci/if_iwn.c	20 Mar 2022 12:01:58 -0000	1.257
+++ sys/dev/pci/if_iwn.c	21 Apr 2022 22:24:21 -0000
@@ -2131,7 +2131,7 @@ iwn_rx_done(struct iwn_softc *sc, struct
 	}
 	ni = ieee80211_find_rxnode(ic, wh);
 
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	if (((wh->i_fc[0] & IEEE80211_FC0_TYPE_MASK) != IEEE80211_FC0_TYPE_CTL)
 	    && (wh->i_fc[1] & IEEE80211_FC1_PROTECTED) &&
 	    !IEEE80211_IS_MULTICAST(wh->i_addr1) &&
@@ -2218,7 +2218,6 @@ iwn_rx_done(struct iwn_softc *sc, struct
 
 	/* Send the frame to the 802.11 layer. */
 	rxi.rxi_rssi = rssi;
-	rxi.rxi_tstamp = 0;	/* unused */
 	rxi.rxi_chan = chan;
 	ieee80211_inputm(ifp, m, ni, &rxi, ml);
 
Index: sys/dev/pci/if_rtwn.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/if_rtwn.c,v
retrieving revision 1.39
diff -u -p -r1.39 if_rtwn.c
--- sys/dev/pci/if_rtwn.c	15 Mar 2022 09:22:56 -0000	1.39
+++ sys/dev/pci/if_rtwn.c	21 Apr 2022 22:24:21 -0000
@@ -972,9 +972,8 @@ rtwn_rx_frame(struct rtwn_pci_softc *sc,
 #endif
 
 	ni = ieee80211_find_rxnode(ic, wh);
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	rxi.rxi_rssi = rssi;
-	rxi.rxi_tstamp = 0;	/* Unused. */
 	ieee80211_inputm(ifp, m, ni, &rxi, ml);
 	/* Node is no longer needed. */
 	ieee80211_release_node(ic, ni);
Index: sys/dev/pci/if_wpi.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/if_wpi.c,v
retrieving revision 1.156
diff -u -p -r1.156 if_wpi.c
--- sys/dev/pci/if_wpi.c	11 Mar 2022 18:00:50 -0000	1.156
+++ sys/dev/pci/if_wpi.c	21 Apr 2022 22:24:22 -0000
@@ -1262,7 +1262,7 @@ wpi_rx_done(struct wpi_softc *sc, struct
 	wh = mtod(m, struct ieee80211_frame *);
 	ni = ieee80211_find_rxnode(ic, wh);
 
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	if ((wh->i_fc[1] & IEEE80211_FC1_PROTECTED) &&
 	    !IEEE80211_IS_MULTICAST(wh->i_addr1) &&
 	    (ni->ni_flags & IEEE80211_NODE_RXPROT) &&
@@ -1333,7 +1333,6 @@ wpi_rx_done(struct wpi_softc *sc, struct
 
 	/* Send the frame to the 802.11 layer. */
 	rxi.rxi_rssi = stat->rssi;
-	rxi.rxi_tstamp = 0;	/* unused */
 	ieee80211_inputm(ifp, m, ni, &rxi, ml);
 
 	/* Node is no longer needed. */
Index: sys/dev/usb/if_athn_usb.c
===================================================================
RCS file: /cvs/src/sys/dev/usb/if_athn_usb.c,v
retrieving revision 1.63
diff -u -p -r1.63 if_athn_usb.c
--- sys/dev/usb/if_athn_usb.c	22 Nov 2021 10:17:14 -0000	1.63
+++ sys/dev/usb/if_athn_usb.c	21 Apr 2022 22:24:22 -0000
@@ -2087,7 +2087,7 @@ athn_usb_rx_frame(struct athn_usb_softc 
 	m_adj(m, -IEEE80211_CRC_LEN);
 
 	/* Send the frame to the 802.11 layer. */
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	rxi.rxi_rssi = rs->rs_rssi + AR_USB_DEFAULT_NF;
 	rxi.rxi_tstamp = betoh64(rs->rs_tstamp);
 	if (!(wh->i_fc[0] & IEEE80211_FC0_TYPE_CTL) &&
Index: sys/dev/usb/if_atu.c
===================================================================
RCS file: /cvs/src/sys/dev/usb/if_atu.c,v
retrieving revision 1.133
diff -u -p -r1.133 if_atu.c
--- sys/dev/usb/if_atu.c	9 Jan 2022 05:43:00 -0000	1.133
+++ sys/dev/usb/if_atu.c	21 Apr 2022 22:24:22 -0000
@@ -1728,7 +1728,7 @@ atu_rxeof(struct usbd_xfer *xfer, void *
 	}
 #endif /* NBPFILTER > 0 */
 
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	if (wh->i_fc[1] & IEEE80211_FC1_WEP) {
 		/*
 		 * WEP is decrypted by hardware. Clear WEP bit
Index: sys/dev/usb/if_mtw.c
===================================================================
RCS file: /cvs/src/sys/dev/usb/if_mtw.c,v
retrieving revision 1.4
diff -u -p -r1.4 if_mtw.c
--- sys/dev/usb/if_mtw.c	8 Mar 2022 06:05:58 -0000	1.4
+++ sys/dev/usb/if_mtw.c	21 Apr 2022 22:24:23 -0000
@@ -2046,7 +2046,7 @@ mtw_rx_frame(struct mtw_softc *sc, uint8
 	}
 
 	wh = (struct ieee80211_frame *)(buf + rxwisize);
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	if (wh->i_fc[1] & IEEE80211_FC1_PROTECTED) {
 		wh->i_fc[1] &= ~IEEE80211_FC1_PROTECTED;
 		rxi.rxi_flags |= IEEE80211_RXI_HWDEC;
@@ -2129,7 +2129,6 @@ mtw_rx_frame(struct mtw_softc *sc, uint8
 	s = splnet();
 	ni = ieee80211_find_rxnode(ic, wh);
 	rxi.rxi_rssi = rssi;
-	rxi.rxi_tstamp = 0;	/* unused */
 	ieee80211_inputm(ifp, m, ni, &rxi, ml);
 
 	/* node is no longer needed */
Index: sys/dev/usb/if_otus.c
===================================================================
RCS file: /cvs/src/sys/dev/usb/if_otus.c,v
retrieving revision 1.70
diff -u -p -r1.70 if_otus.c
--- sys/dev/usb/if_otus.c	22 Nov 2021 10:17:14 -0000	1.70
+++ sys/dev/usb/if_otus.c	21 Apr 2022 22:24:23 -0000
@@ -1192,9 +1192,8 @@ otus_sub_rxeof(struct otus_softc *sc, ui
 
 	s = splnet();
 	ni = ieee80211_find_rxnode(ic, wh);
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	rxi.rxi_rssi = tail->rssi;
-	rxi.rxi_tstamp = 0;	/* unused */
 	ieee80211_inputm(ifp, m, ni, &rxi, ml);
 
 	/* Node is no longer needed. */
Index: sys/dev/usb/if_ral.c
===================================================================
RCS file: /cvs/src/sys/dev/usb/if_ral.c,v
retrieving revision 1.148
diff -u -p -r1.148 if_ral.c
--- sys/dev/usb/if_ral.c	31 Jul 2020 10:49:32 -0000	1.148
+++ sys/dev/usb/if_ral.c	21 Apr 2022 22:24:23 -0000
@@ -774,9 +774,8 @@ ural_rxeof(struct usbd_xfer *xfer, void 
 	ni = ieee80211_find_rxnode(ic, wh);
 
 	/* send the frame to the 802.11 layer */
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	rxi.rxi_rssi = desc->rssi;
-	rxi.rxi_tstamp = 0;	/* unused */
 	ieee80211_input(ifp, m, ni, &rxi);
 
 	/* node is no longer needed */
Index: sys/dev/usb/if_rsu.c
===================================================================
RCS file: /cvs/src/sys/dev/usb/if_rsu.c,v
retrieving revision 1.50
diff -u -p -r1.50 if_rsu.c
--- sys/dev/usb/if_rsu.c	4 Oct 2021 01:33:42 -0000	1.50
+++ sys/dev/usb/if_rsu.c	21 Apr 2022 22:24:23 -0000
@@ -1131,9 +1131,8 @@ rsu_event_survey(struct rsu_softc *sc, u
 	m->m_pkthdr.len = m->m_len = pktlen;
 
 	ni = ieee80211_find_rxnode(ic, wh);
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	rxi.rxi_rssi = letoh32(bss->rssi);
-	rxi.rxi_tstamp = 0;
 	ieee80211_input(ifp, m, ni, &rxi);
 	/* Node is no longer needed. */
 	ieee80211_release_node(ic, ni);
@@ -1384,9 +1383,8 @@ rsu_rx_frame(struct rsu_softc *sc, uint8
 #endif
 
 	ni = ieee80211_find_rxnode(ic, wh);
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	rxi.rxi_rssi = rssi;
-	rxi.rxi_tstamp = 0;	/* Unused. */
 	ieee80211_inputm(ifp, m, ni, &rxi, ml);
 	/* Node is no longer needed. */
 	ieee80211_release_node(ic, ni);
Index: sys/dev/usb/if_rum.c
===================================================================
RCS file: /cvs/src/sys/dev/usb/if_rum.c,v
retrieving revision 1.126
diff -u -p -r1.126 if_rum.c
--- sys/dev/usb/if_rum.c	31 Jul 2020 10:49:32 -0000	1.126
+++ sys/dev/usb/if_rum.c	21 Apr 2022 22:24:23 -0000
@@ -843,9 +843,8 @@ rum_rxeof(struct usbd_xfer *xfer, void *
 	ni = ieee80211_find_rxnode(ic, wh);
 
 	/* send the frame to the 802.11 layer */
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	rxi.rxi_rssi = desc->rssi;
-	rxi.rxi_tstamp = 0;	/* unused */
 	ieee80211_input(ifp, m, ni, &rxi);
 
 	/* node is no longer needed */
Index: sys/dev/usb/if_run.c
===================================================================
RCS file: /cvs/src/sys/dev/usb/if_run.c,v
retrieving revision 1.135
diff -u -p -r1.135 if_run.c
--- sys/dev/usb/if_run.c	22 Nov 2021 10:17:14 -0000	1.135
+++ sys/dev/usb/if_run.c	21 Apr 2022 22:24:23 -0000
@@ -2227,7 +2227,7 @@ run_rx_frame(struct run_softc *sc, uint8
 	}
 
 	wh = (struct ieee80211_frame *)(buf + rxwisize);
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	if (wh->i_fc[1] & IEEE80211_FC1_PROTECTED) {
 		wh->i_fc[1] &= ~IEEE80211_FC1_PROTECTED;
 		rxi.rxi_flags |= IEEE80211_RXI_HWDEC;
@@ -2310,7 +2310,6 @@ run_rx_frame(struct run_softc *sc, uint8
 	s = splnet();
 	ni = ieee80211_find_rxnode(ic, wh);
 	rxi.rxi_rssi = rssi;
-	rxi.rxi_tstamp = 0;	/* unused */
 	ieee80211_inputm(ifp, m, ni, &rxi, ml);
 
 	/* node is no longer needed */
Index: sys/dev/usb/if_uath.c
===================================================================
RCS file: /cvs/src/sys/dev/usb/if_uath.c,v
retrieving revision 1.87
diff -u -p -r1.87 if_uath.c
--- sys/dev/usb/if_uath.c	25 Feb 2021 02:48:20 -0000	1.87
+++ sys/dev/usb/if_uath.c	21 Apr 2022 22:24:23 -0000
@@ -1221,7 +1221,7 @@ uath_data_rxeof(struct usbd_xfer *xfer, 
 	data->buf = mtod(data->m, uint8_t *);
 
 	wh = mtod(m, struct ieee80211_frame *);
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	if ((wh->i_fc[1] & IEEE80211_FC1_WEP) &&
 	    ic->ic_opmode != IEEE80211_M_MONITOR) {
 		/*
@@ -1263,7 +1263,6 @@ uath_data_rxeof(struct usbd_xfer *xfer, 
 	s = splnet();
 	ni = ieee80211_find_rxnode(ic, wh);
 	rxi.rxi_rssi = (int)betoh32(desc->rssi);
-	rxi.rxi_tstamp = 0;	/* unused */
 	ieee80211_input(ifp, m, ni, &rxi);
 
 	/* node is no longer needed */
Index: sys/dev/usb/if_upgt.c
===================================================================
RCS file: /cvs/src/sys/dev/usb/if_upgt.c,v
retrieving revision 1.88
diff -u -p -r1.88 if_upgt.c
--- sys/dev/usb/if_upgt.c	9 Jan 2022 05:43:00 -0000	1.88
+++ sys/dev/usb/if_upgt.c	21 Apr 2022 22:24:24 -0000
@@ -1741,9 +1741,9 @@ upgt_rx(struct upgt_softc *sc, uint8_t *
 	ni = ieee80211_find_rxnode(ic, wh);
 
 	/* push the frame up to the 802.11 stack */
+	memset(&rxi, 0, sizeof(rxi));
 	rxi.rxi_flags = 0;
 	rxi.rxi_rssi = rxdesc->rssi;
-	rxi.rxi_tstamp = 0;	/* unused */
 	ieee80211_input(ifp, m, ni, &rxi);
 
 	/* node is no longer needed */
Index: sys/dev/usb/if_urtw.c
===================================================================
RCS file: /cvs/src/sys/dev/usb/if_urtw.c,v
retrieving revision 1.71
diff -u -p -r1.71 if_urtw.c
--- sys/dev/usb/if_urtw.c	9 Jan 2022 05:43:00 -0000	1.71
+++ sys/dev/usb/if_urtw.c	21 Apr 2022 22:24:24 -0000
@@ -3157,9 +3157,8 @@ urtw_rxeof(struct usbd_xfer *xfer, void 
 	nf = quality;
 
 	/* send the frame to the 802.11 layer */
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	rxi.rxi_rssi = rssi;
-	rxi.rxi_tstamp = 0;
 	ieee80211_input(ifp, m, ni, &rxi);
 
 	/* node is no longer needed */
Index: sys/dev/usb/if_urtwn.c
===================================================================
RCS file: /cvs/src/sys/dev/usb/if_urtwn.c,v
retrieving revision 1.99
diff -u -p -r1.99 if_urtwn.c
--- sys/dev/usb/if_urtwn.c	15 Mar 2022 09:23:01 -0000	1.99
+++ sys/dev/usb/if_urtwn.c	21 Apr 2022 22:24:24 -0000
@@ -1265,9 +1265,8 @@ urtwn_rx_frame(struct urtwn_softc *sc, u
 #endif
 
 	ni = ieee80211_find_rxnode(ic, wh);
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	rxi.rxi_rssi = rssi;
-	rxi.rxi_tstamp = 0;	/* Unused. */
 
 	/* Handle hardware decryption. */
 	if (((wh->i_fc[0] & IEEE80211_FC0_TYPE_MASK) != IEEE80211_FC0_TYPE_CTL)
Index: sys/dev/usb/if_zyd.c
===================================================================
RCS file: /cvs/src/sys/dev/usb/if_zyd.c,v
retrieving revision 1.127
diff -u -p -r1.127 if_zyd.c
--- sys/dev/usb/if_zyd.c	9 Jan 2022 05:43:00 -0000	1.127
+++ sys/dev/usb/if_zyd.c	21 Apr 2022 22:24:24 -0000
@@ -1979,9 +1979,8 @@ zyd_rx_data(struct zyd_softc *sc, const 
 	s = splnet();
 	wh = mtod(m, struct ieee80211_frame *);
 	ni = ieee80211_find_rxnode(ic, wh);
-	rxi.rxi_flags = 0;
+	memset(&rxi, 0, sizeof(rxi));
 	rxi.rxi_rssi = stat->rssi;
-	rxi.rxi_tstamp = 0;	/* unused */
 	ieee80211_inputm(ifp, m, ni, &rxi, ml);
 
 	/* node is no longer needed */
