untrusted comment: verify with openbsd-71-base.pub
RWR2eHwZTOEiTWtD/a2j3CuEamgQDd0M7KoTi49tJp2oDYRAlS8WMwAeM/xkhKZga16ppqccGaE+t0P7y+GRpqq7BanX3gBo4wo=

OpenBSD 7.1 errata 005, May 16, 2022:

Malicious PPPoE packets could corrupt kernel memory.

Apply by doing:
    signify -Vep /etc/signify/openbsd-71-base.pub -x 005_pppoe.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net/if_pppoe.c
===================================================================
RCS file: /cvs/src/sys/net/if_pppoe.c,v
diff -u -p -r1.79 if_pppoe.c
--- sys/net/if_pppoe.c	23 Nov 2021 19:13:45 -0000	1.79
+++ sys/net/if_pppoe.c	13 May 2022 21:47:50 -0000
@@ -542,10 +542,16 @@ breakbreak:
 				    sc->sc_ac_cookie_len);
 			sc->sc_ac_cookie = malloc(ac_cookie_len, M_DEVBUF,
 			    M_DONTWAIT);
-			if (sc->sc_ac_cookie == NULL)
+			if (sc->sc_ac_cookie == NULL) {
+				sc->sc_ac_cookie_len = 0;
 				goto done;
+			}
 			sc->sc_ac_cookie_len = ac_cookie_len;
 			memcpy(sc->sc_ac_cookie, ac_cookie, ac_cookie_len);
+		} else if (sc->sc_ac_cookie) {
+			free(sc->sc_ac_cookie, M_DEVBUF, sc->sc_ac_cookie_len);
+			sc->sc_ac_cookie = NULL;
+			sc->sc_ac_cookie_len = 0;
 		}
 		if (relay_sid) {
 			if (sc->sc_relay_sid)
@@ -553,10 +559,16 @@ breakbreak:
 				    sc->sc_relay_sid_len);
 			sc->sc_relay_sid = malloc(relay_sid_len, M_DEVBUF,
 			    M_DONTWAIT);
-			if (sc->sc_relay_sid == NULL)
+			if (sc->sc_relay_sid == NULL) {
+				sc->sc_relay_sid_len = 0;
 				goto done;
+			}
 			sc->sc_relay_sid_len = relay_sid_len;
 			memcpy(sc->sc_relay_sid, relay_sid, relay_sid_len);
+		} else if (sc->sc_relay_sid) {
+			free(sc->sc_relay_sid, M_DEVBUF, sc->sc_relay_sid_len);
+			sc->sc_relay_sid = NULL;
+			sc->sc_relay_sid_len = 0;
 		}
 		if (sc->sc_sppp.pp_if.if_mtu > PPPOE_MTU &&
 		    (!max_payloadtag ||
@@ -955,6 +967,9 @@ static struct mbuf *
 pppoe_get_mbuf(size_t len)
 {
 	struct mbuf *m;
+
+	if (len + sizeof(struct ether_header) > MCLBYTES)
+		return NULL;
 
 	MGETHDR(m, M_DONTWAIT, MT_DATA);
 	if (m == NULL)
