untrusted comment: verify with openbsd-73-base.pub
RWQS90bYzZ4XFpdvC6bZbmB4sQ2O1eN2k9xeh5Em4xzGuKJG+ctNIsNo+wd9TWIIgPtqhXk6Kgr2SJPLOsyQoOhwUbeJB+US8w4=

OpenBSD 7.3 errata 001, May 03, 2023:

A new ASPA object appeared in the RPKI ecosystem and exposed bugs in
bgpd(8) and rpki-client(8).

Apply by doing:
    signify -Vep /etc/signify/openbsd-73-base.pub -x 001_bgpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install bgpd(8) and rpki-client(8):
    cd /usr/src/usr.sbin/bgpd
    make obj
    make
    make install
    cd /usr/src/usr.sbin/rpki-client
    make obj
    make
    make install

Index: usr.sbin/bgpd/bgpd.h
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/bgpd.h,v
diff -u -p -r1.465 bgpd.h
--- usr.sbin/bgpd/bgpd.h	13 Mar 2023 16:52:41 -0000	1.465
+++ usr.sbin/bgpd/bgpd.h	26 Apr 2023 18:19:51 -0000
@@ -1200,6 +1200,7 @@ struct aspa_set {
 	uint8_t				 *tas_aid;
 	RB_ENTRY(aspa_set)		 entry;
 };
+#define TAS_AID_SIZE(n)	(((n) + 15) / 16 * sizeof(uint32_t))
 
 struct aspa_prep {
 	size_t				datasize;
Index: usr.sbin/bgpd/rde.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/rde.c,v
diff -u -p -r1.597 rde.c
--- usr.sbin/bgpd/rde.c	21 Mar 2023 14:52:36 -0000	1.597
+++ usr.sbin/bgpd/rde.c	26 Apr 2023 18:20:27 -0000
@@ -1121,7 +1121,7 @@ rde_dispatch_imsg_rtr(struct imsgbuf *ib
 			if (aspa == NULL)
 				fatalx("unexpected IMSG_RECONF_ASPA_TAS");
 			if (imsg.hdr.len - IMSG_HEADER_SIZE !=
-			     aspa->num * sizeof(uint32_t))
+			    aspa->num * sizeof(uint32_t))
 				fatalx("IMSG_RECONF_ASPA_TAS bad len");
 			aspa->tas = reallocarray(NULL, aspa->num,
 			    sizeof(uint32_t));
@@ -1134,12 +1134,13 @@ rde_dispatch_imsg_rtr(struct imsgbuf *ib
 			if (aspa == NULL)
 				fatalx("unexpected IMSG_RECONF_ASPA_TAS_AID");
 			if (imsg.hdr.len - IMSG_HEADER_SIZE !=
-			     (aspa->num + 15) / 16)
+			    TAS_AID_SIZE(aspa->num))
 				fatalx("IMSG_RECONF_ASPA_TAS_AID bad len");
-			aspa->tas_aid = malloc((aspa->num + 15) / 16);
+			aspa->tas_aid = malloc(TAS_AID_SIZE(aspa->num));
 			if (aspa->tas_aid == NULL)
 				fatal("IMSG_RECONF_ASPA_TAS_AID");
-			memcpy(aspa->tas_aid, imsg.data, (aspa->num + 15) / 16);
+			memcpy(aspa->tas_aid, imsg.data,
+			    TAS_AID_SIZE(aspa->num));
 			break;
 		case IMSG_RECONF_ASPA_DONE:
 			if (aspa_new == NULL)
Index: usr.sbin/bgpd/rde_aspa.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/rde_aspa.c,v
diff -u -p -r1.3 rde_aspa.c
--- usr.sbin/bgpd/rde_aspa.c	24 Jan 2023 11:28:41 -0000	1.3
+++ usr.sbin/bgpd/rde_aspa.c	26 Apr 2023 18:20:51 -0000
@@ -445,12 +445,13 @@ aspa_add_set(struct rde_aspa *ra, uint32
 	/* nobody in their right mind has per afi specific data */
 	if (pas_aid != NULL) {
 		/* 2 bits per entry rounded to next uint32_t */
-		if (ra->maxdata - ra->curdata < (pascnt * 2 + 31) / 32)
+		if (ra->maxdata - ra->curdata <
+		    TAS_AID_SIZE(pascnt) / sizeof(ra->data[0]))
 			fatalx("aspa set data overflow");
 
 		aspa->pas_aid = ra->data + ra->curdata;
-		for (i = 0; i < (pascnt * 2 + 31) / 32; i++)
-			ra->data[ra->curdata++] = pas_aid[i];
+		memcpy(aspa->pas_aid, pas_aid, TAS_AID_SIZE(pascnt));
+		ra->curdata += TAS_AID_SIZE(pascnt) / sizeof(ra->data[0]);
 	}
 }
 
Index: usr.sbin/bgpd/rtr.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/rtr.c,v
diff -u -p -r1.12 rtr.c
--- usr.sbin/bgpd/rtr.c	9 Mar 2023 17:21:21 -0000	1.12
+++ usr.sbin/bgpd/rtr.c	26 Apr 2023 18:19:30 -0000
@@ -491,10 +491,15 @@ static size_t
 rtr_aspa_set_prep(struct aspa_set *aspa)
 {
 	uint32_t i, mask = 0;
+	uint8_t *tas_aid;
 	int needafi = 0;
 	size_t s;
 
 	s = aspa->num * sizeof(uint32_t);
+
+	if ((tas_aid = malloc(TAS_AID_SIZE(aspa->num))) == NULL)
+		fatal("tas_aid alloc");
+
 	for (i = 0; i < aspa->num; i++) {
 		switch (aspa->tas_aid[i]) {
 		case AID_INET:
@@ -510,19 +515,23 @@ rtr_aspa_set_prep(struct aspa_set *aspa)
 			break;
 		}
 		if (i % 16 == 15) {
-			memcpy(aspa->tas_aid + (i / 16) * sizeof(mask), &mask,
+			memcpy(tas_aid + (i / 16) * sizeof(mask), &mask,
 			    sizeof(mask));
 			mask = 0;
 		}
 	}
 
+	free(aspa->tas_aid);
+	aspa->tas_aid = NULL;
+
 	if (!needafi) {
-		free(aspa->tas_aid);
-		aspa->tas_aid = NULL;
+		free(tas_aid);
 	} else {
-		memcpy(aspa->tas_aid + (aspa->num / 16) * sizeof(mask), &mask,
-		    sizeof(mask));
-		s += (aspa->num + 15) / 16;
+		if (aspa->num % 16 != 0)
+			memcpy(tas_aid + (aspa->num / 16) * sizeof(mask),
+			    &mask, sizeof(mask));
+		aspa->tas_aid = tas_aid;
+		s += TAS_AID_SIZE(aspa->num);
 	}
 
 	return s;
@@ -578,8 +587,8 @@ rtr_recalc(void)
 		imsg_compose(ibuf_rde, IMSG_RECONF_ASPA_TAS, 0, 0, -1,
 		    aspa->tas, aspa->num * sizeof(*aspa->tas));
 		if (aspa->tas_aid)
-			imsg_compose(ibuf_rde, IMSG_RECONF_ASPA_TAS, 0, 0, -1,
-			    aspa->tas_aid, (aspa->num + 15) / 16);
+			imsg_compose(ibuf_rde, IMSG_RECONF_ASPA_TAS_AID, 0, 0,
+			    -1, aspa->tas_aid, TAS_AID_SIZE(aspa->num));
 		imsg_compose(ibuf_rde, IMSG_RECONF_ASPA_DONE, 0, 0, -1,
 		    NULL, 0);
 	}
Index: usr.sbin/rpki-client/output-bgpd.c
===================================================================
RCS file: /cvs/src/usr.sbin/rpki-client/output-bgpd.c,v
diff -u -p -r1.26 output-bgpd.c
--- usr.sbin/rpki-client/output-bgpd.c	20 Jan 2023 15:42:34 -0000	1.26
+++ usr.sbin/rpki-client/output-bgpd.c	26 Apr 2023 18:18:56 -0000
@@ -67,11 +67,11 @@ output_bgpd(FILE *out, struct vrp_tree *
 				return -1;
 			switch (vap->providers[i].afi) {
 			case AFI_IPV4:
-				if (fprintf(out, "inet") < 0)
+				if (fprintf(out, " inet") < 0)
 					return -1;
 				break;
 			case AFI_IPV6:
-				if (fprintf(out, "inet6") < 0)
+				if (fprintf(out, " inet6") < 0)
 					return -1;
 				break;
 			}
