<?php
include_once('class.webmeetingsauth.php');
include_once('class.turnauth.php');
include_once('class.webmeetings_auth_simple.php');

/**
 * Spreedwebrtc Module
 */
class PluginSpreedwebrtcModule extends Module
{
	private $sharedsecret = "";
	private $username = "";
	private $userid = "";
	private $time = "";
	private $userimage = "";
	private $turnAuthConnector = NULL;
	private $webmeetingsAuthSimple = NULL;

	/**
	 * Constructor
	 * @param array $data list of all actions.
	 */
	function Pluginspreedwebrtc($id, $data)
	{
		parent::Module($id, $data);
	}

	function getWebmeetingsAuthToken()
	{
		$this->sharedsecret = PLUGIN_SPREEDWEBRTC_WEBMEETINGS_SHARED_SECRET;
		$this->username = $GLOBALS['mapisession']->getUserName();
		$this->userid = bin2hex($GLOBALS['mapisession']->getUserEntryID());
		$this->emailaddress = $GLOBALS['mapisession']->getEmailAddress();
		$this->smtpaddress = $GLOBALS['mapisession']->getSMTPAddress();
		$this->userimage = $GLOBALS['mapisession']->getUserImage();
		$this->time = time() + PLUGIN_SPREEDWEBRTC_WEBMEETINGS_AUTHENTICATION_EXPIRES;
		$hash = base64_encode(hash_hmac('sha256', $this->time . ':' . $this->emailaddress, $this->sharedsecret, true));
		return $hash;
	}

	function getPresenceAuthToken()
	{
		$this->sharedsecret = PLUGIN_SPREEDWEBRTC_PRESENCE_SHARED_SECRET;
		$this->username = $GLOBALS['mapisession']->getUserName();
		$this->userid = bin2hex($GLOBALS['mapisession']->getUserEntryID());
		$this->emailaddress = $GLOBALS['mapisession']->getEmailAddress();
		$this->smtpaddress = $GLOBALS['mapisession']->getSMTPAddress();
		$this->time = time() + PLUGIN_SPREEDWEBRTC_PRESENCE_AUTHENTICATION_EXPIRES;
		$hash = base64_encode(hash_hmac('sha256', $this->time . ':' . $this->emailaddress, $this->sharedsecret, true));
		return $hash;
	}

	function getWebmeetingsRoomPin($time)
	{
		$webmeetingsAuthSimple = new WebmeetingsAuthSimple();

		$room_pin = $webmeetingsAuthSimple->getWebmeetingsAuthSimpleRoomPin($time);

		return $room_pin;
	}

	function getWebmeetingsRoomURL($room_pin)
	{
		if (substr(PLUGIN_SPREEDWEBRTC_SPREED_URL, 0, 7) == 'http://' || substr(PLUGIN_SPREEDWEBRTC_SPREED_URL, 0, 8) == 'https://') {
			$webmeetings_base_url = PLUGIN_SPREEDWEBRTC_SPREED_URL;
		} else {
			$webmeetings_base_url = PLUGIN_SPREEDWEBRTC_SPREED_URL;
		}
		if (substr($webmeetings_base_url,-1) != '/') $webmeetings_base_url .= '/';

		return($webmeetings_base_url . $room_pin);
	}

	/**
	 * Executes all the actions in the $data variable.
	 * @return boolean true on success of false on fialure.
	 */
	function execute()
	{
		foreach ($this->data as $actionType => $actionData) {
			if (isset($actionType)) {
				try {
					switch ($actionType) {
						case "authenticate":
							$turn_ttl = 0;
							$turn_expires = 0;
							$turn_username = NULL;
							$turn_password = NULL;
							$turn_urls = NULL;
							$turndata = NULL;
							// if turn service used then get turn access info
							if (PLUGIN_SPREEDWEBRTC_TURN_USE_KOPANO_SERVICE) {
								if (!isset($this->turnAuthConnector)) {
									$this->turnAuthConnector = new TurnAuthConnector(PLUGIN_SPREEDWEBRTC_TURN_AUTHENTICATION_URL);
									$this->turnAuthConnector->setCredentials(
										PLUGIN_SPREEDWEBRTC_TURN_AUTHENTICATION_USER,
										PLUGIN_SPREEDWEBRTC_TURN_AUTHENTICATION_PASSWORD
										);
								}
								$turndata = $this->turnAuthConnector->getTurnAuthData();

								if ($turndata) {
									$turn_ttl = $turndata->ttl;
									$turn_expires = time() + $turn_ttl;
									$turn_username = $turndata->username;
									$turn_password = $turndata->password;
									$turn_urls = $turndata->uris;
								}
							}

							$response = array(
								'type' => 3,
								'authentication' => array(
									'secret' => $this->getWebmeetingsAuthToken(),
									'username' => $this->username,
									'userid' => $this->userid,
									'emailaddress' => $this->emailaddress,
									'smtpaddress' => $this->smtpaddress,
									'timestamp' => $this->time,
									'buddyPicture' => $this->userimage,
									'turn_ttl' => $turn_ttl,
									'turn_username' => $turn_username,
									'turn_password' => $turn_password,
									'turn_urls' => $turn_urls
								)
							);
							$this->addActionData("info", $response);
							$GLOBALS["bus"]->addData($this->getResponseData());
							break;
						case "presenceauth":
							$response = array(
								'type' => 3,
								'presenceauth' => array(
									'authtoken' => $this->getPresenceAuthToken(),
									'username' => $this->username,
									'userid' => $this->userid,
									'emailaddress' => $this->emailaddress,
									'smtpaddress' => $this->smtpaddress,
									'timestamp' => $this->time,
								)
							);
							$this->addActionData("info", $response);
							$GLOBALS["bus"]->addData($this->getResponseData());
							break;
						case "meetingurl":
							$time = $actionData['start'];
							$room_pin = $this->getWebmeetingsRoomPin($time);
							$response = array(
								'type' => 3,
								'meetingurl' => array(
									'url' => $this->getWebmeetingsRoomURL($room_pin),
									'roomid' => $room_pin
								)
							);
							$this->addActionData("info", $response);
							$GLOBALS["bus"]->addData($this->getResponseData());
							break;
						default:
							$this->handleUnknownActionType($actionType);
					}
				} catch (MAPIException $e) {
					$this->sendFeedback(false, $this->errorDetailsFromException($e));
				}
			}
		}
	}
}
