/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp.java.swing;

import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Interpreter;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TwoWayStream;

public class REPLConsole
extends DefaultStyledDocument {
    private StringBuffer inputBuffer = new StringBuffer();
    private Reader reader = new Reader(){

        @Override
        public void close() throws RuntimeException {
        }

        @Override
        public synchronized int read(char[] cbuf, int off, int len) throws RuntimeException {
            try {
                int length = Math.min(REPLConsole.this.inputBuffer.length(), len);
                while (length <= 0) {
                    this.wait();
                    length = Math.min(REPLConsole.this.inputBuffer.length(), len);
                }
                REPLConsole.this.inputBuffer.getChars(0, length, cbuf, off);
                REPLConsole.this.inputBuffer.delete(0, length);
                return length;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private Writer writer = new Writer(){

        @Override
        public void close() throws RuntimeException {
        }

        @Override
        public void flush() throws RuntimeException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(final char[] cbuf, final int off, final int len) throws RuntimeException {
            try {
                int insertOffs;
                Reader reader = REPLConsole.this.reader;
                synchronized (reader) {
                    if (REPLConsole.this.inputBuffer.toString().matches("^\\s*$")) {
                        int length = REPLConsole.this.inputBuffer.length();
                        REPLConsole.this.inputBuffer.delete(0, length);
                    }
                    insertOffs = REPLConsole.this.getLength() - REPLConsole.this.inputBuffer.length();
                    REPLConsole.this.reader.notifyAll();
                }
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Reader reader = REPLConsole.this.reader;
                        synchronized (reader) {
                            block5: {
                                try {
                                    REPLConsole.this.superInsertString(insertOffs, new String(cbuf, off, len), null);
                                }
                                catch (Exception e) {
                                    if ($assertionsDisabled) break block5;
                                    throw new AssertionError();
                                }
                            }
                        }
                    }
                };
                SwingUtilities.invokeAndWait(r);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };
    private boolean disposed = false;
    private final Thread replThread;
    private final LispObject debuggerHook = new Function(){

        @Override
        public LispObject execute(LispObject condition, LispObject debuggerHook) {
            if (REPLConsole.this.disposed) {
                return Lisp.PACKAGE_SYS.findSymbol("%DEBUGGER-HOOK-FUNCTION").execute(condition, debuggerHook);
            }
            return Lisp.NIL;
        }
    };

    public REPLConsole(LispObject replFunction) {
        final LispObject replWrapper = this.makeReplWrapper(new Stream(Symbol.SYSTEM_STREAM, new BufferedReader(this.reader)), new Stream(Symbol.SYSTEM_STREAM, new BufferedWriter(this.writer)), replFunction);
        this.replThread = new Thread("REPL-thread-" + System.identityHashCode(this)){

            @Override
            public void run() {
                while (true) {
                    replWrapper.execute();
                    3.yield();
                }
            }
        };
        this.replThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        Reader reader = this.reader;
        synchronized (reader) {
            int bufferStart = this.getLength() - this.inputBuffer.length();
            if (offs < bufferStart) {
                throw new BadLocationException("Can only insert after " + bufferStart, offs);
            }
            this.superInsertString(offs, str, a);
            this.inputBuffer.insert(offs - bufferStart, str);
            if (this.processInputP(this.inputBuffer, str)) {
                this.reader.notifyAll();
            }
        }
    }

    protected void superInsertString(int offs, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offs, str, a);
    }

    protected boolean processInputP(StringBuffer sb, String str) {
        if (str.indexOf("\n") == -1) {
            return false;
        }
        int parenCount = 0;
        int len = sb.length();
        for (int i = 0; i < len; ++i) {
            char c = sb.charAt(i);
            if (c == '(') {
                ++parenCount;
                continue;
            }
            if (c != ')' || --parenCount != 0) continue;
            return true;
        }
        return parenCount <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int offs, int len) throws BadLocationException {
        Reader reader = this.reader;
        synchronized (reader) {
            int bufferStart = this.getLength() - this.inputBuffer.length();
            if (offs < bufferStart) {
                throw new BadLocationException("Can only remove after " + bufferStart, offs);
            }
            super.remove(offs, len);
            this.inputBuffer.delete(offs - bufferStart, offs - bufferStart + len);
        }
    }

    public Reader getReader() {
        return this.reader;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setupTextComponent(final JTextComponent txt) {
        this.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                int len = REPLConsole.this.getLength();
                if (len - e.getLength() == e.getOffset()) {
                    txt.setCaretPosition(REPLConsole.this.getLength());
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }
        });
        txt.setCaretPosition(this.getLength());
    }

    public void dispose() {
        this.disposed = true;
        for (DocumentListener listener : this.getDocumentListeners()) {
            this.removeDocumentListener(listener);
        }
        try {
            this.reader.close();
            this.writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.replThread.interrupt();
    }

    public LispObject makeReplWrapper(final Stream in, final Stream out, final LispObject fn) {
        return new Function(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LispObject execute() {
                SpecialBindingsMark lastSpecialBinding = LispThread.currentThread().markSpecialBindings();
                try {
                    TwoWayStream ioStream = new TwoWayStream(in, out);
                    LispThread.currentThread().bindSpecial(Symbol.DEBUGGER_HOOK, REPLConsole.this.debuggerHook);
                    LispThread.currentThread().bindSpecial(Symbol.STANDARD_INPUT, in);
                    LispThread.currentThread().bindSpecial(Symbol.STANDARD_OUTPUT, out);
                    LispThread.currentThread().bindSpecial(Symbol.ERROR_OUTPUT, out);
                    LispThread.currentThread().bindSpecial(Symbol.TERMINAL_IO, ioStream);
                    LispThread.currentThread().bindSpecial(Symbol.DEBUG_IO, ioStream);
                    LispThread.currentThread().bindSpecial(Symbol.QUERY_IO, ioStream);
                    LispObject lispObject = fn.execute();
                    return lispObject;
                }
                finally {
                    LispThread.currentThread().resetSpecialBindings(lastSpecialBinding);
                }
            }
        };
    }

    public void disposeOnClose(final Window parent) {
        parent.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                REPLConsole.this.dispose();
                parent.removeWindowListener(this);
            }
        });
    }

    public static void main(String[] args) {
        LispObject repl = null;
        try {
            repl = Interpreter.createInstance().eval("#'top-level::top-level-loop");
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
        REPLConsole d = new REPLConsole(repl);
        JTextArea txt = new JTextArea(d);
        d.setupTextComponent(txt);
        JFrame f = new JFrame();
        f.add(new JScrollPane(txt));
        d.disposeOnClose(f);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }
}

