/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.ComponentGraphics;
import gnu.java.awt.peer.gtk.GtkCursor;
import gnu.java.awt.peer.gtk.GtkFramePeer;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkMainThread;
import gnu.java.awt.peer.gtk.GtkVolatileImage;
import gnu.java.awt.peer.gtk.GtkWindowPeer;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.PaintEvent;
import java.awt.event.TextEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.util.Timer;
import java.util.TimerTask;
import sun.awt.CausedFocusEvent;

public class GtkComponentPeer
extends GtkGenericPeer
implements ComponentPeer {
    VolatileImage backBuffer;
    BufferCapabilities caps;
    Component awtComponent;
    Insets insets;
    private Rectangle currentPaintArea;

    native boolean isEnabled();

    static native boolean modalHasGrab();

    native int[] gtkWidgetGetForeground();

    native int[] gtkWidgetGetBackground();

    native void gtkWidgetGetDimensions(int[] var1);

    native void gtkWidgetGetPreferredDimensions(int[] var1);

    native void gtkWindowGetLocationOnScreen(int[] var1);

    native void gtkWindowGetLocationOnScreenUnlocked(int[] var1);

    native void gtkWidgetGetLocationOnScreen(int[] var1);

    native void gtkWidgetGetLocationOnScreenUnlocked(int[] var1);

    native void gtkWidgetSetCursor(int var1, GtkImage var2, int var3, int var4);

    native void gtkWidgetSetCursorUnlocked(int var1, GtkImage var2, int var3, int var4);

    native void gtkWidgetSetBackground(int var1, int var2, int var3);

    native void gtkWidgetSetForeground(int var1, int var2, int var3);

    native void gtkWidgetSetSensitive(boolean var1);

    native void gtkWidgetSetParent(ComponentPeer var1);

    native void gtkWidgetRequestFocus();

    native void gtkWidgetDispatchKeyEvent(int var1, long var2, int var4, int var5, int var6);

    native boolean gtkWidgetHasFocus();

    native boolean gtkWidgetCanFocus();

    native void realize();

    native void setNativeEventMask();

    void create() {
        throw new RuntimeException();
    }

    native void connectSignals();

    protected GtkComponentPeer(Component awtComponent) {
        super(awtComponent);
        this.awtComponent = awtComponent;
        this.insets = new Insets(0, 0, 0, 0);
        this.create();
        this.connectSignals();
        if (awtComponent.getForeground() != null) {
            this.setForeground(awtComponent.getForeground());
        }
        if (awtComponent.getBackground() != null) {
            this.setBackground(awtComponent.getBackground());
        }
        if (awtComponent.getFont() != null) {
            this.setFont(awtComponent.getFont());
        }
        awtComponent.getParent();
        this.setParentAndBounds();
        this.setNativeEventMask();
        this.realize();
        if (awtComponent.isCursorSet()) {
            this.setCursor();
        }
    }

    void setParentAndBounds() {
        this.setParent();
        this.setComponentBounds();
        this.setVisibleAndEnabled();
    }

    void setParent() {
        ComponentPeer p;
        Component component = this.awtComponent;
        while ((p = (component = component.getParent()).getPeer()) instanceof LightweightPeer) {
        }
        if (p != null) {
            this.gtkWidgetSetParent(p);
        }
    }

    void setComponentBounds() {
        Rectangle bounds = this.awtComponent.getBounds();
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    void setVisibleAndEnabled() {
        this.setVisible(this.awtComponent.isVisible());
        this.setEnabled(this.awtComponent.isEnabled());
    }

    public int checkImage(Image image, int width, int height, ImageObserver observer) {
        return this.getToolkit().checkImage(image, width, height, observer);
    }

    public Image createImage(ImageProducer producer) {
        return new GtkImage(producer);
    }

    public Image createImage(int width, int height) {
        return CairoSurface.getBufferedImage(width, height);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void enable() {
        this.setEnabled(true);
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.getToolkit().getFontMetrics(font);
    }

    public Graphics getGraphics() {
        return ComponentGraphics.getComponentGraphics(this);
    }

    public Point getLocationOnScreen() {
        int[] point = new int[2];
        if (Thread.currentThread() == GtkMainThread.mainThread) {
            this.gtkWidgetGetLocationOnScreenUnlocked(point);
        } else {
            this.gtkWidgetGetLocationOnScreen(point);
        }
        return new Point(point[0], point[1]);
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public void handleEvent(AWTEvent event) {
        int id = event.getID();
        KeyEvent ke = null;
        switch (id) {
            case 800: {
                this.paintComponent((PaintEvent)event);
                break;
            }
            case 801: {
                this.updateComponent((PaintEvent)event);
                break;
            }
            case 401: {
                ke = (KeyEvent)event;
                this.gtkWidgetDispatchKeyEvent(ke.getID(), ke.getWhen(), ke.getModifiersEx(), ke.getKeyCode(), ke.getKeyLocation());
                break;
            }
            case 402: {
                ke = (KeyEvent)event;
                this.gtkWidgetDispatchKeyEvent(ke.getID(), ke.getWhen(), ke.getModifiersEx(), ke.getKeyCode(), ke.getKeyLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(PaintEvent event) {
        Rectangle paintArea;
        if (!this.awtComponent.isShowing() || this.awtComponent.getWidth() < 1 || this.awtComponent.getHeight() < 1) {
            return;
        }
        this.coalescePaintEvent(event);
        GtkComponentPeer gtkComponentPeer = this;
        synchronized (gtkComponentPeer) {
            paintArea = this.currentPaintArea;
            this.currentPaintArea = null;
        }
        if (paintArea != null) {
            Graphics g = this.getGraphics();
            try {
                g.setClip(paintArea);
                this.awtComponent.paint(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateComponent(PaintEvent event) {
        Rectangle paintArea;
        if (!this.awtComponent.isShowing() || this.awtComponent.getWidth() < 1 || this.awtComponent.getHeight() < 1) {
            return;
        }
        this.coalescePaintEvent(event);
        GtkComponentPeer gtkComponentPeer = this;
        synchronized (gtkComponentPeer) {
            paintArea = this.currentPaintArea;
            this.currentPaintArea = null;
        }
        if (paintArea != null) {
            Graphics g = this.getGraphics();
            try {
                g.setClip(paintArea);
                this.awtComponent.update(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Dimension minimumSize() {
        int[] dim = new int[2];
        this.gtkWidgetGetPreferredDimensions(dim);
        return new Dimension(dim[0], dim[1]);
    }

    public void paint(Graphics g) {
    }

    public Dimension preferredSize() {
        int[] dim = new int[2];
        this.gtkWidgetGetPreferredDimensions(dim);
        return new Dimension(dim[0], dim[1]);
    }

    public boolean prepareImage(Image image, int width, int height, ImageObserver observer) {
        return this.getToolkit().prepareImage(image, width, height, observer);
    }

    public void print(Graphics g) {
        g.drawImage(ComponentGraphics.grab(this), 0, 0, null);
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        if (width < 1 || height < 1) {
            return;
        }
        if (tm <= 0L) {
            GtkComponentPeer.q().postEvent(new PaintEvent(this.awtComponent, 801, new Rectangle(x, y, width, height)));
        } else {
            RepaintTimerTask.schedule(tm, x, y, width, height, this.awtComponent);
        }
    }

    public void requestFocus() {
        assert (false) : "Call new requestFocus() method instead";
    }

    public void reshape(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    public void setBackground(Color c) {
        this.gtkWidgetSetBackground(c.getRed(), c.getGreen(), c.getBlue());
    }

    native void setNativeBounds(int var1, int var2, int var3, int var4);

    public void setBounds(int x, int y, int width, int height) {
        int new_x = x;
        int new_y = y;
        Container parent = this.awtComponent.getParent();
        while (parent.isLightweight()) {
            Insets i = parent.getInsets();
            new_x += parent.getX() + i.left;
            new_y += parent.getY() + i.top;
            parent = parent.getParent();
        }
        if (parent instanceof Window) {
            GtkWindowPeer peer = (GtkWindowPeer)parent.getPeer();
            Insets insets = peer.getInsets();
            int menuBarHeight = 0;
            if (peer instanceof GtkFramePeer) {
                menuBarHeight = ((GtkFramePeer)peer).getMenuBarHeight();
            }
            new_x -= insets.left;
            new_y -= insets.top;
            new_y += menuBarHeight;
        }
        this.setNativeBounds(new_x, new_y, width, height);
        this.setVisible(this.awtComponent.isVisible());
    }

    void setCursor() {
        this.setCursor(this.awtComponent.getCursor());
    }

    public void setCursor(Cursor cursor) {
        int y;
        int x;
        GtkImage image;
        cursor.getType();
        if (cursor instanceof GtkCursor) {
            GtkCursor gtkCursor = (GtkCursor)cursor;
            image = gtkCursor.getGtkImage();
            Point hotspot = gtkCursor.getHotspot();
            x = hotspot.x;
            y = hotspot.y;
        } else {
            image = null;
            x = 0;
            y = 0;
        }
        if (Thread.currentThread() == GtkMainThread.mainThread) {
            this.gtkWidgetSetCursorUnlocked(cursor.getType(), image, x, y);
        } else {
            this.gtkWidgetSetCursor(cursor.getType(), image, x, y);
        }
    }

    public void setEnabled(boolean b) {
        this.gtkWidgetSetSensitive(b);
    }

    public void setFont(Font f) {
        this.gtkWidgetModifyFont(f.getName(), f.getStyle(), f.getSize());
    }

    public void setForeground(Color c) {
        this.gtkWidgetSetForeground(c.getRed(), c.getGreen(), c.getBlue());
    }

    public Color getForeground() {
        int[] rgb = this.gtkWidgetGetForeground();
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public Color getBackground() {
        int[] rgb = this.gtkWidgetGetBackground();
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public native void setVisibleNative(boolean var1);

    public native void setVisibleNativeUnlocked(boolean var1);

    public void setVisible(boolean b) {
        if (b && !(this.awtComponent instanceof Window)) {
            Rectangle bounds = this.awtComponent.getBounds();
            boolean bl = b = bounds.width > 0 && bounds.height > 0;
        }
        if (Thread.currentThread() == GtkMainThread.mainThread) {
            this.setVisibleNativeUnlocked(b);
        } else {
            this.setVisibleNative(b);
        }
    }

    public void hide() {
        this.setVisible(false);
    }

    public void show() {
        this.setVisible(true);
    }

    protected void postMouseEvent(int id, long when, int mods, int x, int y, int clickCount, boolean popupTrigger) {
        Point locOnScreen = this.getLocationOnScreen();
        GtkComponentPeer.q().postEvent(new MouseEvent(this.awtComponent, id, when, mods, x, y, locOnScreen.x + x, locOnScreen.y + y, clickCount, popupTrigger, 0));
    }

    protected void postMouseWheelEvent(int id, long when, int mods, int x, int y, int clickCount, boolean popupTrigger, int type, int amount, int rotation) {
        GtkComponentPeer.q().postEvent(new MouseWheelEvent(this.awtComponent, id, when, mods, x, y, clickCount, popupTrigger, type, amount, rotation));
    }

    protected void postExposeEvent(int x, int y, int width, int height) {
        GtkComponentPeer.q().postEvent(new PaintEvent(this.awtComponent, 800, new Rectangle(x, y, width, height)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postKeyEvent(int id, long when, int mods, int keyCode, char keyChar, int keyLocation) {
        KeyEvent keyEvent = new KeyEvent(this.awtComponent, id, when, mods, keyCode, keyChar, keyLocation);
        EventQueue q = GtkComponentPeer.q();
        if (keyEvent.getID() == 401 && !keyEvent.isActionKey() && keyCode != 16 && keyCode != 17 && keyCode != 18) {
            EventQueue eventQueue = q;
            synchronized (eventQueue) {
                q.postEvent(keyEvent);
                keyEvent = new KeyEvent(this.awtComponent, 400, when, mods, 0, keyChar, keyLocation);
                q.postEvent(keyEvent);
            }
        } else {
            q.postEvent(keyEvent);
        }
    }

    protected void postFocusEvent(int id, boolean temporary) {
        GtkComponentPeer.q().postEvent(new FocusEvent(this.awtComponent, id, temporary));
    }

    protected void postItemEvent(Object item, int stateChange) {
        GtkComponentPeer.q().postEvent(new ItemEvent((ItemSelectable)((Object)this.awtComponent), 701, item, stateChange));
    }

    protected void postTextEvent() {
        GtkComponentPeer.q().postEvent(new TextEvent(this.awtComponent, 900));
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice dev = env.getDefaultScreenDevice();
        return dev.getDefaultConfiguration();
    }

    public void setEventMask(long mask) {
    }

    public boolean isFocusable() {
        return false;
    }

    public boolean requestFocus(Component request, boolean temporary, boolean allowWindowFocus, long time) {
        assert (request == this.awtComponent || this.isLightweightDescendant(request));
        boolean retval = false;
        if (this.gtkWidgetHasFocus()) {
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component currentFocus = kfm.getFocusOwner();
            if (currentFocus == request) {
                retval = true;
            } else {
                this.postFocusEvent(1004, temporary);
                retval = true;
            }
        } else if (this.gtkWidgetCanFocus()) {
            Window window;
            GtkWindowPeer wPeer;
            if (allowWindowFocus && !(wPeer = (GtkWindowPeer)(window = this.getWindowFor(request)).getPeer()).gtkWindowHasFocus()) {
                wPeer.requestWindowFocus();
            }
            this.gtkWidgetRequestFocus();
            retval = true;
        }
        return retval;
    }

    private Window getWindowFor(Component c) {
        Component comp = c;
        while (!(comp instanceof Window)) {
            comp = comp.getParent();
        }
        return (Window)comp;
    }

    protected boolean isLightweightDescendant(Component c) {
        Component comp = c;
        while (comp.getPeer() instanceof LightweightPeer) {
            comp = comp.getParent();
        }
        return comp == this.awtComponent;
    }

    public boolean isObscured() {
        return false;
    }

    public boolean canDetermineObscurity() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void coalescePaintEvent(PaintEvent e) {
        GtkComponentPeer gtkComponentPeer = this;
        synchronized (gtkComponentPeer) {
            Rectangle newRect = e.getUpdateRect();
            if (this.currentPaintArea == null) {
                this.currentPaintArea = newRect;
            } else {
                Rectangle.union(this.currentPaintArea, newRect, this.currentPaintArea);
            }
        }
    }

    public void updateCursorImmediately() {
        if (this.awtComponent.getCursor() != null) {
            this.setCursor(this.awtComponent.getCursor());
        }
    }

    public boolean handlesWheelScrolling() {
        return false;
    }

    public VolatileImage createVolatileImage(int width, int height) {
        return new GtkVolatileImage(this, width, height, null);
    }

    public void createBuffers(int numBuffers, BufferCapabilities caps) throws AWTException {
        if (numBuffers != 2) {
            throw new AWTException("GtkComponentPeer.createBuffers: multi-buffering not supported");
        }
        this.backBuffer = new GtkVolatileImage(this, this.awtComponent.getWidth(), this.awtComponent.getHeight(), caps.getBackBufferCapabilities());
        this.caps = caps;
    }

    public Image getBackBuffer() {
        return this.backBuffer;
    }

    public void flip(BufferCapabilities.FlipContents contents) {
        this.getGraphics().drawImage(this.backBuffer, this.awtComponent.getWidth(), this.awtComponent.getHeight(), null);
        if (contents == BufferCapabilities.FlipContents.BACKGROUND) {
            this.backBuffer = this.createVolatileImage(this.awtComponent.getWidth(), this.awtComponent.getHeight());
            this.backBuffer.getGraphics().clearRect(0, 0, this.awtComponent.getWidth(), this.awtComponent.getHeight());
        }
    }

    public void destroyBuffers() {
        this.backBuffer.flush();
    }

    public String toString() {
        return "peer of " + this.awtComponent.toString();
    }

    public Rectangle getBounds() {
        return null;
    }

    public void reparent(ContainerPeer parent) {
    }

    public void setBounds(int x, int y, int width, int height, int z) {
        this.setBounds(x, y, width, height);
    }

    public boolean isReparentSupported() {
        return false;
    }

    public void layout() {
    }

    public boolean requestFocus(Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time, CausedFocusEvent.Cause cause) {
        return true;
    }

    private static class RepaintTimerTask
    extends TimerTask {
        private static final Timer repaintTimer = new Timer(true);
        private int x;
        private int y;
        private int width;
        private int height;
        private Component awtComponent;

        RepaintTimerTask(Component c, int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.awtComponent = c;
        }

        public void run() {
            GtkComponentPeer.q().postEvent(new PaintEvent(this.awtComponent, 801, new Rectangle(this.x, this.y, this.width, this.height)));
        }

        static void schedule(long tm, int x, int y, int width, int height, Component c) {
            repaintTimer.schedule((TimerTask)new RepaintTimerTask(c, x, y, width, height), tm);
        }
    }
}

