/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.decoder;

import gnu.java.beans.decoder.AbstractElementHandler;
import gnu.java.beans.decoder.ArrayContext;
import gnu.java.beans.decoder.AssemblyException;
import gnu.java.beans.decoder.Context;
import gnu.java.beans.decoder.ElementHandler;
import gnu.java.beans.decoder.GrowableArrayContext;
import java.beans.ExceptionListener;
import java.util.HashMap;
import org.xml.sax.Attributes;

class ArrayHandler
extends AbstractElementHandler {
    private static HashMap typeMap = new HashMap();

    static {
        typeMap.put("byte", Byte.TYPE);
        typeMap.put("short", Short.TYPE);
        typeMap.put("int", Integer.TYPE);
        typeMap.put("long", Long.TYPE);
        typeMap.put("float", Float.TYPE);
        typeMap.put("double", Double.TYPE);
        typeMap.put("boolean", Boolean.TYPE);
        typeMap.put("char", Character.TYPE);
    }

    ArrayHandler(ElementHandler parent) {
        super(parent, true);
    }

    protected Context startElement(Attributes attributes, ExceptionListener exceptionListener) throws AssemblyException, AssemblyException {
        String id = attributes.getValue("id");
        String className = attributes.getValue("class");
        if (className != null) {
            try {
                Class klass = typeMap.containsKey(className) ? (Class)typeMap.get(className) : this.instantiateClass(className);
                String length = attributes.getValue("length");
                if (length != null) {
                    return new ArrayContext(id, klass, Integer.parseInt(length));
                }
                return new GrowableArrayContext(id, klass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new AssemblyException(cnfe);
            }
            catch (NumberFormatException nfe) {
                throw new AssemblyException(nfe);
            }
        }
        throw new AssemblyException(new IllegalArgumentException("Missing 'class' attribute in <array> tag."));
    }
}

