/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.CertificateStatusRequest;
import gnu.javax.net.ssl.provider.CertificateURL;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.MaxFragmentLength;
import gnu.javax.net.ssl.provider.ServerNameList;
import gnu.javax.net.ssl.provider.TruncatedHMAC;
import gnu.javax.net.ssl.provider.TrustedAuthorities;
import gnu.javax.net.ssl.provider.UnresolvedExtensionValue;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class Extension
implements Builder,
Constructed {
    private ByteBuffer buffer;

    public Extension(ByteBuffer buffer) {
        this.buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    public Extension(Type type, Value value) {
        ByteBuffer valueBuffer = value.buffer();
        int length = 4 + valueBuffer.remaining();
        this.buffer = ByteBuffer.allocate(length);
        this.buffer.putShort((short)type.getValue());
        this.buffer.putShort((short)valueBuffer.remaining());
        this.buffer.put(valueBuffer);
        this.buffer.rewind();
    }

    public int length() {
        return (this.buffer.getShort(2) & 0xFFFF) + 4;
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().limit(this.length());
    }

    public Type type() {
        return Type.forValue(this.buffer.getShort(0) & 0xFFFF);
    }

    public byte[] valueBytes() {
        int len = this.buffer.getShort(2) & 0xFFFF;
        byte[] value = new byte[len];
        ((ByteBuffer)this.buffer.duplicate().position(4)).get(value);
        return value;
    }

    public ByteBuffer valueBuffer() {
        int len = this.buffer.getShort(2) & 0xFFFF;
        return ((ByteBuffer)this.buffer.duplicate().position(4).limit(len + 4)).slice();
    }

    public Value value() {
        switch (this.type()) {
            case SERVER_NAME: {
                return new ServerNameList(this.valueBuffer());
            }
            case MAX_FRAGMENT_LENGTH: {
                switch (this.valueBuffer().get() & 0xFF) {
                    case 1: {
                        return MaxFragmentLength.LEN_2_9;
                    }
                    case 2: {
                        return MaxFragmentLength.LEN_2_10;
                    }
                    case 3: {
                        return MaxFragmentLength.LEN_2_11;
                    }
                    case 4: {
                        return MaxFragmentLength.LEN_2_12;
                    }
                }
                throw new IllegalArgumentException("invalid max_fragment_len");
            }
            case TRUNCATED_HMAC: {
                return new TruncatedHMAC();
            }
            case CLIENT_CERTIFICATE_URL: {
                return new CertificateURL(this.valueBuffer());
            }
            case TRUSTED_CA_KEYS: {
                return new TrustedAuthorities(this.valueBuffer());
            }
            case STATUS_REQUEST: {
                return new CertificateStatusRequest(this.valueBuffer());
            }
        }
        return new UnresolvedExtensionValue(this.valueBuffer());
    }

    public void setLength(int newLength) {
        if (newLength < 0 || newLength > 65535) {
            throw new IllegalArgumentException("length is out of bounds");
        }
        this.buffer.putShort(2, (short)newLength);
    }

    public void setType(Type type) {
        this.buffer.putShort(0, (short)type.getValue());
    }

    public void setValue(byte[] value) {
        this.setValue(value, 0, value.length);
    }

    public void setValue(byte[] value, int offset, int length) {
        if (length != this.length()) {
            throw new IllegalArgumentException("length is different than claimed length");
        }
        ((ByteBuffer)this.buffer.duplicate().position(4)).put(value, offset, length);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("  type = " + (Object)((Object)this.type()) + ";");
        if (prefix != null) {
            out.print(prefix);
        }
        String subprefix = "  ";
        if (prefix != null) {
            subprefix = String.valueOf(prefix) + subprefix;
        }
        out.println("  value =");
        out.println(this.value().toString(subprefix));
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} Extension;");
        return str.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SERVER_NAME(0),
        MAX_FRAGMENT_LENGTH(1),
        CLIENT_CERTIFICATE_URL(2),
        TRUSTED_CA_KEYS(3),
        TRUNCATED_HMAC(4),
        STATUS_REQUEST(5),
        SRP(6),
        CERT_TYPE(7);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public static Type forValue(int value) {
            switch (value & 0xFFFF) {
                case 0: {
                    return SERVER_NAME;
                }
                case 1: {
                    return MAX_FRAGMENT_LENGTH;
                }
                case 2: {
                    return CLIENT_CERTIFICATE_URL;
                }
                case 3: {
                    return TRUSTED_CA_KEYS;
                }
                case 4: {
                    return TRUNCATED_HMAC;
                }
                case 5: {
                    return STATUS_REQUEST;
                }
                case 6: {
                    return SRP;
                }
                case 7: {
                    return CERT_TYPE;
                }
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static abstract class Value
    implements Builder,
    Constructed {
    }
}

