/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.io.Serializable;
import java.util.TooManyListenersException;

public class DragSourceContext
implements DragSourceListener,
DragSourceMotionListener,
Serializable {
    static final long serialVersionUID = -115407898692194719L;
    protected static final int DEFAULT = 0;
    protected static final int ENTER = 1;
    protected static final int OVER = 2;
    protected static final int CHANGED = 3;
    private DragSourceContextPeer peer;
    private Cursor cursor;
    private Transferable transferable;
    private DragGestureEvent trigger;
    private DragSourceListener dragSourceListener;
    private boolean useCustomCursor;
    private int sourceActions;
    private Image image;
    private Point offset;

    public DragSourceContext(DragSourceContextPeer peer, DragGestureEvent trigger, Cursor cursor, Image image, Point offset, Transferable trans, DragSourceListener dsl) {
        if (peer == null || trigger == null || trans == null || image != null && offset == null) {
            throw new NullPointerException();
        }
        if (trigger.getComponent() == null || trigger.getDragSource() == null || trigger.getDragAction() == 0 || trigger.getSourceAsDragGestureRecognizer().getSourceActions() == 0) {
            throw new IllegalArgumentException();
        }
        this.peer = peer;
        this.trigger = trigger;
        this.cursor = cursor;
        this.image = image;
        this.offset = offset;
        this.transferable = trans;
        this.dragSourceListener = dsl;
        this.sourceActions = trigger.getSourceAsDragGestureRecognizer().getSourceActions();
        this.setCursor(cursor);
        this.updateCurrentCursor(trigger.getDragAction(), this.sourceActions, 0);
    }

    public DragSource getDragSource() {
        return this.trigger.getDragSource();
    }

    public Component getComponent() {
        return this.trigger.getComponent();
    }

    public DragGestureEvent getTrigger() {
        return this.trigger;
    }

    public int getSourceActions() {
        if (this.sourceActions == 0) {
            this.sourceActions = this.trigger.getSourceAsDragGestureRecognizer().getSourceActions();
        }
        return this.sourceActions;
    }

    public void setCursor(Cursor cursor) {
        this.useCustomCursor = cursor != null;
        this.cursor = cursor;
        this.peer.setCursor(cursor);
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void addDragSourceListener(DragSourceListener dsl) throws TooManyListenersException {
        if (this.dragSourceListener != null) {
            throw new TooManyListenersException();
        }
        this.dragSourceListener = dsl;
    }

    public void removeDragSourceListener(DragSourceListener dsl) {
        if (this.dragSourceListener == dsl) {
            this.dragSourceListener = null;
        }
    }

    public void transferablesFlavorsChanged() {
        this.peer.transferablesFlavorsChanged();
    }

    public void dragEnter(DragSourceDragEvent e) {
        if (this.dragSourceListener != null) {
            this.dragSourceListener.dragEnter(e);
        }
        DragSource ds = this.getDragSource();
        DragSourceListener[] dsl = ds.getDragSourceListeners();
        int i = 0;
        while (i < dsl.length) {
            dsl[i].dragEnter(e);
            ++i;
        }
        this.updateCurrentCursor(e.getDropAction(), e.getTargetActions(), 1);
    }

    public void dragOver(DragSourceDragEvent e) {
        if (this.dragSourceListener != null) {
            this.dragSourceListener.dragOver(e);
        }
        DragSource ds = this.getDragSource();
        DragSourceListener[] dsl = ds.getDragSourceListeners();
        int i = 0;
        while (i < dsl.length) {
            dsl[i].dragOver(e);
            ++i;
        }
        this.updateCurrentCursor(e.getDropAction(), e.getTargetActions(), 2);
    }

    public void dragExit(DragSourceEvent e) {
        if (this.dragSourceListener != null) {
            this.dragSourceListener.dragExit(e);
        }
        DragSource ds = this.getDragSource();
        DragSourceListener[] dsl = ds.getDragSourceListeners();
        int i = 0;
        while (i < dsl.length) {
            dsl[i].dragExit(e);
            ++i;
        }
        this.updateCurrentCursor(0, 0, 0);
    }

    public void dropActionChanged(DragSourceDragEvent e) {
        if (this.dragSourceListener != null) {
            this.dragSourceListener.dropActionChanged(e);
        }
        DragSource ds = this.getDragSource();
        DragSourceListener[] dsl = ds.getDragSourceListeners();
        int i = 0;
        while (i < dsl.length) {
            dsl[i].dropActionChanged(e);
            ++i;
        }
        this.updateCurrentCursor(e.getDropAction(), e.getTargetActions(), 3);
    }

    public void dragDropEnd(DragSourceDropEvent e) {
        if (this.dragSourceListener != null) {
            this.dragSourceListener.dragDropEnd(e);
        }
        DragSource ds = this.getDragSource();
        DragSourceListener[] dsl = ds.getDragSourceListeners();
        int i = 0;
        while (i < dsl.length) {
            dsl[i].dragDropEnd(e);
            ++i;
        }
    }

    public void dragMouseMoved(DragSourceDragEvent e) {
        DragSource ds = this.getDragSource();
        DragSourceMotionListener[] dsml = ds.getDragSourceMotionListeners();
        int i = 0;
        while (i < dsml.length) {
            dsml[i].dragMouseMoved(e);
            ++i;
        }
    }

    public Transferable getTransferable() {
        return this.transferable;
    }

    protected void updateCurrentCursor(int dropOp, int targetAct, int status) {
        if (!this.useCustomCursor) {
            Cursor newCursor = null;
            switch (status) {
                default: {
                    targetAct = 0;
                }
                case 1: 
                case 2: 
                case 3: 
            }
            int action = dropOp & targetAct;
            newCursor = action == 0 ? ((dropOp & 0x40000000) != 0 ? DragSource.DefaultLinkNoDrop : ((dropOp & 2) != 0 ? DragSource.DefaultMoveNoDrop : DragSource.DefaultCopyNoDrop)) : ((dropOp & 0x40000000) != 0 ? DragSource.DefaultLinkDrop : ((dropOp & 2) != 0 ? DragSource.DefaultMoveDrop : DragSource.DefaultCopyDrop));
            if (this.cursor == null || !this.cursor.equals(newCursor)) {
                this.cursor = newCursor;
                DragSourceContextPeer p = this.peer;
                if (p != null) {
                    p.setCursor(this.cursor);
                }
            }
        }
    }
}

