/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastList;
import jd.core.model.instruction.fast.instruction.FastSwitch;
import jd.core.model.instruction.fast.instruction.FastTest2Lists;
import jd.core.model.instruction.fast.instruction.FastTry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DupLocalVariableAnalyzer {
    public static void Declare(ClassFile classFile, Method method, List<Instruction> list) {
        DupLocalVariableAnalyzer.RecursiveDeclare(classFile.getConstantPool(), method.getLocalVariables(), method.getCode().length, list);
    }

    private static void RecursiveDeclare(ConstantPool constants, LocalVariables localVariables, int codeLength, List<Instruction> list) {
        Instruction instruction;
        int length = list.size();
        int index = 0;
        while (index < length) {
            instruction = list.get(index);
            switch (instruction.opcode) {
                case 301: 
                case 302: 
                case 303: 
                case 304: 
                case 305: 
                case 306: 
                case 319: {
                    List<Instruction> instructions = ((FastList)instruction).instructions;
                    if (instructions == null) break;
                    DupLocalVariableAnalyzer.RecursiveDeclare(constants, localVariables, codeLength, instructions);
                    break;
                }
                case 307: {
                    FastTest2Lists ft2l = (FastTest2Lists)instruction;
                    DupLocalVariableAnalyzer.RecursiveDeclare(constants, localVariables, codeLength, ft2l.instructions);
                    DupLocalVariableAnalyzer.RecursiveDeclare(constants, localVariables, codeLength, ft2l.instructions2);
                    break;
                }
                case 314: 
                case 315: 
                case 316: {
                    FastSwitch.Pair[] pairs = ((FastSwitch)instruction).pairs;
                    if (pairs == null) break;
                    int i = pairs.length - 1;
                    while (i >= 0) {
                        List<Instruction> instructions = pairs[i].getInstructions();
                        if (instructions != null) {
                            DupLocalVariableAnalyzer.RecursiveDeclare(constants, localVariables, codeLength, instructions);
                        }
                        --i;
                    }
                    break;
                }
                case 318: {
                    int i;
                    FastTry ft = (FastTry)instruction;
                    DupLocalVariableAnalyzer.RecursiveDeclare(constants, localVariables, codeLength, ft.instructions);
                    if (ft.catches != null) {
                        i = ft.catches.size() - 1;
                        while (i >= 0) {
                            DupLocalVariableAnalyzer.RecursiveDeclare(constants, localVariables, codeLength, ft.catches.get((int)i).instructions);
                            --i;
                        }
                    }
                    if (ft.finallyInstructions == null) break;
                    DupLocalVariableAnalyzer.RecursiveDeclare(constants, localVariables, codeLength, ft.finallyInstructions);
                }
            }
            ++index;
        }
        int i = 0;
        while (i < length) {
            instruction = list.get(i);
            if (instruction.opcode == 264) {
                DupStore dupStore = (DupStore)instruction;
                String signature = dupStore.objectref.getReturnedSignature(constants, localVariables);
                int signatureIndex = constants.addConstantUtf8(signature);
                int nameIndex = constants.addConstantUtf8("tmp" + dupStore.offset + "_" + ((DupStore)instruction).objectref.offset);
                int varIndex = localVariables.size();
                LocalVariable lv = new LocalVariable(dupStore.offset, codeLength, nameIndex, signatureIndex, varIndex);
                lv.declarationFlag = true;
                localVariables.add(lv);
                list.set(i, new FastDeclaration(317, dupStore.offset, Instruction.UNKNOWN_LINE_NUMBER, lv.index, dupStore));
            }
            ++i;
        }
    }
}

