/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.ConflictDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.ValidatorDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public class AutoScaleAction
extends JosmAction {
    public static final Collection<String> MODES = Collections.unmodifiableList(Arrays.asList(I18n.marktr("data"), I18n.marktr("layer"), I18n.marktr("selection"), I18n.marktr("conflict"), I18n.marktr("download"), I18n.marktr("problem"), I18n.marktr("previous"), I18n.marktr("next")));
    private final String mode;
    protected long lastZoomTime = -1L;
    protected int lastZoomArea = -1;

    public static void zoomToSelection() {
        DataSet dataSet = MainApplication.getLayerManager().getActiveDataSet();
        if (dataSet == null) {
            return;
        }
        Collection<OsmPrimitive> sel = dataSet.getSelected();
        if (sel.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Nothing selected to zoom to.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
            return;
        }
        AutoScaleAction.zoomTo(sel);
    }

    public static void zoomTo(Collection<OsmPrimitive> sel) {
        BoundingXYVisitor bboxCalculator = new BoundingXYVisitor();
        bboxCalculator.computeBoundingBox(sel);
        bboxCalculator.enlargeBoundingBox();
        if (bboxCalculator.getBounds() != null) {
            MainApplication.getMap().mapView.zoomTo(bboxCalculator);
        }
    }

    public static void autoScale(String mode) {
        new AutoScaleAction(mode, false).autoScale();
    }

    private static int getModeShortcut(String mode) {
        int shortcut = -1;
        if (mode.equals("data")) {
            shortcut = 49;
        } else if (mode.equals("layer")) {
            shortcut = 50;
        } else if (mode.equals("selection")) {
            shortcut = 51;
        } else if (mode.equals("conflict")) {
            shortcut = 52;
        } else if (mode.equals("download")) {
            shortcut = 53;
        } else if (mode.equals("problem")) {
            shortcut = 54;
        } else if (mode.equals("previous")) {
            shortcut = 56;
        } else if (mode.equals("next")) {
            shortcut = 57;
        }
        return shortcut;
    }

    private AutoScaleAction(String mode, boolean marker) {
        super(marker);
        this.mode = mode;
    }

    public AutoScaleAction(String mode) {
        super(I18n.tr("Zoom to {0}", I18n.tr(mode, new Object[0])), "dialogs/autoscale/" + mode, I18n.tr("Zoom the view to {0}.", I18n.tr(mode, new Object[0])), Shortcut.registerShortcut("view:zoom" + mode, I18n.tr("View: {0}", I18n.tr("Zoom to {0}", I18n.tr(mode, new Object[0]))), AutoScaleAction.getModeShortcut(mode), 5003), true, null, false);
        String modeHelp = Character.toUpperCase(mode.charAt(0)) + mode.substring(1);
        this.putValue("help", "Action/AutoScale/" + modeHelp);
        this.mode = mode;
        switch (mode) {
            case "data": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToData"));
                break;
            }
            case "layer": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToLayer"));
                break;
            }
            case "selection": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToSelection"));
                break;
            }
            case "conflict": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToConflict"));
                break;
            }
            case "problem": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToProblem"));
                break;
            }
            case "download": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToDownload"));
                break;
            }
            case "previous": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToPrevious"));
                break;
            }
            case "next": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToNext"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode: " + mode);
            }
        }
        this.installAdapters();
    }

    public void autoScale() {
        if (MainApplication.isDisplayingMapView()) {
            MapView mapView = MainApplication.getMap().mapView;
            switch (this.mode) {
                case "previous": {
                    mapView.zoomPrevious();
                    break;
                }
                case "next": {
                    mapView.zoomNext();
                    break;
                }
                default: {
                    BoundingXYVisitor bbox = this.getBoundingBox();
                    if (bbox == null || bbox.getBounds() == null) break;
                    mapView.zoomTo(bbox);
                }
            }
        }
        this.putValue("active", Boolean.TRUE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.autoScale();
    }

    protected Layer getFirstSelectedLayer() {
        if (this.getLayerManager().getActiveLayer() == null) {
            return null;
        }
        try {
            List<Layer> layers = LayerListDialog.getInstance().getModel().getSelectedLayers();
            if (!layers.isEmpty()) {
                return layers.get(0);
            }
        }
        catch (IllegalStateException e) {
            Logging.error(e);
        }
        return null;
    }

    private BoundingXYVisitor getBoundingBox() {
        switch (this.mode) {
            case "problem": {
                return AutoScaleAction.modeProblem(new ValidatorDialog.ValidatorBoundingXYVisitor());
            }
            case "data": {
                return AutoScaleAction.modeData(new BoundingXYVisitor());
            }
            case "layer": {
                return this.modeLayer(new BoundingXYVisitor());
            }
            case "selection": 
            case "conflict": {
                return this.modeSelectionOrConflict(new BoundingXYVisitor());
            }
            case "download": {
                return this.modeDownload(new BoundingXYVisitor());
            }
        }
        return new BoundingXYVisitor();
    }

    private static BoundingXYVisitor modeProblem(ValidatorDialog.ValidatorBoundingXYVisitor v) {
        TestError error = MainApplication.getMap().validatorDialog.getSelectedError();
        if (error == null) {
            return null;
        }
        v.visit(error);
        if (v.getBounds() == null) {
            return null;
        }
        v.enlargeBoundingBox(Config.getPref().getDouble("validator.zoom-enlarge-bbox", 2.0E-4));
        return v;
    }

    private static BoundingXYVisitor modeData(BoundingXYVisitor v) {
        for (Layer l : MainApplication.getLayerManager().getLayers()) {
            l.visitBoundingBox(v);
        }
        return v;
    }

    private BoundingXYVisitor modeLayer(BoundingXYVisitor v) {
        Layer l = this.getFirstSelectedLayer();
        if (l == null) {
            return null;
        }
        l.visitBoundingBox(v);
        return v;
    }

    private BoundingXYVisitor modeSelectionOrConflict(BoundingXYVisitor v) {
        Collection<Object> sel = new HashSet();
        if ("selection".equals(this.mode)) {
            DataSet dataSet = this.getLayerManager().getActiveDataSet();
            if (dataSet != null) {
                sel = dataSet.getSelected();
            }
        } else {
            ConflictDialog conflictDialog = MainApplication.getMap().conflictDialog;
            Conflict<? extends OsmPrimitive> conflict = conflictDialog.getSelectedConflict();
            if (conflict != null) {
                sel.add(conflict.getMy());
            } else if (conflictDialog.getConflicts() != null) {
                sel = conflictDialog.getConflicts().getMyConflictParties();
            }
        }
        if (sel.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, "selection".equals(this.mode) ? I18n.tr("Nothing selected to zoom to.", new Object[0]) : I18n.tr("No conflicts to zoom to", new Object[0]), I18n.tr("Information", new Object[0]), 1);
            return null;
        }
        for (OsmPrimitive osmPrimitive : sel) {
            osmPrimitive.accept(v);
        }
        v.enlargeBoundingBoxLogarithmically(100.0);
        v.enlargeToMinSize(Config.getPref().getDouble("zoom_to_selection_min_size_in_meter", 100.0));
        return v;
    }

    private BoundingXYVisitor modeDownload(BoundingXYVisitor v) {
        DataSet dataset;
        if (this.lastZoomTime > 0L && System.currentTimeMillis() - this.lastZoomTime > Config.getPref().getLong("zoom.bounds.reset.time", TimeUnit.SECONDS.toMillis(10L))) {
            this.lastZoomTime = -1L;
        }
        if ((dataset = this.getLayerManager().getActiveDataSet()) != null) {
            ArrayList<DataSource> dataSources = new ArrayList<DataSource>(dataset.getDataSources());
            int s = dataSources.size();
            if (s > 0) {
                if (this.lastZoomTime == -1L || this.lastZoomArea == -1 || this.lastZoomArea > s) {
                    this.lastZoomArea = s - 1;
                    v.visit(((DataSource)dataSources.get((int)this.lastZoomArea)).bounds);
                } else if (this.lastZoomArea > 0) {
                    --this.lastZoomArea;
                    v.visit(((DataSource)dataSources.get((int)this.lastZoomArea)).bounds);
                } else {
                    this.lastZoomArea = -1;
                    Area sourceArea = this.getLayerManager().getActiveDataSet().getDataSourceArea();
                    if (sourceArea != null) {
                        v.visit(new Bounds(sourceArea.getBounds2D()));
                    }
                }
                this.lastZoomTime = System.currentTimeMillis();
            } else {
                this.lastZoomTime = -1L;
                this.lastZoomArea = -1;
            }
        }
        return v;
    }

    @Override
    protected void updateEnabledState() {
        DataSet ds = this.getLayerManager().getActiveDataSet();
        MapFrame map = MainApplication.getMap();
        switch (this.mode) {
            case "selection": {
                this.setEnabled(ds != null && !ds.selectionEmpty());
                break;
            }
            case "layer": {
                this.setEnabled(this.getFirstSelectedLayer() != null);
                break;
            }
            case "conflict": {
                this.setEnabled(map != null && map.conflictDialog.getSelectedConflict() != null);
                break;
            }
            case "download": {
                this.setEnabled(ds != null && !ds.getDataSources().isEmpty());
                break;
            }
            case "problem": {
                this.setEnabled(map != null && map.validatorDialog.getSelectedError() != null);
                break;
            }
            case "previous": {
                this.setEnabled(MainApplication.isDisplayingMapView() && map.mapView.hasZoomUndoEntries());
                break;
            }
            case "next": {
                this.setEnabled(MainApplication.isDisplayingMapView() && map.mapView.hasZoomRedoEntries());
                break;
            }
            default: {
                this.setEnabled(!this.getLayerManager().getLayers().isEmpty());
            }
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if ("selection".equals(this.mode)) {
            this.setEnabled(selection != null && !selection.isEmpty());
        }
    }

    @Override
    protected final void installAdapters() {
        super.installAdapters();
        MapView.addZoomChangeListener(new ZoomChangeAdapter());
        MainApplication.addMapFrameListener(new MapFrameAdapter());
        this.initEnabledState();
    }

    private class MapFrameAdapter
    implements MapFrameListener {
        private ListSelectionListener conflictSelectionListener;
        private TreeSelectionListener validatorSelectionListener;

        MapFrameAdapter() {
            if ("conflict".equals(AutoScaleAction.this.mode)) {
                this.conflictSelectionListener = e -> AutoScaleAction.this.updateEnabledState();
            } else if ("problem".equals(AutoScaleAction.this.mode)) {
                this.validatorSelectionListener = e -> AutoScaleAction.this.updateEnabledState();
            }
        }

        @Override
        public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
            if (this.conflictSelectionListener != null) {
                if (newFrame != null) {
                    newFrame.conflictDialog.addListSelectionListener(this.conflictSelectionListener);
                } else if (oldFrame != null) {
                    oldFrame.conflictDialog.removeListSelectionListener(this.conflictSelectionListener);
                }
            } else if (this.validatorSelectionListener != null) {
                if (newFrame != null) {
                    newFrame.validatorDialog.addTreeSelectionListener(this.validatorSelectionListener);
                } else if (oldFrame != null) {
                    oldFrame.validatorDialog.removeTreeSelectionListener(this.validatorSelectionListener);
                }
            }
            AutoScaleAction.this.updateEnabledState();
        }
    }

    private class ZoomChangeAdapter
    implements NavigatableComponent.ZoomChangeListener {
        private ZoomChangeAdapter() {
        }

        @Override
        public void zoomChanged() {
            AutoScaleAction.this.updateEnabledState();
        }
    }
}

