/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import java.awt.Color;
import java.util.List;
import org.openstreetmap.josm.tools.ColorHelper;

public class ColorInfo {
    private String category;
    private String source;
    private String name;
    private Color value;
    private Color defaultValue;

    public ColorInfo() {
    }

    public ColorInfo(String category, String source, String name, Color value, Color defaultValue) {
        this.category = category;
        this.source = source;
        this.name = name;
        this.value = value;
        this.defaultValue = defaultValue;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public Color getValue() {
        return this.value;
    }

    public Color getDefaultValue() {
        return this.defaultValue;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(Color value) {
        this.value = value;
    }

    public void setDefaultValue(Color defaultValue) {
        this.defaultValue = defaultValue;
    }

    public static ColorInfo fromPref(List<String> lst, boolean isDefault) {
        if (lst == null || lst.size() < 4) {
            return null;
        }
        Color clr = ColorHelper.html2color(lst.get(0));
        if (clr == null) {
            return null;
        }
        ColorInfo info = new ColorInfo();
        if (isDefault) {
            info.defaultValue = clr;
        } else {
            info.value = clr;
        }
        info.category = lst.get(1);
        info.source = lst.get(2);
        if (info.source.isEmpty()) {
            info.source = null;
        }
        info.name = lst.get(3);
        return info;
    }
}

