/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mix(vec3(-2.0, -2.0, 2.0), vec3(-3.0, 3.0, -3.0), 0.0) => vec3(-2.0, -2.0, 2.0)
 * mix(vec3(2.0, -2.0, -2.0), vec3(3.0, -3.0, 3.0), 0.0) => vec3(2.0, -2.0, -2.0)
 * mix(vec3(-2.0, -2.0, 2.0), vec3(-3.0, 3.0, -3.0), 0.33333334) => vec3(-2.3333333, -0.33333328, 0.33333328)
 * mix(vec3(2.0, -2.0, -2.0), vec3(3.0, -3.0, 3.0), 0.33333334) => vec3(2.3333333, -2.3333333, -0.33333328)
 * mix(vec3(-2.0, -2.0, 2.0), vec3(-3.0, 3.0, -3.0), 0.66666669) => vec3(-2.6666667, 1.3333335, -1.3333335)
 * mix(vec3(2.0, -2.0, -2.0), vec3(3.0, -3.0, 3.0), 0.66666669) => vec3(2.6666667, -2.6666667, 1.3333335)
 * mix(vec3(-2.0, -2.0, 2.0), vec3(-3.0, 3.0, -3.0), 1.0) => vec3(-3.0, 3.0, -3.0)
 * mix(vec3(2.0, -2.0, -2.0), vec3(3.0, -3.0, 3.0), 1.0) => vec3(3.0, -3.0, 3.0)
 */
#version 120

void main()
{
  float[distance(mix(vec3(-2.0, -2.0, 2.0), vec3(-3.0, 3.0, -3.0), 0.0), vec3(-2.0, -2.0, 2.0)) <= 3.4641016e-05 ? 1 : -1] array0;
  float[distance(mix(vec3(2.0, -2.0, -2.0), vec3(3.0, -3.0, 3.0), 0.0), vec3(2.0, -2.0, -2.0)) <= 3.4641016e-05 ? 1 : -1] array1;
  float[distance(mix(vec3(-2.0, -2.0, 2.0), vec3(-3.0, 3.0, -3.0), 0.33333334), vec3(-2.3333333, -0.33333328, 0.33333328)) <= 2.3804763e-05 ? 1 : -1] array2;
  float[distance(mix(vec3(2.0, -2.0, -2.0), vec3(3.0, -3.0, 3.0), 0.33333334), vec3(2.3333333, -2.3333333, -0.33333328)) <= 3.3166249e-05 ? 1 : -1] array3;
  float[distance(mix(vec3(-2.0, -2.0, 2.0), vec3(-3.0, 3.0, -3.0), 0.66666669), vec3(-2.6666667, 1.3333335, -1.3333335)) <= 3.2659864e-05 ? 1 : -1] array4;
  float[distance(mix(vec3(2.0, -2.0, -2.0), vec3(3.0, -3.0, 3.0), 0.66666669), vec3(2.6666667, -2.6666667, 1.3333335)) <= 3.9999999e-05 ? 1 : -1] array5;
  float[distance(mix(vec3(-2.0, -2.0, 2.0), vec3(-3.0, 3.0, -3.0), 1.0), vec3(-3.0, 3.0, -3.0)) <= 5.1961521e-05 ? 1 : -1] array6;
  float[distance(mix(vec3(2.0, -2.0, -2.0), vec3(3.0, -3.0, 3.0), 1.0), vec3(3.0, -3.0, 3.0)) <= 5.1961521e-05 ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
