/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (vec2(-0.1, -1.2) / vec2(-0.1, -1.2)) => vec2(1.0, 1.0)
 * (vec2(-0.1, -1.2) / vec2(-0.41999999, 0.47999999)) => vec2(0.23809525, -2.5000002)
 * (vec2(-0.41999999, 0.47999999) / vec2(-0.1, -1.2)) => vec2(4.1999998, -0.39999998)
 * (vec2(-0.41999999, 0.47999999) / vec2(-0.41999999, 0.47999999)) => vec2(1.0, 1.0)
 */
#version 150

void main()
{
  float[distance((vec2(-0.1, -1.2) / vec2(-0.1, -1.2)), vec2(1.0, 1.0)) <= 1.4142136e-05 ? 1 : -1] array0;
  float[distance((vec2(-0.1, -1.2) / vec2(-0.41999999, 0.47999999)), vec2(0.23809525, -2.5000002)) <= 2.5113124e-05 ? 1 : -1] array1;
  float[distance((vec2(-0.41999999, 0.47999999) / vec2(-0.1, -1.2)), vec2(4.1999998, -0.39999998)) <= 4.2190044e-05 ? 1 : -1] array2;
  float[distance((vec2(-0.41999999, 0.47999999) / vec2(-0.41999999, 0.47999999)), vec2(1.0, 1.0)) <= 1.4142136e-05 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
