/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * pow(vec2(0.0, 0.0), vec2(0.66666669, 2.0)) => vec2(0.0, 0.0)
 * pow(vec2(0.66666669, 0.66666669), vec2(-2.0, -0.66666669)) => vec2(2.2499998, 1.3103707)
 * pow(vec2(0.66666669, 0.66666669), vec2(0.66666669, 2.0)) => vec2(0.76314282, 0.44444448)
 * pow(vec2(1.3333334, 1.3333334), vec2(-2.0, -0.66666669)) => vec2(0.56249994, 0.82548177)
 * pow(vec2(1.3333334, 1.3333334), vec2(0.66666669, 2.0)) => vec2(1.2114137, 1.7777779)
 * pow(vec2(2.0, 2.0), vec2(-2.0, -0.66666669)) => vec2(0.25, 0.62996054)
 * pow(vec2(2.0, 2.0), vec2(0.66666669, 2.0)) => vec2(1.587401, 4.0)
 */
#version 150

void main()
{
  float[distance(pow(vec2(0.0, 0.0), vec2(0.66666669, 2.0)), vec2(0.0, 0.0)) <= 0.0 ? 1 : -1] array0;
  float[distance(pow(vec2(0.66666669, 0.66666669), vec2(-2.0, -0.66666669)), vec2(2.2499998, 1.3103707)) <= 2.6037609e-05 ? 1 : -1] array1;
  float[distance(pow(vec2(0.66666669, 0.66666669), vec2(0.66666669, 2.0)), vec2(0.76314282, 0.44444448)) <= 8.8312954e-06 ? 1 : -1] array2;
  float[distance(pow(vec2(1.3333334, 1.3333334), vec2(-2.0, -0.66666669)), vec2(0.56249994, 0.82548177)) <= 9.9891258e-06 ? 1 : -1] array3;
  float[distance(pow(vec2(1.3333334, 1.3333334), vec2(0.66666669, 2.0)), vec2(1.2114137, 1.7777779)) <= 2.1512828e-05 ? 1 : -1] array4;
  float[distance(pow(vec2(2.0, 2.0), vec2(-2.0, -0.66666669)), vec2(0.25, 0.62996054)) <= 6.7775381e-06 ? 1 : -1] array5;
  float[distance(pow(vec2(2.0, 2.0), vec2(0.66666669, 2.0)), vec2(1.587401, 4.0)) <= 4.3034684e-05 ? 1 : -1] array6;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length());
}
