/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf / dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf)) => dvec3(-0.0lf, -0.0lf, -0.0lf)
 * (0.0lf / dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf)) => dvec3(0.0lf, 0.0lf, 0.0lf)
 * (-1.3333333333333333lf / dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf)) => dvec3(1.0lf, 1.5686274509803921lf, 1.4184397163120568lf)
 * (-1.3333333333333333lf / dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf)) => dvec3(-0.79840319361277445lf, -2.0202020202020199lf, -0.71301247771835996lf)
 * (0.84999999999999998lf / dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf)) => dvec3(-0.63750000000000007lf, -1.0lf, -0.9042553191489362lf)
 * (0.84999999999999998lf / dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf)) => dvec3(0.50898203592814373lf, 1.2878787878787878lf, 0.45454545454545453lf)
 */
#version 400

void main()
{
  double[distance((0.0lf / dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf)), dvec3(-0.0lf, -0.0lf, -0.0lf)) <= 0.0lf ? 1 : -1] array0;
  double[distance((0.0lf / dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf)), dvec3(0.0lf, 0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array1;
  double[distance((-1.3333333333333333lf / dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf)), dvec3(1.0lf, 1.5686274509803921lf, 1.4184397163120568lf)) <= 2.3393510443669356e-05lf ? 1 : -1] array2;
  double[distance((-1.3333333333333333lf / dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf)), dvec3(-0.79840319361277445lf, -2.0202020202020199lf, -0.71301247771835996lf)) <= 2.2862744050925902e-05lf ? 1 : -1] array3;
  double[distance((0.84999999999999998lf / dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf)), dvec3(-0.63750000000000007lf, -1.0lf, -0.9042553191489362lf)) <= 1.4913362907839214e-05lf ? 1 : -1] array4;
  double[distance((0.84999999999999998lf / dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf)), dvec3(0.50898203592814373lf, 1.2878787878787878lf, 0.45454545454545453lf)) <= 1.4574999332465262e-05lf ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
