/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.impl.VcsStatusDescriptor;
import git4idea.GitUtil;
import git4idea.history.GitChangeType;
import git4idea.history.GitChangesParser;
import git4idea.history.GitLogStatusInfo;
import git4idea.history.GitLogUtil;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitCommit
extends VcsChangesLazilyParsedDetails {
    private static final Logger LOG = Logger.getInstance(GitCommit.class);
    @NotNull
    private final GitLogUtil.DiffRenameLimit myRenameLimit;

    /*
     * WARNING - void declaration
     */
    public GitCommit(Project project, @NotNull Hash hash, @NotNull List<Hash> parents, long commitTime, @NotNull VirtualFile root, @NotNull String subject, @NotNull VcsUser author, @NotNull String message, @NotNull VcsUser committer, long authorTime, @NotNull List<List<GitLogStatusInfo>> list, @NotNull GitLogUtil.DiffRenameLimit diffRenameLimit) {
        void reportedChanges;
        void renameLimit;
        if (hash == null) {
            GitCommit.$$$reportNull$$$0(0);
        }
        if (parents == null) {
            GitCommit.$$$reportNull$$$0(1);
        }
        if (root == null) {
            GitCommit.$$$reportNull$$$0(2);
        }
        if (subject == null) {
            GitCommit.$$$reportNull$$$0(3);
        }
        if (author == null) {
            GitCommit.$$$reportNull$$$0(4);
        }
        if (message == null) {
            GitCommit.$$$reportNull$$$0(5);
        }
        if (committer == null) {
            GitCommit.$$$reportNull$$$0(6);
        }
        if (list == null) {
            GitCommit.$$$reportNull$$$0(7);
        }
        if (diffRenameLimit == null) {
            GitCommit.$$$reportNull$$$0(8);
        }
        super(hash, parents, commitTime, root, subject, author, message, committer, authorTime);
        this.myRenameLimit = renameLimit;
        this.myChanges.set(new UnparsedChanges(project, (List)reportedChanges));
    }

    public boolean hasRenames() {
        switch (this.myRenameLimit) {
            case INFINITY: {
                return true;
            }
            case GIT_CONFIG: {
                return false;
            }
            case REGISTRY: {
                VcsChangesLazilyParsedDetails.Changes changes = (VcsChangesLazilyParsedDetails.Changes)this.myChanges.get();
                int estimate = changes instanceof UnparsedChanges ? ((UnparsedChanges)changes).getRenameLimitEstimate() : this.getRenameLimitEstimate();
                return estimate <= Registry.intValue((String)"git.diff.renameLimit");
            }
        }
        return true;
    }

    private int getRenameLimitEstimate() {
        int size = 0;
        for (int i = 0; i < this.getParents().size(); ++i) {
            int sources = 0;
            int targets = 0;
            for (Change info : this.getChanges(i)) {
                Change.Type type = info.getType();
                if (ContainerUtil.set((Object[])new Change.Type[]{Change.Type.DELETED, Change.Type.MOVED}).contains(type)) {
                    ++sources;
                }
                if (!ContainerUtil.set((Object[])new Change.Type[]{Change.Type.NEW}).contains(type)) continue;
                ++targets;
            }
            size = Math.max(Math.max(sources, targets), size);
        }
        return size;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "hash";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parents";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "subject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "author";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "message";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "committer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "reportedChanges";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[0] = "renameLimit";
                break;
            }
        }
        objectArray[1] = "git4idea/GitCommit";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GitChangesDescriptor
    extends VcsStatusDescriptor<GitLogStatusInfo> {
        private GitChangesDescriptor() {
        }

        @NotNull
        protected GitLogStatusInfo createStatus(@NotNull Change.Type type, @NotNull String path, @Nullable String secondPath) {
            if (type == null) {
                GitChangesDescriptor.$$$reportNull$$$0(0);
            }
            if (path == null) {
                GitChangesDescriptor.$$$reportNull$$$0(1);
            }
            GitLogStatusInfo gitLogStatusInfo = new GitLogStatusInfo(this.getType(type), path, secondPath);
            if (gitLogStatusInfo == null) {
                GitChangesDescriptor.$$$reportNull$$$0(2);
            }
            return gitLogStatusInfo;
        }

        @NotNull
        private GitChangeType getType(@NotNull Change.Type type) {
            if (type == null) {
                GitChangesDescriptor.$$$reportNull$$$0(3);
            }
            switch (type) {
                case MODIFICATION: {
                    GitChangeType gitChangeType = GitChangeType.MODIFIED;
                    if (gitChangeType == null) {
                        GitChangesDescriptor.$$$reportNull$$$0(4);
                    }
                    return gitChangeType;
                }
                case NEW: {
                    GitChangeType gitChangeType = GitChangeType.ADDED;
                    if (gitChangeType == null) {
                        GitChangesDescriptor.$$$reportNull$$$0(5);
                    }
                    return gitChangeType;
                }
                case DELETED: {
                    GitChangeType gitChangeType = GitChangeType.DELETED;
                    if (gitChangeType == null) {
                        GitChangesDescriptor.$$$reportNull$$$0(6);
                    }
                    return gitChangeType;
                }
                case MOVED: {
                    GitChangeType gitChangeType = GitChangeType.RENAMED;
                    if (gitChangeType == null) {
                        GitChangesDescriptor.$$$reportNull$$$0(7);
                    }
                    return gitChangeType;
                }
            }
            if (null == null) {
                GitChangesDescriptor.$$$reportNull$$$0(8);
            }
            return null;
        }

        @NotNull
        public String getFirstPath(@NotNull GitLogStatusInfo info) {
            if (info == null) {
                GitChangesDescriptor.$$$reportNull$$$0(9);
            }
            String string = info.getFirstPath();
            if (string == null) {
                GitChangesDescriptor.$$$reportNull$$$0(10);
            }
            return string;
        }

        @Nullable
        public String getSecondPath(@NotNull GitLogStatusInfo info) {
            if (info == null) {
                GitChangesDescriptor.$$$reportNull$$$0(11);
            }
            return info.getSecondPath();
        }

        @NotNull
        public Change.Type getType(@NotNull GitLogStatusInfo info) {
            if (info == null) {
                GitChangesDescriptor.$$$reportNull$$$0(12);
            }
            switch (info.getType()) {
                case ADDED: {
                    Change.Type type = Change.Type.NEW;
                    if (type == null) {
                        GitChangesDescriptor.$$$reportNull$$$0(13);
                    }
                    return type;
                }
                case MODIFIED: 
                case TYPE_CHANGED: {
                    Change.Type type = Change.Type.MODIFICATION;
                    if (type == null) {
                        GitChangesDescriptor.$$$reportNull$$$0(14);
                    }
                    return type;
                }
                case DELETED: {
                    Change.Type type = Change.Type.DELETED;
                    if (type == null) {
                        GitChangesDescriptor.$$$reportNull$$$0(15);
                    }
                    return type;
                }
                case COPIED: 
                case RENAMED: {
                    Change.Type type = Change.Type.MOVED;
                    if (type == null) {
                        GitChangesDescriptor.$$$reportNull$$$0(16);
                    }
                    return type;
                }
                case UNRESOLVED: {
                    LOG.error("Unsupported status info " + info);
                }
            }
            if (null == null) {
                GitChangesDescriptor.$$$reportNull$$$0(17);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/GitCommit$GitChangesDescriptor";
                    break;
                }
                case 9: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/GitCommit$GitChangesDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStatus";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFirstPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createStatus";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                case 3: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getType";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getFirstPath";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getSecondPath";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class UnparsedChanges
    extends VcsChangesLazilyParsedDetails.UnparsedChanges<GitLogStatusInfo> {
        private UnparsedChanges(@NotNull Project project, List<List<GitLogStatusInfo>> changesOutput) {
            if (project == null) {
                UnparsedChanges.$$$reportNull$$$0(0);
            }
            if (changesOutput == null) {
                UnparsedChanges.$$$reportNull$$$0(1);
            }
            super((VcsChangesLazilyParsedDetails)GitCommit.this, project, changesOutput, (VcsStatusDescriptor)new GitChangesDescriptor());
        }

        @NotNull
        protected String absolutePath(@NotNull String path) {
            String string;
            if (path == null) {
                UnparsedChanges.$$$reportNull$$$0(2);
            }
            try {
                string = GitCommit.this.getRoot().getPath() + "/" + GitUtil.unescapePath(path);
            }
            catch (VcsException e) {
                String string2 = GitCommit.this.getRoot().getPath() + "/" + path;
                if (string2 == null) {
                    UnparsedChanges.$$$reportNull$$$0(4);
                }
                return string2;
            }
            if (string == null) {
                UnparsedChanges.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        protected List<Change> parseStatusInfo(@NotNull List<GitLogStatusInfo> changes, int parentIndex) throws VcsException {
            if (changes == null) {
                UnparsedChanges.$$$reportNull$$$0(5);
            }
            String parentHash = null;
            if (parentIndex < GitCommit.this.getParents().size()) {
                parentHash = ((Hash)GitCommit.this.getParents().get(parentIndex)).asString();
            }
            List<Change> list = GitChangesParser.parse(this.myProject, GitCommit.this.getRoot(), changes, GitCommit.this.getId().asString(), new Date(GitCommit.this.getCommitTime()), parentHash);
            if (list == null) {
                UnparsedChanges.$$$reportNull$$$0(6);
            }
            return list;
        }

        public int getRenameLimitEstimate() {
            int size = 0;
            for (List changesWithParent : this.myChangesOutput) {
                int sources = 0;
                int targets = 0;
                for (GitLogStatusInfo info : changesWithParent) {
                    GitChangeType type = info.getType();
                    if (ContainerUtil.set((Object[])new GitChangeType[]{GitChangeType.DELETED, GitChangeType.RENAMED}).contains((Object)type)) {
                        ++sources;
                    }
                    if (!ContainerUtil.set((Object[])new GitChangeType[]{GitChangeType.ADDED}).contains((Object)type)) continue;
                    ++targets;
                }
                size = Math.max(Math.max(sources, targets), size);
            }
            return size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesOutput";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/GitCommit$UnparsedChanges";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/GitCommit$UnparsedChanges";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "absolutePath";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseStatusInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "absolutePath";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "parseStatusInfo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

