/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.history.GitLogStatusInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitChangesParser {
    @NotNull
    public static List<Change> parse(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<GitLogStatusInfo> statusInfos, @NotNull String hash, @NotNull Date date, @Nullable String parentsHash) throws VcsException {
        if (project == null) {
            GitChangesParser.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitChangesParser.$$$reportNull$$$0(1);
        }
        if (statusInfos == null) {
            GitChangesParser.$$$reportNull$$$0(2);
        }
        if (hash == null) {
            GitChangesParser.$$$reportNull$$$0(3);
        }
        if (date == null) {
            GitChangesParser.$$$reportNull$$$0(4);
        }
        GitRevisionNumber thisRevision = new GitRevisionNumber(hash, date);
        GitRevisionNumber parentRevision = parentsHash == null ? null : new GitRevisionNumber(parentsHash);
        ArrayList<Change> result2 = new ArrayList<Change>();
        for (GitLogStatusInfo statusInfo : statusInfos) {
            result2.add(GitChangesParser.parseChange(project, root, (VcsRevisionNumber)thisRevision, (VcsRevisionNumber)parentRevision, statusInfo));
        }
        ArrayList<Change> arrayList = result2;
        if (arrayList == null) {
            GitChangesParser.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static Change parseChange(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull VcsRevisionNumber thisRevision, @Nullable VcsRevisionNumber parentRevision, @NotNull GitLogStatusInfo statusInfo) throws VcsException {
        ContentRevision after;
        ContentRevision before;
        if (project == null) {
            GitChangesParser.$$$reportNull$$$0(6);
        }
        if (vcsRoot == null) {
            GitChangesParser.$$$reportNull$$$0(7);
        }
        if (thisRevision == null) {
            GitChangesParser.$$$reportNull$$$0(8);
        }
        if (statusInfo == null) {
            GitChangesParser.$$$reportNull$$$0(9);
        }
        FileStatus status = null;
        String path = statusInfo.getFirstPath();
        switch (statusInfo.getType()) {
            case ADDED: {
                before = null;
                status = FileStatus.ADDED;
                after = GitContentRevision.createRevision(vcsRoot, path, thisRevision, project, false, true);
                break;
            }
            case UNRESOLVED: {
                status = FileStatus.MERGED_WITH_CONFLICTS;
            }
            case MODIFIED: {
                if (status == null) {
                    status = FileStatus.MODIFIED;
                }
                FilePath filePath = GitContentRevision.createPath(vcsRoot, path, true, true);
                before = GitContentRevision.createRevision(vcsRoot, path, parentRevision, project, false, true);
                after = GitContentRevision.createRevision(filePath, thisRevision, project, null);
                break;
            }
            case DELETED: {
                status = FileStatus.DELETED;
                FilePath filePathDeleted = GitContentRevision.createPath(vcsRoot, path, true, true);
                before = GitContentRevision.createRevision(filePathDeleted, parentRevision, project, null);
                after = null;
                break;
            }
            case COPIED: 
            case RENAMED: {
                status = FileStatus.MODIFIED;
                String secondPath = statusInfo.getSecondPath();
                FilePath filePathAfterRename = GitContentRevision.createPath(vcsRoot, secondPath == null ? path : secondPath, false, true);
                before = GitContentRevision.createRevision(vcsRoot, path, parentRevision, project, true, true);
                after = GitContentRevision.createRevision(filePathAfterRename, thisRevision, project, null);
                break;
            }
            case TYPE_CHANGED: {
                status = FileStatus.MODIFIED;
                FilePath filePath2 = GitContentRevision.createPath(vcsRoot, path, true, true);
                before = GitContentRevision.createRevision(vcsRoot, path, parentRevision, project, false, true);
                after = GitContentRevision.createRevision(filePath2, thisRevision, project, null);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown file status: " + statusInfo));
            }
        }
        Change change = new Change(before, after, status);
        if (change == null) {
            GitChangesParser.$$$reportNull$$$0(10);
        }
        return change;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusInfos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitChangesParser";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisRevision";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitChangesParser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 5: 
            case 10: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

