/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ReadOnlyModificationException;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.UnknownMacroNotification;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001aB\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u000f0\n2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0000\u001a\u001b\u0010\u0012\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015\u001a \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u001f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f*\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0014H\u0000\u00a2\u0006\u0002\u0010 \"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006!"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "deprecatedComparator", "Ljava/util/Comparator;", "Lcom/intellij/openapi/components/Storage;", "getDeprecatedComparator", "()Ljava/util/Comparator;", "executeSave", "", "", "session", "Lcom/intellij/openapi/components/StateStorage$SaveSession;", "readonlyFiles", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "previousErrors", "findNonDeprecated", "storages", "", "([Lcom/intellij/openapi/components/Storage;)Lcom/intellij/openapi/components/Storage;", "notifyUnknownMacros", "", "store", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "project", "Lcom/intellij/openapi/project/Project;", "componentName", "", "sortByDeprecated", "", "([Lcom/intellij/openapi/components/Storage;)Ljava/util/List;", "configuration-store-impl"})
public final class ComponentStoreImplKt {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ComponentStoreImpl.class);
    @NotNull
    private static final Comparator<Storage> deprecatedComparator = deprecatedComparator.1.INSTANCE;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    @NotNull
    public static final Comparator<Storage> getDeprecatedComparator() {
        return deprecatedComparator;
    }

    @Nullable
    public static final List<Throwable> executeSave(@NotNull StateStorage.SaveSession session2, @NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles, @Nullable List<Throwable> previousErrors) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
        List errors = previousErrors;
        try {
            session2.save();
        }
        catch (ReadOnlyModificationException e) {
            LOG.warn((Throwable)e);
            StateStorage.SaveSession saveSession = e.getSession();
            if (saveSession == null) {
                saveSession = session2;
            }
            Pair pair = Pair.create((Object)saveSession, (Object)e.getFile());
            Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"JBPair.create<SaveSessio\u2026ssion ?: session, e.file)");
            readonlyFiles.add((Pair<StateStorage.SaveSession, VirtualFile>)pair);
        }
        catch (Exception e) {
            if (errors == null) {
                errors = (List)new SmartList();
            }
            errors.add((Throwable)e);
        }
        return errors;
    }

    private static final Storage findNonDeprecated(Storage[] storages) {
        Object object;
        block2: {
            Object[] $receiver$iv = storages;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                Storage it = (Storage)element$iv;
                if (!(!it.deprecated())) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        Storage storage2 = (Storage)object;
        if (storage2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)"All storages are deprecated"));
        }
        return storage2;
    }

    @NotNull
    public static final List<Storage> sortByDeprecated(@NotNull Storage[] $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (((Object[])$receiver).length < 2) {
            return ArraysKt.toList((Object[])$receiver);
        }
        if (!((Storage)ArraysKt.first((Object[])$receiver)).deprecated()) {
            boolean othersAreDeprecated;
            block6: {
                boolean bl;
                Iterable $receiver$iv = (Iterable)RangesKt.until((int)1, (int)((Object[])$receiver).length);
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $receiver$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv = ((IntIterator)iterator).nextInt();
                        int it = element$iv;
                        if (!((Storage)((Object[])$receiver)[it]).deprecated()) continue;
                        bl = true;
                        break block6;
                    }
                    bl = othersAreDeprecated = false;
                }
            }
            if (othersAreDeprecated) {
                return ArraysKt.toList((Object[])$receiver);
            }
        }
        return ArraysKt.sortedWith((Object[])$receiver, deprecatedComparator);
    }

    private static final void notifyUnknownMacros(IComponentStore store, Project project, String componentName) {
        TrackingPathMacroSubstitutor trackingPathMacroSubstitutor = store.getStateStorageManager().getMacroSubstitutor();
        if (trackingPathMacroSubstitutor == null) {
            return;
        }
        TrackingPathMacroSubstitutor substitutor = trackingPathMacroSubstitutor;
        Set<String> immutableMacros = substitutor.getUnknownMacros(componentName);
        if (immutableMacros.isEmpty()) {
            return;
        }
        LinkedHashSet macros = new LinkedHashSet(immutableMacros);
        AppUIUtil.invokeOnEdt(new Runnable(project, macros, componentName, substitutor, store){
            final /* synthetic */ Project $project;
            final /* synthetic */ LinkedHashSet $macros;
            final /* synthetic */ String $componentName;
            final /* synthetic */ TrackingPathMacroSubstitutor $substitutor;
            final /* synthetic */ IComponentStore $store;

            public final void run() {
                List notified = null;
                NotificationsManager manager = NotificationsManager.getNotificationsManager();
                UnknownMacroNotification[] unknownMacroNotificationArray = (UnknownMacroNotification[])manager.getNotificationsOfType(UnknownMacroNotification.class, this.$project);
                for (int i = 0; i < unknownMacroNotificationArray.length; ++i) {
                    UnknownMacroNotification notification = unknownMacroNotificationArray[i];
                    if (notified == null) {
                        notified = (List)new SmartList();
                    }
                    Collection<String> collection = notification.getMacros();
                    Intrinsics.checkExpressionValueIsNotNull(collection, (String)"notification.macros");
                    notified.addAll(collection);
                }
                if (!UtilKt.isNullOrEmpty(notified)) {
                    List list2 = notified;
                    if (list2 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$macros.removeAll(list2);
                }
                if (this.$macros.isEmpty()) {
                    return;
                }
                ComponentStoreImplKt.getLOG().debug("Reporting unknown path macros " + this.$macros + " in component " + this.$componentName);
                Set set2 = this.$macros;
                Map<TrackingPathMacroSubstitutor, IComponentStore> map2 = Collections.singletonMap(this.$substitutor, this.$store);
                Intrinsics.checkExpressionValueIsNotNull(map2, (String)"Collections.singletonMap(substitutor, store)");
                StorageUtilKt.doNotify(set2, this.$project, map2);
            }
            {
                this.$project = project;
                this.$macros = linkedHashSet;
                this.$componentName = string;
                this.$substitutor = trackingPathMacroSubstitutor;
                this.$store = iComponentStore;
            }
        }, project.getDisposed());
    }

    public static final /* synthetic */ void access$notifyUnknownMacros(@NotNull IComponentStore store, @NotNull Project project, @NotNull String componentName) {
        ComponentStoreImplKt.notifyUnknownMacros(store, project, componentName);
    }

    @NotNull
    public static final /* synthetic */ Storage access$findNonDeprecated(@NotNull Storage[] storages) {
        return ComponentStoreImplKt.findNonDeprecated(storages);
    }
}

