/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.FormatProcessor;
import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.InitialInfoBuilderState;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.RangesAssert;
import com.intellij.formatting.ReadOnlyBlockContainer;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.WrapImpl;
import com.intellij.formatting.engine.ExpandableIndent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InitialInfoBuilder {
    private static final RangesAssert ASSERT = new RangesAssert();
    private static final boolean INLINE_TABS_ENABLED = "true".equalsIgnoreCase(System.getProperty("inline.tabs.enabled"));
    private final Map<AbstractBlockWrapper, Block> myResult;
    private MultiMap<ExpandableIndent, AbstractBlockWrapper> myBlocksToForceChildrenIndent;
    private MultiMap<Alignment, Block> myBlocksToAlign;
    private Set<Alignment> myAlignmentsInsideRangeToModify;
    private boolean myCollectAlignmentsInsideFormattingRange;
    private final FormattingDocumentModel myModel;
    private final FormatTextRanges myAffectedRanges;
    private final List<TextRange> myExtendedAffectedRanges;
    private final int myPositionOfInterest;
    private final FormattingProgressCallback myProgressCallback;
    private final FormatterTagHandler myFormatterTagHandler;
    private final CommonCodeStyleSettings.IndentOptions myOptions;
    private final Stack<InitialInfoBuilderState> myStates;
    private WhiteSpace myCurrentWhiteSpace;
    private CompositeBlockWrapper myRootBlockWrapper;
    private LeafBlockWrapper myPreviousBlock;
    private LeafBlockWrapper myFirstTokenBlock;
    private LeafBlockWrapper myLastTokenBlock;
    private SpacingImpl myCurrentSpaceProperty;
    private boolean myInsideFormatRestrictingTag;

    private InitialInfoBuilder(Block rootBlock, FormattingDocumentModel model, @Nullable FormatTextRanges affectedRanges, @NotNull CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options, int positionOfInterest, @NotNull FormattingProgressCallback progressCallback) {
        if (settings == null) {
            InitialInfoBuilder.$$$reportNull$$$0(0);
        }
        if (progressCallback == null) {
            InitialInfoBuilder.$$$reportNull$$$0(1);
        }
        this.myResult = new THashMap();
        this.myBlocksToForceChildrenIndent = new LinkedMultiMap();
        this.myBlocksToAlign = new MultiMap();
        this.myAlignmentsInsideRangeToModify = ContainerUtil.newHashSet();
        this.myCollectAlignmentsInsideFormattingRange = false;
        this.myStates = new Stack();
        this.myModel = model;
        this.myAffectedRanges = affectedRanges;
        this.myExtendedAffectedRanges = affectedRanges != null ? affectedRanges.getExtendedFormattingRanges() : null;
        this.myProgressCallback = progressCallback;
        this.myCurrentWhiteSpace = new WhiteSpace(this.getStartOffset(rootBlock), true);
        this.myOptions = options;
        this.myPositionOfInterest = positionOfInterest;
        this.myInsideFormatRestrictingTag = false;
        this.myFormatterTagHandler = new FormatterTagHandler(settings);
    }

    protected static InitialInfoBuilder prepareToBuildBlocksSequentially(Block root, FormattingDocumentModel model, FormatProcessor.FormatOptions formatOptions, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options, @NotNull FormattingProgressCallback progressCallback) {
        if (progressCallback == null) {
            InitialInfoBuilder.$$$reportNull$$$0(2);
        }
        InitialInfoBuilder builder = new InitialInfoBuilder(root, model, formatOptions.myAffectedRanges, settings, options, formatOptions.myInterestingOffset, progressCallback);
        builder.setCollectAlignmentsInsideFormattingRange(formatOptions.myReformatContext);
        builder.buildFrom(root, 0, null, null, null);
        return builder;
    }

    private int getStartOffset(@NotNull Block rootBlock) {
        if (rootBlock == null) {
            InitialInfoBuilder.$$$reportNull$$$0(3);
        }
        int minOffset = rootBlock.getTextRange().getStartOffset();
        if (this.myAffectedRanges != null) {
            for (FormatTextRange range : this.myAffectedRanges.getRanges()) {
                if (range.getStartOffset() >= minOffset) continue;
                minOffset = range.getStartOffset();
            }
        }
        return minOffset;
    }

    public FormattingDocumentModel getFormattingDocumentModel() {
        return this.myModel;
    }

    public int getEndOffset() {
        int maxOffset;
        int maxDocOffset = this.myModel.getTextLength();
        int n = maxOffset = this.myRootBlockWrapper != null ? this.myRootBlockWrapper.getEndOffset() : 0;
        if (this.myAffectedRanges != null) {
            for (FormatTextRange range : this.myAffectedRanges.getRanges()) {
                if (range.getTextRange().getEndOffset() <= maxOffset) continue;
                maxOffset = range.getTextRange().getEndOffset();
            }
        }
        return maxOffset < maxDocOffset ? maxOffset : maxDocOffset;
    }

    public boolean iteration() {
        if (this.myStates.isEmpty()) {
            return true;
        }
        InitialInfoBuilderState state2 = (InitialInfoBuilderState)this.myStates.peek();
        this.doIteration(state2);
        return this.myStates.isEmpty();
    }

    private AbstractBlockWrapper buildFrom(Block rootBlock, int index, @Nullable CompositeBlockWrapper parent, @Nullable WrapImpl currentWrapParent, @Nullable Block parentBlock) {
        WrapImpl wrap = (WrapImpl)rootBlock.getWrap();
        if (wrap != null) {
            wrap.registerParent(currentWrapParent);
            currentWrapParent = wrap;
        }
        TextRange textRange = rootBlock.getTextRange();
        int blockStartOffset = textRange.getStartOffset();
        if (parent != null) {
            this.checkRanges(parent, textRange);
        }
        this.myCurrentWhiteSpace.changeEndOffset(blockStartOffset, this.myModel, this.myOptions);
        this.collectAlignments(rootBlock);
        if (this.isInsideFormattingRanges(rootBlock) || this.shouldCollectAlignmentsAround(rootBlock)) {
            List subBlocks = rootBlock.getSubBlocks();
            if (subBlocks.isEmpty()) {
                AbstractBlockWrapper wrapper2 = this.buildLeafBlock(rootBlock, parent, false, index, parentBlock);
                if (!subBlocks.isEmpty()) {
                    wrapper2.setIndent((IndentImpl)((Block)subBlocks.get(0)).getIndent());
                }
                return wrapper2;
            }
            return this.buildCompositeBlock(rootBlock, parent, index, currentWrapParent);
        }
        return this.buildLeafBlock(rootBlock, parent, true, index, parentBlock);
    }

    private boolean shouldCollectAlignmentsAround(Block rootBlock) {
        return this.myCollectAlignmentsInsideFormattingRange && this.isInsideExtendedAffectedRange(rootBlock);
    }

    private void collectAlignments(Block rootBlock) {
        if (this.myCollectAlignmentsInsideFormattingRange && rootBlock.getAlignment() != null && this.isAffectedByFormatting(rootBlock) && !this.myInsideFormatRestrictingTag) {
            this.myAlignmentsInsideRangeToModify.add(rootBlock.getAlignment());
        }
        if (rootBlock.getAlignment() != null) {
            this.myBlocksToAlign.putValue((Object)rootBlock.getAlignment(), (Object)rootBlock);
        }
    }

    private void checkRanges(@NotNull CompositeBlockWrapper parent, TextRange textRange) {
        if (parent == null) {
            InitialInfoBuilder.$$$reportNull$$$0(4);
        }
        if (textRange.getStartOffset() < parent.getStartOffset()) {
            ASSERT.assertInvalidRanges(textRange.getStartOffset(), parent.getStartOffset(), this.myModel, "child block start is less than parent block start");
        }
        if (textRange.getEndOffset() > parent.getEndOffset()) {
            ASSERT.assertInvalidRanges(textRange.getEndOffset(), parent.getEndOffset(), this.myModel, "child block end is after parent block end");
        }
    }

    private boolean isInsideExtendedAffectedRange(Block rootBlock) {
        if (this.myExtendedAffectedRanges == null) {
            return false;
        }
        TextRange blockRange = rootBlock.getTextRange();
        for (TextRange affectedRange : this.myExtendedAffectedRanges) {
            if (!affectedRange.intersects(blockRange)) continue;
            return true;
        }
        return false;
    }

    private CompositeBlockWrapper buildCompositeBlock(Block rootBlock, @Nullable CompositeBlockWrapper parent, int index, @Nullable WrapImpl currentWrapParent) {
        CompositeBlockWrapper wrappedRootBlock = new CompositeBlockWrapper(rootBlock, this.myCurrentWhiteSpace, parent);
        if (index == 0) {
            wrappedRootBlock.arrangeParentTextRange();
        }
        if (this.myRootBlockWrapper == null) {
            this.myRootBlockWrapper = wrappedRootBlock;
            this.myRootBlockWrapper.setIndent((IndentImpl)Indent.getNoneIndent());
        }
        boolean blocksMayBeOfInterest = false;
        if (this.myPositionOfInterest != -1) {
            this.myResult.put(wrappedRootBlock, rootBlock);
            blocksMayBeOfInterest = true;
        }
        boolean blocksAreReadOnly = rootBlock instanceof ReadOnlyBlockContainer || blocksMayBeOfInterest;
        InitialInfoBuilderState state2 = new InitialInfoBuilderState(rootBlock, wrappedRootBlock, currentWrapParent, blocksAreReadOnly);
        this.myStates.push((Object)state2);
        return wrappedRootBlock;
    }

    private void doIteration(@NotNull InitialInfoBuilderState state2) {
        if (state2 == null) {
            InitialInfoBuilder.$$$reportNull$$$0(5);
        }
        Block currentRoot = state2.parentBlock;
        List subBlocks = currentRoot.getSubBlocks();
        int currentBlockIndex = state2.getIndexOfChildBlockToProcess();
        Block currentBlock = (Block)subBlocks.get(currentBlockIndex);
        this.initCurrentWhiteSpace(currentRoot, state2.previousBlock, currentBlock);
        AbstractBlockWrapper wrapper2 = this.buildFrom(currentBlock, currentBlockIndex, state2.wrappedBlock, state2.parentBlockWrap, currentRoot);
        this.registerExpandableIndents(currentBlock, wrapper2);
        if (wrapper2.getIndent() == null) {
            wrapper2.setIndent((IndentImpl)currentBlock.getIndent());
        }
        if (!state2.readOnly) {
            try {
                subBlocks.set(currentBlockIndex, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (state2.childBlockProcessed(currentBlock, wrapper2, this.myOptions)) {
            while (!this.myStates.isEmpty() && ((InitialInfoBuilderState)this.myStates.peek()).isProcessed()) {
                this.myStates.pop();
            }
        }
    }

    private void initCurrentWhiteSpace(@NotNull Block currentRoot, @Nullable Block previousBlock, @NotNull Block currentBlock) {
        if (currentRoot == null) {
            InitialInfoBuilder.$$$reportNull$$$0(6);
        }
        if (currentBlock == null) {
            InitialInfoBuilder.$$$reportNull$$$0(7);
        }
        if (previousBlock != null || this.myCurrentWhiteSpace != null && this.myCurrentWhiteSpace.isIsFirstWhiteSpace()) {
            this.myCurrentSpaceProperty = (SpacingImpl)currentRoot.getSpacing(previousBlock, currentBlock);
        }
    }

    private void registerExpandableIndents(@NotNull Block block, @NotNull AbstractBlockWrapper wrapper2) {
        if (block == null) {
            InitialInfoBuilder.$$$reportNull$$$0(8);
        }
        if (wrapper2 == null) {
            InitialInfoBuilder.$$$reportNull$$$0(9);
        }
        if (block.getIndent() instanceof ExpandableIndent) {
            ExpandableIndent indent = (ExpandableIndent)block.getIndent();
            this.myBlocksToForceChildrenIndent.putValue((Object)indent, (Object)wrapper2);
        }
    }

    private AbstractBlockWrapper buildLeafBlock(Block rootBlock, @Nullable CompositeBlockWrapper parent, boolean readOnly, int index, @Nullable Block parentBlock) {
        LeafBlockWrapper result2 = this.doProcessSimpleBlock(rootBlock, parent, readOnly, index, parentBlock);
        this.myProgressCallback.afterWrappingBlock(result2);
        return result2;
    }

    private LeafBlockWrapper doProcessSimpleBlock(Block rootBlock, @Nullable CompositeBlockWrapper parent, boolean readOnly, int index, @Nullable Block parentBlock) {
        if (!INLINE_TABS_ENABLED && !this.myCurrentWhiteSpace.containsLineFeeds()) {
            this.myCurrentWhiteSpace.setForceSkipTabulationsUsage(true);
        }
        LeafBlockWrapper info = new LeafBlockWrapper(rootBlock, parent, this.myCurrentWhiteSpace, this.myModel, this.myOptions, this.myPreviousBlock, readOnly);
        if (index == 0) {
            info.arrangeParentTextRange();
        }
        this.checkInsideFormatterOffTag(rootBlock);
        TextRange textRange = rootBlock.getTextRange();
        if (this.myPreviousBlock != null) {
            this.myPreviousBlock.setNextBlock(info);
        }
        if (this.myFirstTokenBlock == null) {
            this.myFirstTokenBlock = info;
        }
        this.myLastTokenBlock = info;
        if (this.currentWhiteSpaceIsReadOnly()) {
            this.myCurrentWhiteSpace.setReadOnly(true);
        }
        if (this.myCurrentSpaceProperty != null) {
            this.myCurrentWhiteSpace.setIsSafe(this.myCurrentSpaceProperty.isSafe());
            this.myCurrentWhiteSpace.setKeepFirstColumn(this.myCurrentSpaceProperty.shouldKeepFirstColumn());
        }
        if (info.isEndOfCodeBlock()) {
            this.myCurrentWhiteSpace.setBeforeCodeBlockEnd(true);
        }
        info.setSpaceProperty(this.myCurrentSpaceProperty);
        this.myCurrentWhiteSpace = new WhiteSpace(textRange.getEndOffset(), false);
        if (this.myInsideFormatRestrictingTag) {
            this.myCurrentWhiteSpace.setReadOnly(true);
        }
        this.myPreviousBlock = info;
        if (this.myPositionOfInterest != -1 && (textRange.contains(this.myPositionOfInterest) || textRange.getEndOffset() == this.myPositionOfInterest)) {
            this.myResult.put(info, rootBlock);
            if (parent != null) {
                this.myResult.put(parent, parentBlock);
            }
        }
        return info;
    }

    private void checkInsideFormatterOffTag(Block rootBlock) {
        switch (this.myFormatterTagHandler.getFormatterTag(rootBlock)) {
            case ON: {
                this.myInsideFormatRestrictingTag = false;
                break;
            }
            case OFF: {
                this.myInsideFormatRestrictingTag = true;
                break;
            }
        }
    }

    private void checkRange(TextRange textRange) {
        if (textRange.getLength() == 0) {
            ASSERT.assertInvalidRanges(textRange.getStartOffset(), textRange.getEndOffset(), this.myModel, "empty block");
        }
    }

    private boolean currentWhiteSpaceIsReadOnly() {
        if (this.myCurrentSpaceProperty != null && this.myCurrentSpaceProperty.isReadOnly()) {
            return true;
        }
        if (this.myAffectedRanges == null) {
            return false;
        }
        return this.myAffectedRanges.isWhitespaceReadOnly(this.myCurrentWhiteSpace.getTextRange());
    }

    private boolean isAffectedByFormatting(Block block) {
        if (this.myAffectedRanges == null) {
            return true;
        }
        List<FormatTextRange> allRanges = this.myAffectedRanges.getRanges();
        Document document = this.myModel.getDocument();
        int docLength = document.getTextLength();
        for (FormatTextRange range : allRanges) {
            int startOffset = range.getStartOffset();
            if (startOffset >= docLength) continue;
            int lineNumber = document.getLineNumber(startOffset);
            int lineEndOffset = document.getLineEndOffset(lineNumber);
            int blockStartOffset = block.getTextRange().getStartOffset();
            if (blockStartOffset < startOffset || blockStartOffset >= lineEndOffset) continue;
            return true;
        }
        return false;
    }

    private boolean isInsideFormattingRanges(Block block) {
        if (this.myAffectedRanges == null) {
            return true;
        }
        return !this.myAffectedRanges.isReadOnly(block.getTextRange());
    }

    public Map<AbstractBlockWrapper, Block> getBlockToInfoMap() {
        return this.myResult;
    }

    public LeafBlockWrapper getFirstTokenBlock() {
        return this.myFirstTokenBlock;
    }

    public LeafBlockWrapper getLastTokenBlock() {
        return this.myLastTokenBlock;
    }

    public Set<Alignment> getAlignmentsInsideRangeToModify() {
        return this.myAlignmentsInsideRangeToModify;
    }

    public MultiMap<ExpandableIndent, AbstractBlockWrapper> getExpandableIndentsBlocks() {
        return this.myBlocksToForceChildrenIndent;
    }

    public MultiMap<Alignment, Block> getBlocksToAlign() {
        return this.myBlocksToAlign;
    }

    public void setCollectAlignmentsInsideFormattingRange(boolean value) {
        this.myCollectAlignmentsInsideFormattingRange = value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressCallback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootBlock";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRoot";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBlock";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/InitialInfoBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareToBuildBlocksSequentially";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getStartOffset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRanges";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doIteration";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "initCurrentWhiteSpace";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "registerExpandableIndents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

