/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class NamedLibraryElementNode
extends ProjectViewNode<NamedLibraryElement>
implements NavigatableWithText {
    public NamedLibraryElementNode(Project project, NamedLibraryElement value, ViewSettings viewSettings) {
        super(project, (Object)value, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        ArrayList<AbstractTreeNode> children2 = new ArrayList<AbstractTreeNode>();
        NamedLibraryElement libraryElement = (NamedLibraryElement)this.getValue();
        if (libraryElement != null) {
            LibraryGroupNode.addLibraryChildren(libraryElement.getOrderEntry(), children2, this.getProject(), this);
        }
        ArrayList<AbstractTreeNode> arrayList = children2;
        if (arrayList == null) {
            NamedLibraryElementNode.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static Icon getJdkIcon(JdkOrderEntry entry) {
        Sdk sdk = entry.getJdk();
        if (sdk == null) {
            return AllIcons.Nodes.UnknownJdk;
        }
        SdkType sdkType = (SdkType)sdk.getSdkType();
        return sdkType.getIcon();
    }

    public String getName() {
        NamedLibraryElement library = (NamedLibraryElement)this.getValue();
        return library != null ? library.getName() : "";
    }

    public boolean contains(@NotNull VirtualFile file2) {
        NamedLibraryElement library;
        if (file2 == null) {
            NamedLibraryElementNode.$$$reportNull$$$0(1);
        }
        if ((library = (NamedLibraryElement)this.getValue()) == null) {
            return false;
        }
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            LibraryOrSdkOrderEntry orderEntry = library.getOrderEntry();
            if (!orderEntry.isValid()) continue;
            for (VirtualFile virtualFile : orderEntry.getRootFiles(rootType)) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file2, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public void update(PresentationData presentation) {
        NamedLibraryElement library = (NamedLibraryElement)this.getValue();
        if (library == null) {
            return;
        }
        LibraryOrSdkOrderEntry orderEntry = library.getOrderEntry();
        presentation.setPresentableText(library.getName());
        Icon closedIcon = orderEntry instanceof JdkOrderEntry ? NamedLibraryElementNode.getJdkIcon((JdkOrderEntry)orderEntry) : AllIcons.Nodes.PpLibFolder;
        presentation.setIcon(closedIcon);
        if (orderEntry instanceof JdkOrderEntry) {
            String path;
            JdkOrderEntry jdkOrderEntry = (JdkOrderEntry)orderEntry;
            Sdk projectJdk = jdkOrderEntry.getJdk();
            if (projectJdk != null && (path = projectJdk.getHomePath()) != null) {
                presentation.setLocationString(projectJdk.getSdkType().isLocalSdk(projectJdk) ? FileUtil.toSystemDependentName((String)path) : FileUtil.toSystemIndependentName((String)path));
            }
            presentation.setTooltip(null);
        } else {
            presentation.setTooltip(StringUtil.capitalize((String)IdeBundle.message((String)"node.projectview.library", (Object[])new Object[]{((LibraryOrderEntry)orderEntry).getLibraryLevel()})));
        }
    }

    public void navigate(boolean requestFocus) {
        NamedLibraryElement library = (NamedLibraryElement)this.getValue();
        if (library != null) {
            ProjectSettingsService.getInstance(this.myProject).openLibraryOrSdkSettings((OrderEntry)library.getOrderEntry());
        }
    }

    public boolean canNavigate() {
        NamedLibraryElement library = (NamedLibraryElement)this.getValue();
        return library != null && ProjectSettingsService.getInstance(this.myProject).canOpenLibraryOrSdkSettings((OrderEntry)library.getOrderEntry());
    }

    public String getNavigateActionText(boolean focusEditor) {
        return ActionsBundle.message((String)"action.LibrarySettings.navigate", (Object[])new Object[0]);
    }

    public String getTestPresentation() {
        NamedLibraryElement library = (NamedLibraryElement)this.getValue();
        return "Library: " + (library != null ? library.getName() : "(null)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/NamedLibraryElementNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/NamedLibraryElementNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

