/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.ApplicationInfoProvider;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.ExceptionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.apache.log4j.DefaultThrowableRenderer;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.ThrowableRenderer;
import org.apache.log4j.spi.ThrowableRendererSupport;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaLogger
extends Log4jBasedLogger {
    private static ApplicationInfoProvider ourApplicationInfoProvider = IdeaLogger.getIdeaInfoProvider();
    public static String ourLastActionId = "";
    public static Exception ourErrorsOccurred;
    private static final String ourCompilationTimestamp;
    @NonNls
    private static final String COMPILATION_TIMESTAMP_RESOURCE_NAME = "/.compilation-timestamp";
    private static final ThrowableRenderer ourThrowableRenderer;

    public static String getOurCompilationTimestamp() {
        return ourCompilationTimestamp;
    }

    IdeaLogger(@NotNull Logger logger) {
        if (logger == null) {
            IdeaLogger.$$$reportNull$$$0(0);
        }
        super(logger);
        LoggerRepository repository = this.myLogger.getLoggerRepository();
        if (repository instanceof ThrowableRendererSupport) {
            ((ThrowableRendererSupport)repository).setThrowableRenderer(ourThrowableRenderer);
        }
    }

    public void error(Object message) {
        if (message instanceof IdeaLoggingEvent) {
            this.myLogger.error(message);
        } else {
            super.error(message);
        }
    }

    public void error(@NonNls String message, Attachment ... attachments) {
        if (attachments == null) {
            IdeaLogger.$$$reportNull$$$0(1);
        }
        this.myLogger.error((Object)LogMessageEx.createEvent(message, DebugUtil.currentStackTrace(), attachments));
    }

    public void error(String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            IdeaLogger.$$$reportNull$$$0(2);
        }
        if (t instanceof ControlFlowException) {
            this.myLogger.error((Object)message, new Throwable("Control-flow exceptions (like " + t.getClass().getSimpleName() + ") should never be logged", t));
            ExceptionUtil.rethrow((Throwable)t);
        }
        String detailString = StringUtil.join((String[])details, (String)"\n");
        if (ourErrorsOccurred == null) {
            String s = message != null && !message.isEmpty() ? "Error message is '" + message + "'" : "";
            String mess = "Logger errors occurred. See IDEA logs for details. " + s;
            ourErrorsOccurred = new Exception(mess + (!detailString.isEmpty() ? "\nDetails: " + detailString : ""), t);
        }
        this.myLogger.error((Object)(message + (!detailString.isEmpty() ? "\nDetails: " + detailString : "")), t);
        this.logErrorHeader();
    }

    private void logErrorHeader() {
        String info = ourApplicationInfoProvider.getInfo();
        if (info != null) {
            this.myLogger.error((Object)info);
        }
        if (ourCompilationTimestamp != null) {
            this.myLogger.error((Object)("Internal version. Compiled " + ourCompilationTimestamp));
        }
        this.myLogger.error((Object)("JDK: " + System.getProperties().getProperty("java.version", "unknown")));
        this.myLogger.error((Object)("VM: " + System.getProperties().getProperty("java.vm.name", "unknown")));
        this.myLogger.error((Object)("Vendor: " + System.getProperties().getProperty("java.vendor", "unknown")));
        this.myLogger.error((Object)("OS: " + System.getProperties().getProperty("os.name", "unknown")));
        ApplicationImpl application = (ApplicationImpl)ApplicationManager.getApplication();
        if (application != null && application.isComponentsCreated() && !application.isDisposed()) {
            String currentCommandName;
            CommandProcessor commandProcessor;
            String lastPreformedActionId = ourLastActionId;
            if (lastPreformedActionId != null) {
                this.myLogger.error((Object)("Last Action: " + lastPreformedActionId));
            }
            if ((commandProcessor = CommandProcessor.getInstance()) != null && (currentCommandName = commandProcessor.getCurrentCommandName()) != null) {
                this.myLogger.error((Object)("Current Command: " + currentCommandName));
            }
        }
    }

    @NotNull
    public static ThrowableRenderer getThrowableRenderer() {
        ThrowableRenderer throwableRenderer = ourThrowableRenderer;
        if (throwableRenderer == null) {
            IdeaLogger.$$$reportNull$$$0(3);
        }
        return throwableRenderer;
    }

    public static void setApplicationInfoProvider(@NotNull ApplicationInfoProvider aProvider) {
        if (aProvider == null) {
            IdeaLogger.$$$reportNull$$$0(4);
        }
        ourApplicationInfoProvider = aProvider;
    }

    @NotNull
    private static ApplicationInfoProvider getIdeaInfoProvider() {
        ApplicationInfoProvider applicationInfoProvider = () -> {
            ApplicationInfoEx info = ApplicationInfoImpl.getShadowInstance();
            return info.getFullApplicationName() + "  Build #" + info.getBuild().asString();
        };
        if (applicationInfoProvider == null) {
            IdeaLogger.$$$reportNull$$$0(5);
        }
        return applicationInfoProvider;
    }

    static {
        ourThrowableRenderer = t -> {
            int maxExtraSize;
            int maxStackSize;
            String[] defaultRes = DefaultThrowableRenderer.render((Throwable)t);
            if (defaultRes.length > (maxStackSize = 1024) + (maxExtraSize = 256)) {
                String[] res = new String[maxStackSize + maxExtraSize + 1];
                System.arraycopy(defaultRes, 0, res, 0, maxStackSize);
                res[maxStackSize] = "\t...";
                System.arraycopy(defaultRes, defaultRes.length - maxExtraSize, res, maxStackSize + 1, maxExtraSize);
                return res;
            }
            return defaultRes;
        };
        InputStream stream = com.intellij.openapi.diagnostic.Logger.class.getResourceAsStream(COMPILATION_TIMESTAMP_RESOURCE_NAME);
        String stamp = null;
        if (stream != null) {
            try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(stream));){
                String s = reader.readLine();
                if (s != null) {
                    stamp = s.trim();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ourCompilationTimestamp = stamp;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/IdeaLogger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/IdeaLogger";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeaInfoProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setApplicationInfoProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

