/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;

public class DefaultRemoteContentProvider
extends RemoteContentProvider {
    private static final Logger LOG = Logger.getInstance(DefaultRemoteContentProvider.class);

    @NotNull
    public static RequestBuilder addRequestTuner(@NotNull Url url, @NotNull RequestBuilder requestBuilder) {
        BuiltInServerManager builtInServerManager;
        if (url == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(0);
        }
        if (requestBuilder == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(1);
        }
        if ((builtInServerManager = BuiltInServerManager.getInstance()).isOnBuiltInWebServer(url)) {
            requestBuilder.tuner(arg_0 -> ((BuiltInServerManager)builtInServerManager).configureRequestToWebServer(arg_0));
        }
        RequestBuilder requestBuilder2 = requestBuilder;
        if (requestBuilder2 == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(2);
        }
        return requestBuilder2;
    }

    @Override
    public boolean canProvideContent(@NotNull Url url) {
        if (url == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Override
    public void saveContent(@NotNull Url url, @NotNull File file2, @NotNull RemoteContentProvider.DownloadingCallback callback) {
        if (url == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (url == null) {
                DefaultRemoteContentProvider.$$$reportNull$$$0(10);
            }
            if (file2 == null) {
                DefaultRemoteContentProvider.$$$reportNull$$$0(11);
            }
            if (callback == null) {
                DefaultRemoteContentProvider.$$$reportNull$$$0(12);
            }
            DefaultRemoteContentProvider.downloadContent(url, file2, callback);
        });
    }

    private static void downloadContent(final @NotNull Url url, final File file2, final RemoteContentProvider.DownloadingCallback callback) {
        if (url == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(7);
        }
        LOG.debug("Downloading started: " + url);
        final String presentableUrl = StringUtil.trimMiddle((String)url.trimParameters().toDecodedForm(), (int)40);
        callback.setProgressText(VfsBundle.message((String)"download.progress.connecting", (Object[])new Object[]{presentableUrl}), true);
        try {
            DefaultRemoteContentProvider.addRequestTuner(url, HttpRequests.request((String)url.toExternalForm())).connectTimeout(60000).productNameAsUserAgent().connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Object>(){

                public Object process(@NotNull HttpRequests.Request request) throws IOException {
                    FileType fileTypeByFileName;
                    if (request == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    int size = request.getConnection().getContentLength();
                    callback.setProgressText(VfsBundle.message((String)"download.progress.downloading", (Object[])new Object[]{presentableUrl}), size == -1);
                    request.saveToFile(file2, (ProgressIndicator)new AbstractProgressIndicatorExBase(){

                        @Override
                        public void setFraction(double fraction) {
                            callback.setProgressFraction(0.0);
                        }
                    });
                    FileType fileType = RemoteFileUtil.getFileType(request.getConnection().getContentType());
                    if (fileType == FileTypes.PLAIN_TEXT && (fileTypeByFileName = FileTypeRegistry.getInstance().getFileTypeByFileName(PathUtilRt.getFileName((String)url.getPath()))) != FileTypes.UNKNOWN) {
                        fileType = fileTypeByFileName;
                    }
                    LOG.debug("Downloading finished, " + size + " bytes downloaded");
                    callback.finished(fileType);
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider$1", "process"));
                }
            });
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            callback.errorOccurred(VfsBundle.message((String)"cannot.load.remote.file", (Object[])new Object[]{url, e.getMessage()}), false);
        }
    }

    @Override
    public boolean isUpToDate(@NotNull Url url, @NotNull VirtualFile local) {
        if (url == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(8);
        }
        if (local == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(9);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addRequestTuner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addRequestTuner";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canProvideContent";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveContent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "downloadContent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$saveContent$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

