/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.library;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Disposer;
import com.intellij.project.model.impl.library.JpsLibraryDelegate;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;

public class JpsLibraryTableImpl
implements LibraryTable,
Disposable {
    private final JpsLibrariesModel myModel;
    private final EventDispatcher<LibraryTable.Listener> myDispatcher = EventDispatcher.create(LibraryTable.Listener.class);
    private final String myTableLevel;
    private LibraryTablePresentation myPresentation;

    public JpsLibraryTableImpl(JpsLibraryCollection libraryCollection, String level) {
        this.myTableLevel = level;
        this.myModel = new JpsLibrariesModel(libraryCollection);
    }

    @NotNull
    public Library[] getLibraries() {
        Library[] libraryArray = this.myModel.getLibraries();
        if (libraryArray == null) {
            JpsLibraryTableImpl.$$$reportNull$$$0(0);
        }
        return libraryArray;
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        Iterator<Library> iterator = this.myModel.getLibraryIterator();
        if (iterator == null) {
            JpsLibraryTableImpl.$$$reportNull$$$0(1);
        }
        return iterator;
    }

    public Library getLibraryByName(@NotNull String name) {
        if (name == null) {
            JpsLibraryTableImpl.$$$reportNull$$$0(2);
        }
        return this.myModel.getLibraryByName(name);
    }

    public void addListener(@NotNull LibraryTable.Listener listener2) {
        if (listener2 == null) {
            JpsLibraryTableImpl.$$$reportNull$$$0(3);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void addListener(@NotNull LibraryTable.Listener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            JpsLibraryTableImpl.$$$reportNull$$$0(4);
        }
        if (parentDisposable == null) {
            JpsLibraryTableImpl.$$$reportNull$$$0(5);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeListener(@NotNull LibraryTable.Listener listener2) {
        if (listener2 == null) {
            JpsLibraryTableImpl.$$$reportNull$$$0(6);
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    @NotNull
    public Library createLibrary() {
        Library library = this.createLibrary(null);
        if (library == null) {
            JpsLibraryTableImpl.$$$reportNull$$$0(7);
        }
        return library;
    }

    @NotNull
    public Library createLibrary(@NonNls String name) {
        LibraryTable.ModifiableModel model = this.getModifiableModel();
        Library library = model.createLibrary(name);
        model.commit();
        Library library2 = library;
        if (library2 == null) {
            JpsLibraryTableImpl.$$$reportNull$$$0(8);
        }
        return library2;
    }

    public void removeLibrary(@NotNull Library library) {
        if (library == null) {
            JpsLibraryTableImpl.$$$reportNull$$$0(9);
        }
        LibraryTable.ModifiableModel model = this.getModifiableModel();
        model.removeLibrary(library);
        model.commit();
    }

    public void dispose() {
        for (Library library : this.getLibraries()) {
            Disposer.dispose((Disposable)library);
        }
    }

    @NotNull
    public LibraryTable.ModifiableModel getModifiableModel() {
        JpsLibrariesModel jpsLibrariesModel = new JpsLibrariesModel(this.myModel.myJpsLibraries);
        if (jpsLibrariesModel == null) {
            JpsLibraryTableImpl.$$$reportNull$$$0(10);
        }
        return jpsLibrariesModel;
    }

    @NotNull
    public String getTableLevel() {
        String string = this.myTableLevel;
        if (string == null) {
            JpsLibraryTableImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public LibraryTablePresentation getPresentation() {
        LibraryTablePresentation libraryTablePresentation = this.myPresentation;
        if (libraryTablePresentation == null) {
            JpsLibraryTableImpl.$$$reportNull$$$0(12);
        }
        return libraryTablePresentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/project/model/impl/library/JpsLibraryTableImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryIterator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/project/model/impl/library/JpsLibraryTableImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableLevel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryByName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class JpsLibrariesModel
    implements LibraryTable.ModifiableModel {
        private final JpsLibraryCollection myJpsLibraries;
        private final List<JpsLibraryDelegate> myLibraries = new ArrayList<JpsLibraryDelegate>();

        private JpsLibrariesModel(JpsLibraryCollection libraryCollection) {
            this.myJpsLibraries = libraryCollection;
            for (JpsLibrary library : libraryCollection.getLibraries()) {
                this.myLibraries.add(new JpsLibraryDelegate(library, JpsLibraryTableImpl.this));
            }
        }

        @NotNull
        public Library createLibrary(String name) {
            Library library = this.createLibrary(name, null);
            if (library == null) {
                JpsLibrariesModel.$$$reportNull$$$0(0);
            }
            return library;
        }

        @NotNull
        public Library createLibrary(String name, @Nullable PersistentLibraryKind type) {
            Library library = this.createLibrary(name, type, null);
            if (library == null) {
                JpsLibrariesModel.$$$reportNull$$$0(1);
            }
            return library;
        }

        @NotNull
        public Library createLibrary(String name, @Nullable PersistentLibraryKind type, @Nullable ProjectModelExternalSource externalSource) {
            throw new UnsupportedOperationException("'createLibrary' not implemented in " + this.getClass().getName());
        }

        @NotNull
        public Iterator<Library> getLibraryIterator() {
            Iterator<JpsLibraryDelegate> iterator = Collections.unmodifiableList(this.myLibraries).iterator();
            if (iterator == null) {
                JpsLibrariesModel.$$$reportNull$$$0(2);
            }
            return iterator;
        }

        public void removeLibrary(@NotNull Library library) {
            if (library == null) {
                JpsLibrariesModel.$$$reportNull$$$0(3);
            }
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Library[] getLibraries() {
            Library[] libraryArray = this.myLibraries.toArray(new Library[this.myLibraries.size()]);
            if (libraryArray == null) {
                JpsLibrariesModel.$$$reportNull$$$0(4);
            }
            return libraryArray;
        }

        public Library getLibraryByName(@NotNull String name) {
            if (name == null) {
                JpsLibrariesModel.$$$reportNull$$$0(5);
            }
            for (JpsLibraryDelegate library : this.myLibraries) {
                if (!name.equals(library.getName())) continue;
                return library;
            }
            return null;
        }

        public void commit() {
            throw new UnsupportedOperationException();
        }

        public void dispose() {
        }

        public boolean isChanged() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/project/model/impl/library/JpsLibraryTableImpl$JpsLibrariesModel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLibrary";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryIterator";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/project/model/impl/library/JpsLibraryTableImpl$JpsLibrariesModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraries";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeLibrary";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryByName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

