/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.xml.XmlElementChangeUtil;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEnumeratedType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeDeclImpl
extends XmlElementImpl
implements XmlAttributeDecl,
XmlElementType {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.XmlAttributeDeclImpl");
    @NonNls
    private static final String ID_ATT = "ID";
    @NonNls
    private static final String IDREF_ATT = "IDREF";

    public XmlAttributeDeclImpl() {
        super(XML_ATTRIBUTE_DECL);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == XML_NAME) {
            return 229;
        }
        if (i == XML_ATT_REQUIRED) {
            return 234;
        }
        if (i == XML_ATT_FIXED) {
            return 236;
        }
        if (i == XML_ATT_IMPLIED) {
            return 235;
        }
        if (i == XML_ATTRIBUTE_VALUE) {
            return 237;
        }
        if (i == XML_ENUMERATED_TYPE) {
            return 238;
        }
        return 0;
    }

    public XmlElement getNameElement() {
        return this.findElementByTokenType(XML_NAME);
    }

    public boolean isAttributeRequired() {
        return this.findElementByTokenType(XML_ATT_REQUIRED) != null;
    }

    public boolean isAttributeFixed() {
        return this.findElementByTokenType(XML_ATT_FIXED) != null;
    }

    public boolean isAttributeImplied() {
        return this.findElementByTokenType(XML_ATT_IMPLIED) != null;
    }

    public XmlAttributeValue getDefaultValue() {
        return (XmlAttributeValue)this.findElementByTokenType(XML_ATTRIBUTE_VALUE);
    }

    public String getDefaultValueText() {
        XmlAttributeValue value = this.getDefaultValue();
        if (value == null) {
            return null;
        }
        String text = value.getText();
        if (text.indexOf(37) == -1 && text.indexOf(38) == -1) {
            return text;
        }
        final StringBuilder builder = new StringBuilder();
        value.processElements(new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                builder.append(element.getText());
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/xml/XmlAttributeDeclImpl$1", "execute"));
            }
        }, null);
        return builder.toString();
    }

    public boolean isEnumerated() {
        return this.findElementByTokenType(XML_ENUMERATED_TYPE) != null;
    }

    public XmlElement[] getEnumeratedValues() {
        XmlEnumeratedType enumeratedType = (XmlEnumeratedType)this.findElementByTokenType(XML_ENUMERATED_TYPE);
        if (enumeratedType != null) {
            return enumeratedType.getEnumeratedValues();
        }
        return XmlElement.EMPTY_ARRAY;
    }

    public boolean isIdAttribute() {
        PsiElement elementType = this.findElementType();
        return elementType != null && elementType.getText().equals(ID_ATT);
    }

    private PsiElement findElementType() {
        XmlElement elementName = this.findElementByTokenType(XML_NAME);
        PsiElement nextSibling = elementName != null ? elementName.getNextSibling() : null;
        PsiElement elementType = nextSibling instanceof PsiWhiteSpace ? nextSibling.getNextSibling() : nextSibling;
        return elementType;
    }

    public boolean isIdRefAttribute() {
        PsiElement elementType = this.findElementType();
        return elementType != null && elementType.getText().equals(IDREF_ATT);
    }

    public PsiMetaData getMetaData() {
        return MetaRegistry.getMeta(this);
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            XmlAttributeDeclImpl.$$$reportNull$$$0(0);
        }
        XmlElementChangeUtil.doNameReplacement((PsiNamedElement)this, this.getNameElement(), name);
        return null;
    }

    @Override
    public String getName() {
        XmlElement name = this.getNameElement();
        return name != null ? name.getText() : null;
    }

    @Override
    public boolean canNavigate() {
        if (this.isPhysical()) {
            return super.canNavigate();
        }
        PsiNamedElement psiNamedElement = XmlUtil.findRealNamedElement((PsiNamedElement)this);
        return psiNamedElement != null && psiNamedElement != this && ((Navigatable)psiNamedElement).canNavigate();
    }

    @Override
    public void navigate(boolean requestFocus) {
        if (this.isPhysical()) {
            super.navigate(requestFocus);
            return;
        }
        PsiNamedElement psiNamedElement = XmlUtil.findRealNamedElement((PsiNamedElement)this);
        Navigatable navigatable = PsiNavigationSupport.getInstance().getDescriptor((PsiElement)psiNamedElement);
        if (psiNamedElement instanceof XmlEntityDecl) {
            navigatable = PsiNavigationSupport.getInstance().createNavigatable(psiNamedElement.getProject(), psiNamedElement.getContainingFile().getVirtualFile(), psiNamedElement.getTextRange().getStartOffset() + psiNamedElement.getText().indexOf(this.getName()));
        }
        if (navigatable != null) {
            navigatable.navigate(requestFocus);
        }
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        XmlAttributeDeclImpl xmlAttributeDeclImpl = this;
        if (xmlAttributeDeclImpl == null) {
            XmlAttributeDeclImpl.$$$reportNull$$$0(1);
        }
        return xmlAttributeDeclImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlAttributeDeclImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlAttributeDeclImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

