/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.ui.popup.HeavyWeightPopupCache;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.HierarchyListener;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class MovablePopup {
    private final HierarchyListener myListener;
    private final Component myOwner;
    private final Component myContent;
    private Rectangle myViewBounds;
    private Container myView;
    private boolean myAlwaysOnTop;
    private boolean myHeavyWeight;
    private boolean myWindowFocusable;
    private boolean myWindowShadow;

    public MovablePopup(@NotNull Component owner, @NotNull Component content) {
        if (owner == null) {
            MovablePopup.$$$reportNull$$$0(0);
        }
        if (content == null) {
            MovablePopup.$$$reportNull$$$0(1);
        }
        this.myListener = event -> this.setVisible(false);
        this.myOwner = owner;
        this.myContent = content;
        this.myViewBounds = new Rectangle(content.getPreferredSize());
        this.myHeavyWeight = true;
    }

    public void setAlwaysOnTop(boolean value) {
        if (this.myAlwaysOnTop != value) {
            this.myAlwaysOnTop = value;
            this.disposeAndUpdate(true);
        }
    }

    private static void setAlwaysOnTop(@NotNull Window window, boolean value) {
        if (window == null) {
            MovablePopup.$$$reportNull$$$0(2);
        }
        if (value != window.isAlwaysOnTop()) {
            try {
                window.setAlwaysOnTop(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setHeavyWeight(boolean value) {
        if (this.myHeavyWeight != value) {
            this.myHeavyWeight = value;
            this.disposeAndUpdate(true);
        }
    }

    public void setWindowFocusable(boolean value) {
        if (this.myWindowFocusable != value) {
            this.myWindowFocusable = value;
            this.disposeAndUpdate(true);
        }
    }

    private static void setWindowFocusable(@NotNull Window window, boolean value) {
        if (window == null) {
            MovablePopup.$$$reportNull$$$0(3);
        }
        if (value != window.getFocusableWindowState()) {
            window.setFocusableWindowState(value);
        }
    }

    public void setWindowShadow(boolean value) {
        if (this.myWindowShadow != value) {
            this.myWindowShadow = value;
            this.disposeAndUpdate(true);
        }
    }

    private static void setWindowShadow(@NotNull Window window, boolean value) {
        JRootPane root;
        if (window == null) {
            MovablePopup.$$$reportNull$$$0(4);
        }
        if ((root = MovablePopup.getRootPane(window)) != null) {
            root.putClientProperty("Window.shadow", value);
        }
    }

    public void setBounds(@NotNull Rectangle bounds) {
        if (bounds == null) {
            MovablePopup.$$$reportNull$$$0(5);
        }
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this.myViewBounds != null) {
            this.myViewBounds.setBounds(x, y, width, height);
        } else {
            this.setBounds(new Point(x, y), new Dimension(width, height));
        }
    }

    public void setLocation(@NotNull Point location) {
        if (location == null) {
            MovablePopup.$$$reportNull$$$0(6);
        }
        this.setLocation(location.x, location.y);
    }

    public void setLocation(int x, int y) {
        if (this.myViewBounds != null) {
            this.myViewBounds.setLocation(x, y);
        } else {
            this.setBounds(new Point(x, y), null);
        }
    }

    public void setSize(@NotNull Dimension size) {
        if (size == null) {
            MovablePopup.$$$reportNull$$$0(7);
        }
        this.setSize(size.width, size.height);
    }

    public void setSize(int width, int height) {
        if (this.myViewBounds != null) {
            this.myViewBounds.setSize(width, height);
        } else {
            this.setBounds(null, new Dimension(width, height));
        }
    }

    public void setVisible(boolean visible) {
        if (!visible && this.myView != null) {
            this.disposeAndUpdate(false);
        } else if (visible && this.myView == null) {
            JLayeredPane parent;
            Window owner = UIUtil.getWindow((Component)this.myOwner);
            if (owner != null) {
                if (this.myHeavyWeight) {
                    Window view = HeavyWeightPopupCache.create(owner);
                    MovablePopup.setAlwaysOnTop(view, this.myAlwaysOnTop);
                    MovablePopup.setWindowFocusable(view, this.myWindowFocusable);
                    MovablePopup.setWindowShadow(view, this.myWindowShadow);
                    this.myView = view;
                } else if (owner instanceof RootPaneContainer && (parent = ((RootPaneContainer)((Object)owner)).getLayeredPane()) != null) {
                    JPanel view = new JPanel(new BorderLayout());
                    view.setVisible(false);
                    parent.add(view, JLayeredPane.POPUP_LAYER, 0);
                    this.myView = view;
                }
            }
            if (this.myView != null) {
                this.myView.add(this.myContent);
                Container container = parent = this.myView instanceof Window ? null : this.myView.getParent();
                if (parent != null) {
                    Point location = this.myViewBounds.getLocation();
                    SwingUtilities.convertPointFromScreen(location, parent);
                    this.myViewBounds.setLocation(location);
                }
                this.myView.setBackground(UIUtil.getLabelBackground());
                this.myView.setBounds(this.myViewBounds);
                this.myView.setVisible(true);
                this.myViewBounds = null;
                this.myOwner.addHierarchyListener(this.myListener);
            }
        }
    }

    public boolean isVisible() {
        return this.myView != null && this.myView.isVisible();
    }

    private void disposeAndUpdate(boolean update) {
        if (this.myView != null) {
            this.myOwner.removeHierarchyListener(this.myListener);
            boolean visible = this.myView.isVisible();
            this.myView.setVisible(false);
            Container container = this.myContent.getParent();
            if (container != null) {
                container.remove(this.myContent);
            }
            if (this.myView instanceof Window) {
                this.myViewBounds = this.myView.getBounds();
                HeavyWeightPopupCache.dispose((Window)this.myView);
            } else {
                Container parent = this.myView.getParent();
                if (parent == null) {
                    this.myViewBounds = new Rectangle(this.myContent.getPreferredSize());
                } else {
                    this.myViewBounds = new Rectangle(this.myView.getBounds());
                    parent.remove(this.myView);
                    Point point = new Point(this.myViewBounds.x, this.myViewBounds.y);
                    SwingUtilities.convertPointToScreen(point, parent);
                    this.myViewBounds.x = point.x;
                    this.myViewBounds.y = point.y;
                }
            }
            this.myView = null;
            if (update && visible) {
                this.setVisible(true);
            }
        }
    }

    private void setBounds(Point location, Dimension size) {
        if (this.myView != null) {
            if (size == null) {
                size = this.myView.getSize();
            }
            if (location == null) {
                location = this.myView.getLocation();
            } else {
                Container parent;
                Container container = parent = this.myView instanceof Window ? null : this.myView.getParent();
                if (parent != null) {
                    SwingUtilities.convertPointFromScreen(location, parent);
                }
            }
            this.myView.setBounds(location.x, location.y, size.width, size.height);
            if (this.myView.isVisible()) {
                this.myView.invalidate();
                this.myView.validate();
                this.myView.repaint();
            }
        }
    }

    private static JRootPane getRootPane(Window window) {
        if (window instanceof RootPaneContainer) {
            RootPaneContainer container = (RootPaneContainer)((Object)window);
            return container.getRootPane();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/popup/MovablePopup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setAlwaysOnTop";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setWindowFocusable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setWindowShadow";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setBounds";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setLocation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setSize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

