/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexScanRunnableCollector;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileBasedIndexProjectHandler
implements IndexableFileSet,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.FileBasedIndexProjectHandler");
    private final FileBasedIndex myIndex;
    private FileBasedIndexScanRunnableCollector myCollector;
    private static final int ourMinFilesToStartDumMode = Registry.intValue((String)"ide.dumb.mode.minFilesToStart", (int)20);
    private static final int ourMinFilesSizeToStartDumMode = Registry.intValue((String)"ide.dumb.mode.minFilesSizeToStart", (int)0x100000);

    public FileBasedIndexProjectHandler(final @NotNull Project project, FileBasedIndex index, FileBasedIndexScanRunnableCollector collector) {
        StartupManager startupManager;
        if (project == null) {
            FileBasedIndexProjectHandler.$$$reportNull$$$0(0);
        }
        this.myIndex = index;
        this.myCollector = collector;
        if (ApplicationManager.getApplication().isInternal()) {
            project.getMessageBus().connect((Disposable)this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void enteredDumbMode() {
                }

                public void exitDumbMode() {
                    LOG.info("Has changed files: " + (FileBasedIndexProjectHandler.createChangedFilesIndexingTask(project) != null) + "; project=" + project);
                }
            });
        }
        if ((startupManager = StartupManager.getInstance((Project)project)) != null) {
            startupManager.registerPreStartupActivity(() -> {
                if (project == null) {
                    FileBasedIndexProjectHandler.$$$reportNull$$$0(4);
                }
                PushedFilePropertiesUpdater.getInstance((Project)project).initializeProperties();
                TransactionGuard.submitTransaction((Disposable)project, () -> {
                    if (project == null) {
                        FileBasedIndexProjectHandler.$$$reportNull$$$0(5);
                    }
                    if (FileBasedIndex.getInstance() instanceof FileBasedIndexImpl) {
                        DumbService.getInstance((Project)project).queueTask((DumbModeTask)new UnindexedFilesUpdater(project));
                    }
                });
                this.myIndex.registerIndexableSet((IndexableFileSet)this, project);
                project.getMessageBus().connect((Disposable)this).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){
                    private boolean removed;

                    public void projectClosing(Project eventProject) {
                        if (eventProject == project && !this.removed) {
                            this.removed = true;
                            FileBasedIndexProjectHandler.this.myIndex.removeIndexableSet((IndexableFileSet)FileBasedIndexProjectHandler.this);
                        }
                    }
                });
            });
        }
    }

    public boolean isInSet(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexProjectHandler.$$$reportNull$$$0(1);
        }
        return this.myCollector.shouldCollect(file2);
    }

    public void iterateIndexableFilesIn(@NotNull VirtualFile file2, final @NotNull ContentIterator iterator) {
        if (file2 == null) {
            FileBasedIndexProjectHandler.$$$reportNull$$$0(2);
        }
        if (iterator == null) {
            FileBasedIndexProjectHandler.$$$reportNull$$$0(3);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!FileBasedIndexProjectHandler.this.isInSet(file2)) {
                    return false;
                }
                iterator.processFile(file2);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexProjectHandler$3", "visitFile"));
            }
        });
    }

    public void dispose() {
        this.myIndex.removeIndexableSet((IndexableFileSet)this);
    }

    @Nullable
    public static DumbModeTask createChangedFilesIndexingTask(final Project project) {
        FileBasedIndex i = FileBasedIndex.getInstance();
        if (!(i instanceof FileBasedIndexImpl)) {
            return null;
        }
        final FileBasedIndexImpl index = (FileBasedIndexImpl)i;
        if (index.getChangedFileCount() < ourMinFilesToStartDumMode && index.getChangedFilesSize() < (long)ourMinFilesSizeToStartDumMode) {
            return null;
        }
        return new DumbModeTask(project.getComponent(FileBasedIndexProjectHandler.class)){

            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                long start = System.currentTimeMillis();
                Collection<VirtualFile> files = index.getFilesToUpdate(project);
                long calcDuration = System.currentTimeMillis() - start;
                indicator.setIndeterminate(false);
                indicator.setText(IdeBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]));
                LOG.info("Reindexing refreshed files: " + files.size() + " to update, calculated in " + calcDuration + "ms");
                if (!files.isEmpty()) {
                    PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
                    FileBasedIndexProjectHandler.reindexRefreshedFiles(indicator, files, project, index);
                    snapshot.logResponsivenessSinceCreation("Reindexing refreshed files");
                }
            }

            public String toString() {
                return ((Object)((Object)this)).getClass().getName() + "[" + index.dumpSomeChangedFiles() + "]";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/indexing/FileBasedIndexProjectHandler$4", "performInDumbMode"));
            }
        };
    }

    private static void reindexRefreshedFiles(ProgressIndicator indicator, Collection<VirtualFile> files, Project project, FileBasedIndexImpl index) {
        CacheUpdateRunner.processFiles(indicator, files, project, (Consumer<FileContent>)((Consumer)content -> index.processRefreshedFile(project, (FileContent)content)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexProjectHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInSet";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateIndexableFilesIn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$1";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

