/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util.documentation;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.DocumentationUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.ColorSampleLookupValue;
import com.intellij.xml.util.documentation.CompositeAttributeTagDescriptor;
import com.intellij.xml.util.documentation.EntityDescriptor;
import com.intellij.xml.util.documentation.HtmlAttributeDescriptor;
import com.intellij.xml.util.documentation.HtmlDescriptorsTable;
import com.intellij.xml.util.documentation.HtmlTagDescriptor;
import com.intellij.xml.util.documentation.XmlDocumentationProvider;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class HtmlDocumentationProvider
implements DocumentationProvider {
    private DocumentationProvider myStyleProvider = null;
    private final boolean myUseStyleProvider;
    private static DocumentationProvider ourScriptProvider;
    @NonNls
    public static final String ELEMENT_ELEMENT_NAME = "element";
    @NonNls
    public static final String NBSP = ":&nbsp;";
    @NonNls
    public static final String BR = "<br>";

    public HtmlDocumentationProvider() {
        this(true);
    }

    public HtmlDocumentationProvider(boolean useStyleProvider) {
        this.myUseStyleProvider = useStyleProvider;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof SchemaPrefix) {
            return ((SchemaPrefix)element).getQuickNavigateInfo();
        }
        return null;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String result2 = HtmlDocumentationProvider.getUrlForHtml(element, (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class, (boolean)false));
        DocumentationProvider styleProvider = this.getStyleProvider();
        if (result2 == null && styleProvider != null) {
            return styleProvider.getUrlFor(element, originalElement);
        }
        return result2 != null ? Collections.singletonList(result2) : null;
    }

    public static String getUrlForHtml(PsiElement element, XmlTag context) {
        EntityDescriptor descriptor2 = HtmlDocumentationProvider.findDocumentationDescriptor(element, context);
        if (descriptor2 != null) {
            return descriptor2.getHelpRef();
        }
        return null;
    }

    private static EntityDescriptor findDocumentationDescriptor(PsiElement element, XmlTag context) {
        int dotIndex;
        XmlAttribute xmlAttribute;
        boolean isTag = true;
        XmlElement nameElement = null;
        String key = null;
        if (element instanceof XmlElementDecl) {
            nameElement = ((XmlElementDecl)element).getNameElement();
        } else if (element instanceof XmlAttributeDecl) {
            nameElement = ((XmlAttributeDecl)element).getNameElement();
            isTag = false;
        } else if (element instanceof XmlTag) {
            XmlTag xmlTag = (XmlTag)element;
            PsiMetaData metaData = xmlTag.getMetaData();
            key = metaData != null ? metaData.getName() : null;
            isTag = xmlTag.getLocalName().equals(ELEMENT_ELEMENT_NAME);
        } else if (element.getParent() instanceof XmlAttributeValue) {
            isTag = false;
            key = ((XmlAttribute)element.getParent().getParent()).getName();
        } else if (element instanceof XmlAttributeValue) {
            isTag = false;
            xmlAttribute = (XmlAttribute)element.getParent();
            key = xmlAttribute.getName();
        } else if (element instanceof XmlAttribute) {
            xmlAttribute = (XmlAttribute)element;
            isTag = false;
            key = xmlAttribute.getName();
        } else if (element instanceof XmlElement) {
            nameElement = element;
            isTag = !(element.getParent() instanceof XmlAttribute);
        } else {
            nameElement = element;
            if (context != null) {
                String text = element.getText();
                boolean bl = isTag = text != null && text.startsWith(context.getName());
            }
        }
        if (nameElement != null) {
            key = nameElement.getText();
        }
        if ((dotIndex = (key = StringUtil.notNullize(key).toLowerCase(Locale.US)).indexOf(46)) > 0) {
            key = key.substring(0, dotIndex);
        }
        if (isTag) {
            return HtmlDescriptorsTable.getTagDescriptor(key);
        }
        return HtmlDocumentationProvider.getDescriptor(key, context);
    }

    private static HtmlAttributeDescriptor getDescriptor(String name, XmlTag context) {
        HtmlAttributeDescriptor attributeDescriptor = HtmlDescriptorsTable.getAttributeDescriptor(name);
        if (attributeDescriptor instanceof CompositeAttributeTagDescriptor) {
            return ((CompositeAttributeTagDescriptor)attributeDescriptor).findHtmlAttributeInContext(context);
        }
        return attributeDescriptor;
    }

    public String generateDoc(PsiElement element, PsiElement originalElement) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class, (boolean)false);
        String result2 = this.generateDocForHtml(element, false, tag, originalElement);
        DocumentationProvider styleProvider = this.getStyleProvider();
        if (result2 == null && styleProvider != null) {
            result2 = styleProvider.generateDoc(element, originalElement);
        }
        if (result2 == null && ourScriptProvider != null) {
            result2 = ourScriptProvider.generateDoc(element, originalElement);
        }
        if (result2 == null && element instanceof XmlAttributeValue) {
            result2 = this.generateDocForHtml(element.getParent(), false, tag, originalElement);
        }
        return result2;
    }

    protected String generateDocForHtml(PsiElement element, boolean omitHtmlSpecifics, XmlTag context, PsiElement originalElement) {
        EntityDescriptor descriptor2 = HtmlDocumentationProvider.findDocumentationDescriptor(element, context);
        if (descriptor2 != null) {
            return HtmlDocumentationProvider.generateJavaDoc(descriptor2, omitHtmlSpecifics, originalElement);
        }
        if (element instanceof XmlEntityDecl) {
            XmlEntityDecl entityDecl = (XmlEntityDecl)element;
            return new XmlDocumentationProvider().findDocRightAfterElement(element, entityDecl.getName());
        }
        return null;
    }

    private static String generateJavaDoc(EntityDescriptor descriptor2, boolean omitHtmlSpecifics, PsiElement element) {
        boolean deprecated;
        StringBuilder buf = new StringBuilder();
        boolean isTag = descriptor2 instanceof HtmlTagDescriptor;
        if (isTag) {
            DocumentationUtil.formatEntityName((String)XmlBundle.message((String)"xml.javadoc.tag.name.message", (Object[])new Object[0]), (String)descriptor2.getName(), (StringBuilder)buf);
        } else {
            DocumentationUtil.formatEntityName((String)XmlBundle.message((String)"xml.javadoc.attribute.name.message", (Object[])new Object[0]), (String)descriptor2.getName(), (StringBuilder)buf);
        }
        buf.append(XmlBundle.message((String)"xml.javadoc.description.message", (Object[])new Object[0])).append(NBSP).append(descriptor2.getDescription()).append(BR);
        if (isTag) {
            HtmlTagDescriptor tagDescriptor = (HtmlTagDescriptor)descriptor2;
            if (!omitHtmlSpecifics) {
                boolean hasStartTag = tagDescriptor.isHasStartTag();
                if (!hasStartTag) {
                    buf.append(XmlBundle.message((String)"xml.javadoc.start.tag.could.be.omitted.message", (Object[])new Object[0])).append(BR);
                }
                if (!tagDescriptor.isEmpty() && !tagDescriptor.isHasEndTag()) {
                    buf.append(XmlBundle.message((String)"xml.javadoc.end.tag.could.be.omitted.message", (Object[])new Object[0])).append(BR);
                }
            }
            if (tagDescriptor.isEmpty()) {
                buf.append(XmlBundle.message((String)"xml.javadoc.is.empty.message", (Object[])new Object[0])).append(BR);
            }
        } else {
            HtmlAttributeDescriptor attributeDescriptor = (HtmlAttributeDescriptor)descriptor2;
            buf.append(XmlBundle.message((String)"xml.javadoc.attr.type.message", (Object[])new Object[]{attributeDescriptor.getType()})).append(BR);
            if (!attributeDescriptor.isHasDefaultValue()) {
                buf.append(XmlBundle.message((String)"xml.javadoc.attr.default.required.message", (Object[])new Object[0])).append(BR);
            }
        }
        char dtdId = descriptor2.getDtd();
        boolean bl = deprecated = dtdId == 'L';
        if (deprecated) {
            buf.append(XmlBundle.message((String)"xml.javadoc.deprecated.message", (Object[])new Object[]{true})).append(BR);
        }
        if (dtdId == 'L') {
            buf.append(XmlBundle.message((String)"xml.javadoc.defined.in.loose.dtd.message", (Object[])new Object[0]));
        } else if (dtdId == 'D') {
            buf.append(XmlBundle.message((String)"xml.javadoc.defined.in.frameset.dtd.message", (Object[])new Object[0]));
        } else {
            buf.append(XmlBundle.message((String)"xml.javadoc.defined.in.any.dtd.message", (Object[])new Object[0]));
        }
        if (!isTag) {
            ColorSampleLookupValue.addColorPreviewAndCodeToLookup(element, buf);
        }
        if (element != null) {
            buf.append(XmlDocumentationProvider.generateHtmlAdditionalDocTemplate(element));
        }
        return buf.toString();
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        PsiElement result2 = this.createNavigationElementHTML(psiManager, object.toString(), element);
        DocumentationProvider styleProvider = this.getStyleProvider();
        if (result2 == null && styleProvider != null) {
            result2 = styleProvider.getDocumentationElementForLookupItem(psiManager, object, element);
        }
        if (result2 == null && ourScriptProvider != null) {
            result2 = ourScriptProvider.getDocumentationElementForLookupItem(psiManager, object, element);
        }
        if (result2 == null && object instanceof String && element != null) {
            result2 = XmlDocumentationProvider.findDeclWithName((String)object, element);
        }
        return result2;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        PsiElement result2 = this.createNavigationElementHTML(psiManager, link, context);
        DocumentationProvider styleProvider = this.getStyleProvider();
        if (result2 == null && styleProvider != null) {
            result2 = styleProvider.getDocumentationElementForLink(psiManager, link, context);
        }
        if (result2 == null && ourScriptProvider != null && !DumbService.isDumb((Project)psiManager.getProject())) {
            result2 = ourScriptProvider.getDocumentationElementForLink(psiManager, link, context);
        }
        return result2;
    }

    public PsiElement createNavigationElementHTML(PsiManager psiManager, String text, PsiElement context) {
        String key = text.toLowerCase(Locale.US);
        HtmlTagDescriptor descriptor2 = HtmlDescriptorsTable.getTagDescriptor(key);
        if (descriptor2 != null && !this.isAttributeContext(context)) {
            try {
                XmlTag tagFromText = XmlElementFactory.getInstance((Project)psiManager.getProject()).createTagFromText((CharSequence)("<" + key + " xmlns=\"" + "http://www.w3.org/1999/xhtml" + "\"/>"));
                XmlElementDescriptor tagDescriptor = tagFromText.getDescriptor();
                return tagDescriptor != null ? tagDescriptor.getDeclaration() : null;
            }
            catch (IncorrectOperationException tagFromText) {}
        } else {
            XmlTag tagContext = this.findTagContext(context);
            HtmlAttributeDescriptor myAttributeDescriptor = HtmlDocumentationProvider.getDescriptor(key, tagContext);
            if (myAttributeDescriptor != null && tagContext != null) {
                XmlElementDescriptor tagDescriptor = tagContext.getDescriptor();
                XmlAttributeDescriptor attributeDescriptor = tagDescriptor != null ? tagDescriptor.getAttributeDescriptor(text, tagContext) : null;
                return attributeDescriptor != null ? attributeDescriptor.getDeclaration() : null;
            }
        }
        return null;
    }

    protected boolean isAttributeContext(PsiElement context) {
        PsiElement prevSibling;
        if (context instanceof XmlAttribute) {
            return true;
        }
        return context instanceof PsiWhiteSpace && (prevSibling = context.getPrevSibling()) instanceof XmlAttribute;
    }

    protected XmlTag findTagContext(PsiElement context) {
        PsiElement prevSibling;
        if (context instanceof PsiWhiteSpace && (prevSibling = context.getPrevSibling()) instanceof XmlTag) {
            return (XmlTag)prevSibling;
        }
        return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false);
    }

    public static void registerScriptDocumentationProvider(DocumentationProvider provider) {
        ourScriptProvider = provider;
    }

    @Nullable
    private DocumentationProvider getStyleProvider() {
        Language cssLanguage;
        if (!this.myUseStyleProvider) {
            return null;
        }
        if (this.myStyleProvider == null && (cssLanguage = Language.findLanguageByID((String)"CSS")) != null) {
            this.myStyleProvider = LanguageDocumentation.INSTANCE.forLanguage(cssLanguage);
        }
        return this.myStyleProvider;
    }
}

