/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import org.jetbrains.annotations.NotNull;

public class PyDictLiteralFormToConstructorIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.convert.dict.literal.to.dict.constructor", new Object[0]);
        if (string == null) {
            PyDictLiteralFormToConstructorIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.convert.dict.literal.to.dict.constructor", new Object[0]);
        if (string == null) {
            PyDictLiteralFormToConstructorIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            PyDictLiteralFormToConstructorIntention.$$$reportNull$$$0(2);
        }
        if (!(file2 instanceof PyFile)) {
            return false;
        }
        PyDictLiteralExpression dictExpression = (PyDictLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), PyDictLiteralExpression.class);
        if (dictExpression != null) {
            PyKeyValueExpression[] elements = dictExpression.getElements();
            if (elements.length != 0) {
                for (PyKeyValueExpression element : elements) {
                    PyExpression key = element.getKey();
                    if (!(key instanceof PyStringLiteralExpression)) {
                        return false;
                    }
                    String str = ((PyStringLiteralExpression)key).getStringValue();
                    if (PyNames.isReserved(str)) {
                        return false;
                    }
                    if (str.length() == 0 || Character.isDigit(str.charAt(0))) {
                        return false;
                    }
                    if (StringUtil.isJavaIdentifier((String)str)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            PyDictLiteralFormToConstructorIntention.$$$reportNull$$$0(3);
        }
        PyDictLiteralExpression dictExpression = (PyDictLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), PyDictLiteralExpression.class);
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        if (dictExpression != null) {
            PyDictLiteralFormToConstructorIntention.replaceDictLiteral(dictExpression, elementGenerator);
        }
    }

    private static void replaceDictLiteral(PyDictLiteralExpression dictExpression, PyElementGenerator elementGenerator) {
        PyKeyValueExpression[] argumentList = dictExpression.getElements();
        StringBuilder stringBuilder = new StringBuilder("dict(");
        int size = argumentList.length;
        for (int i = 0; i != size; ++i) {
            PyKeyValueExpression argument = argumentList[i];
            if (!(argument instanceof PyKeyValueExpression)) continue;
            PyExpression key = argument.getKey();
            PyExpression value = argument.getValue();
            if (!(key instanceof PyStringLiteralExpression) || value == null) continue;
            stringBuilder.append(((PyStringLiteralExpression)key).getStringValue());
            stringBuilder.append("=");
            stringBuilder.append(value.getText());
            if (i == size - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        PyCallExpression callExpression = (PyCallExpression)elementGenerator.createFromText(LanguageLevel.forElement((PsiElement)dictExpression), PyExpressionStatement.class, stringBuilder.toString()).getExpression();
        dictExpression.replace((PsiElement)callExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyDictLiteralFormToConstructorIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyDictLiteralFormToConstructorIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

