/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PathMapper;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleType;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.PythonCommandLineState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PydevConsoleRunnerFactory
extends PythonConsoleRunnerFactory {
    @Override
    @NotNull
    public PydevConsoleRunner createConsoleRunner(@NotNull Project project, @Nullable Module contextModule) {
        if (project == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(0);
        }
        Pair<Sdk, Module> sdkAndModule = PydevConsoleRunner.findPythonSdkAndModule(project, contextModule);
        Module module2 = (Module)sdkAndModule.second;
        Sdk sdk = (Sdk)sdkAndModule.first;
        assert (sdk != null);
        PyConsoleOptions.PyConsoleSettings settingsProvider = PyConsoleOptions.getInstance(project).getPythonConsoleSettings();
        PyRemotePathMapper pathMapper = PydevConsoleRunner.getPathMapper(project, sdk, settingsProvider);
        String workingDir = PydevConsoleRunnerFactory.getWorkingDir(project, module2, (PathMapper)pathMapper, settingsProvider);
        String[] setupFragment = PydevConsoleRunnerFactory.createSetupFragment(module2, workingDir, (PathMapper)pathMapper, settingsProvider);
        HashMap envs = Maps.newHashMap(settingsProvider.getEnvs());
        PydevConsoleRunnerFactory.putIPythonEnvFlag(project, envs);
        Consumer rerunAction = title -> {
            PydevConsoleRunner runner;
            if (project == null) {
                PydevConsoleRunnerFactory.$$$reportNull$$$0(12);
            }
            if ((runner = this.createConsoleRunner(project, module2)) instanceof PydevConsoleRunnerImpl) {
                ((PydevConsoleRunnerImpl)runner).setConsoleTitle((String)title);
            }
            runner.run();
        };
        PydevConsoleRunner pydevConsoleRunner = this.createConsoleRunner(project, sdk, workingDir, envs, PyConsoleType.PYTHON, settingsProvider, (Consumer<String>)rerunAction, setupFragment);
        if (pydevConsoleRunner == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(1);
        }
        return pydevConsoleRunner;
    }

    public static void putIPythonEnvFlag(@NotNull Project project, Map<String, String> envs) {
        if (project == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(2);
        }
        String ipythonEnabled = PyConsoleOptions.getInstance(project).isIpythonEnabled() ? "True" : "False";
        envs.put("IPYTHONENABLE", ipythonEnabled);
    }

    @Nullable
    public static String getWorkingDir(@NotNull Project project, @Nullable Module module2, @Nullable PathMapper pathMapper, PyConsoleOptions.PyConsoleSettings settingsProvider) {
        String workingDir;
        if (project == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(workingDir = settingsProvider.getWorkingDirectory()))) {
            VirtualFile[] roots;
            if (module2 != null && ModuleRootManager.getInstance((Module)module2).getContentRoots().length > 0) {
                workingDir = ModuleRootManager.getInstance((Module)module2).getContentRoots()[0].getPath();
            } else if (ModuleManager.getInstance((Project)project).getModules().length > 0 && (roots = ModuleRootManager.getInstance((Module)ModuleManager.getInstance((Project)project).getModules()[0]).getContentRoots()).length > 0) {
                workingDir = roots[0].getPath();
            }
        }
        if (pathMapper != null && workingDir != null) {
            workingDir = pathMapper.convertToRemote(workingDir);
        }
        return workingDir;
    }

    public static String[] createSetupFragment(@Nullable Module module2, @Nullable String workingDir, @Nullable PathMapper pathMapper, PyConsoleOptions.PyConsoleSettings settingsProvider) {
        String[] setupFragment;
        String customStartScript = settingsProvider.getCustomStartScript();
        if (customStartScript.trim().length() > 0) {
            customStartScript = "\n" + customStartScript;
        }
        List pythonPath = PythonCommandLineState.collectPythonPath(module2, settingsProvider.shouldAddContentRoots(), settingsProvider.shouldAddSourceRoots());
        if (pathMapper != null) {
            pythonPath = pathMapper.convertToRemote(pythonPath);
        }
        String selfPathAppend = PydevConsoleRunner.constructPyPathAndWorkingDirCommand(pythonPath, workingDir, customStartScript);
        BuildoutFacet facet = null;
        if (module2 != null) {
            facet = BuildoutFacet.getInstance(module2);
        }
        if (facet != null) {
            List path = facet.getAdditionalPythonPath();
            if (pathMapper != null) {
                path = pathMapper.convertToRemote(path);
            }
            String prependStatement = facet.getPathPrependStatement(path);
            setupFragment = new String[]{prependStatement, selfPathAppend};
        } else {
            setupFragment = new String[]{selfPathAppend};
        }
        return setupFragment;
    }

    @NotNull
    protected PydevConsoleRunner createConsoleRunner(@NotNull Project project, @NotNull Sdk sdk, @Nullable String workingDir, @NotNull Map<String, String> envs, @NotNull PyConsoleType consoleType, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull Consumer<String> rerunAction, String ... setupFragment) {
        if (project == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(4);
        }
        if (sdk == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(5);
        }
        if (envs == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(6);
        }
        if (consoleType == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(7);
        }
        if (settingsProvider == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(8);
        }
        if (rerunAction == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(9);
        }
        if (setupFragment == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(10);
        }
        PydevConsoleRunnerImpl pydevConsoleRunnerImpl = new PydevConsoleRunnerImpl(project, sdk, consoleType, workingDir, envs, settingsProvider, rerunAction, setupFragment);
        if (pydevConsoleRunnerImpl == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(11);
        }
        return pydevConsoleRunnerImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rerunAction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerFactory";
                break;
            }
            case 1: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleRunner";
                break;
            }
            case 1: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putIPythonEnvFlag";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDir";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createConsoleRunner$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

