/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.packaging.PyExecutionFix;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyExecutionException
extends ExecutionException {
    @NotNull
    private String myCommand;
    @NotNull
    private List<String> myArgs;
    @NotNull
    private final String myStdout;
    @NotNull
    private final String myStderr;
    private final int myExitCode;
    @NotNull
    private final List<? extends PyExecutionFix> myFixes;

    public PyExecutionException(@NotNull String message, @NotNull String command, @NotNull List<String> args) {
        if (message == null) {
            PyExecutionException.$$$reportNull$$$0(0);
        }
        if (command == null) {
            PyExecutionException.$$$reportNull$$$0(1);
        }
        if (args == null) {
            PyExecutionException.$$$reportNull$$$0(2);
        }
        this(message, command, args, "", "", 0, Collections.emptyList());
    }

    public PyExecutionException(@NotNull String message, @NotNull String command, @NotNull List<String> args, @NotNull ProcessOutput output) {
        if (message == null) {
            PyExecutionException.$$$reportNull$$$0(3);
        }
        if (command == null) {
            PyExecutionException.$$$reportNull$$$0(4);
        }
        if (args == null) {
            PyExecutionException.$$$reportNull$$$0(5);
        }
        if (output == null) {
            PyExecutionException.$$$reportNull$$$0(6);
        }
        this(message, command, args, output.getStdout(), output.getStderr(), output.getExitCode(), Collections.emptyList());
    }

    public PyExecutionException(@NotNull String message, @NotNull String command, @NotNull List<String> args, @NotNull String stdout, @NotNull String stderr, int exitCode, @NotNull List<? extends PyExecutionFix> fixes) {
        if (message == null) {
            PyExecutionException.$$$reportNull$$$0(7);
        }
        if (command == null) {
            PyExecutionException.$$$reportNull$$$0(8);
        }
        if (args == null) {
            PyExecutionException.$$$reportNull$$$0(9);
        }
        if (stdout == null) {
            PyExecutionException.$$$reportNull$$$0(10);
        }
        if (stderr == null) {
            PyExecutionException.$$$reportNull$$$0(11);
        }
        if (fixes == null) {
            PyExecutionException.$$$reportNull$$$0(12);
        }
        super(message);
        this.myCommand = command;
        this.myArgs = args;
        this.myStdout = stdout;
        this.myStderr = stderr;
        this.myExitCode = exitCode;
        this.myFixes = fixes;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("The following command was executed:\n\n");
        String command = this.getCommand() + " " + StringUtil.join(this.getArgs(), (String)" ");
        b.append(command);
        b.append("\n\n");
        b.append("The exit code: ").append(this.myExitCode).append("\n");
        b.append("The error output of the command:\n\n");
        b.append(this.myStdout);
        b.append("\n");
        b.append(this.myStderr);
        b.append("\n");
        b.append(this.getMessage());
        return b.toString();
    }

    @NotNull
    public String getCommand() {
        String string = this.myCommand;
        if (string == null) {
            PyExecutionException.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public List<String> getArgs() {
        List<String> list2 = this.myArgs;
        if (list2 == null) {
            PyExecutionException.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @NotNull
    public List<? extends PyExecutionFix> getFixes() {
        List<? extends PyExecutionFix> list2 = this.myFixes;
        if (list2 == null) {
            PyExecutionException.$$$reportNull$$$0(15);
        }
        return list2;
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    @NotNull
    public String getStdout() {
        String string = this.myStdout;
        if (string == null) {
            PyExecutionException.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public String getStderr() {
        String string = this.myStderr;
        if (string == null) {
            PyExecutionException.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdout";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stderr";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyExecutionException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyExecutionException";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgs";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdout";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getStderr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

