/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.webcore.packaging.RepoPackage;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.packaging.PyPIPackageCache;
import com.jetbrains.python.packaging.PyPackageService;
import com.jetbrains.python.packaging.PyPackageVersionComparator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPIPackageUtil {
    private static final Logger LOG = Logger.getInstance(PyPIPackageUtil.class);
    private static final Gson GSON = new GsonBuilder().create();
    private static final String PYPI_HOST = "https://pypi.python.org";
    public static final String PYPI_URL = "https://pypi.python.org/pypi";
    public static final String PYPI_LIST_URL = "https://pypi.python.org/simple";
    public static final ImmutableMap<String, List<String>> PACKAGES_TOPLEVEL = PyPIPackageUtil.loadPackageAliases();
    public static final PyPIPackageUtil INSTANCE = new PyPIPackageUtil();
    private final LoadingCache<String, List<String>> myAdditionalPackagesReleases = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<String>>(){

        public List<String> load(@NotNull String key) throws Exception {
            if (key == null) {
                1.$$$reportNull$$$0(0);
            }
            LOG.debug("Searching for versions of package '" + key + "' in additional repositories");
            List<String> repositories = PyPackageService.getInstance().additionalRepositories;
            for (String repository : repositories) {
                List versions = PyPIPackageUtil.parsePackageVersionsFromArchives(PyPIPackageUtil.composeSimpleUrl(key, repository));
                if (versions.isEmpty()) continue;
                LOG.debug("Found versions " + versions + " in " + repository);
                return Collections.unmodifiableList(versions);
            }
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/packaging/PyPIPackageUtil$1", "load"));
        }
    });
    private volatile List<RepoPackage> myAdditionalPackages = null;
    private final LoadingCache<String, PackageDetails> myPackageToDetails = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, PackageDetails>(){

        public PackageDetails load(@NotNull String key) throws Exception {
            if (key == null) {
                2.$$$reportNull$$$0(0);
            }
            LOG.debug("Fetching details for the package '" + key + "' on PyPI");
            return (PackageDetails)HttpRequests.request((String)("https://pypi.python.org/pypi/" + key + "/json")).userAgent(PyPIPackageUtil.getUserAgent()).connect(request -> (PackageDetails)GSON.fromJson((Reader)request.getReader(), PackageDetails.class));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/packaging/PyPIPackageUtil$2", "load"));
        }
    });
    private final Object myPyPIPackageCacheUpdateLock = new Object();

    @NotNull
    private static String getUserAgent() {
        String string = ApplicationNamesInfo.getInstance().getProductName() + "/" + ApplicationInfo.getInstance().getFullVersion();
        if (string == null) {
            PyPIPackageUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static ImmutableMap<String, List<String>> loadPackageAliases() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try {
            Files.lines(Paths.get(PythonHelpersLocator.getHelperPath("/tools/packages"), new String[0])).forEach(line -> {
                List split = StringUtil.split((String)line, (String)" ");
                builder.put(split.get(0), (Object)new SmartList((Collection)ContainerUtil.subList((List)split, (int)1)));
            });
        }
        catch (IOException e) {
            LOG.error("Cannot find \"packages\". " + e.getMessage());
        }
        ImmutableMap immutableMap = builder.build();
        if (immutableMap == null) {
            PyPIPackageUtil.$$$reportNull$$$0(1);
        }
        return immutableMap;
    }

    @NotNull
    private static Pair<String, String> splitNameVersion(@NotNull String pyPackage) {
        int dashInd;
        if (pyPackage == null) {
            PyPIPackageUtil.$$$reportNull$$$0(2);
        }
        if ((dashInd = pyPackage.lastIndexOf("-")) >= 0 && dashInd + 1 < pyPackage.length()) {
            String name = pyPackage.substring(0, dashInd);
            String version = pyPackage.substring(dashInd + 1);
            if (StringUtil.containsAlphaCharacters((String)version)) {
                Pair pair = Pair.create((Object)pyPackage, null);
                if (pair == null) {
                    PyPIPackageUtil.$$$reportNull$$$0(3);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)name, (Object)version);
            if (pair == null) {
                PyPIPackageUtil.$$$reportNull$$$0(4);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)pyPackage, null);
        if (pair == null) {
            PyPIPackageUtil.$$$reportNull$$$0(5);
        }
        return pair;
    }

    public static boolean isPyPIRepository(@Nullable String repository) {
        return repository != null && repository.startsWith(PYPI_HOST);
    }

    @NotNull
    public List<RepoPackage> getAdditionalPackages() {
        List<RepoPackage> list2 = this.myAdditionalPackages != null ? Collections.unmodifiableList(this.myAdditionalPackages) : Collections.emptyList();
        if (list2 == null) {
            PyPIPackageUtil.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public List<RepoPackage> loadAndGetAdditionalPackages(boolean alwaysRefresh) throws IOException {
        if (this.myAdditionalPackages == null || alwaysRefresh) {
            TreeSet<RepoPackage> uniquePackages = new TreeSet<RepoPackage>();
            for (String url : PyPackageService.getInstance().additionalRepositories) {
                uniquePackages.addAll(PyPIPackageUtil.getPackagesFromAdditionalRepository(url));
            }
            this.myAdditionalPackages = new ArrayList<RepoPackage>(uniquePackages);
        }
        List<RepoPackage> list2 = Collections.unmodifiableList(this.myAdditionalPackages);
        if (list2 == null) {
            PyPIPackageUtil.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    private static List<RepoPackage> getPackagesFromAdditionalRepository(@NotNull String url) throws IOException {
        if (url == null) {
            PyPIPackageUtil.$$$reportNull$$$0(8);
        }
        ArrayList<RepoPackage> result2 = new ArrayList<RepoPackage>();
        boolean simpleIndex = url.endsWith("simple/");
        List<String> packagesList = PyPIPackageUtil.parsePyPIListFromWeb(url, simpleIndex);
        for (String pyPackage : packagesList) {
            if (simpleIndex) {
                Pair<String, String> nameVersion = PyPIPackageUtil.splitNameVersion(StringUtil.trimTrailing((String)pyPackage, (char)'/'));
                result2.add(new RepoPackage((String)nameVersion.getFirst(), url, (String)nameVersion.getSecond()));
                continue;
            }
            try {
                Pattern repositoryPattern = Pattern.compile(url + "([^/]*)/([^/]*)$");
                Matcher matcher = repositoryPattern.matcher(URLDecoder.decode(pyPackage, "UTF-8"));
                if (!matcher.find()) continue;
                String packageName = matcher.group(1);
                String packageVersion = matcher.group(2);
                if (packageName.contains(" ")) continue;
                result2.add(new RepoPackage(packageName, url, packageVersion));
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn(e.getMessage());
            }
        }
        ArrayList<RepoPackage> arrayList = result2;
        if (arrayList == null) {
            PyPIPackageUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public void fillPackageDetails(@NotNull String packageName, @NotNull CatchingConsumer<PackageDetails.Info, Exception> callback) {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(10);
        }
        if (callback == null) {
            PyPIPackageUtil.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (packageName == null) {
                PyPIPackageUtil.$$$reportNull$$$0(38);
            }
            if (callback == null) {
                PyPIPackageUtil.$$$reportNull$$$0(39);
            }
            try {
                PackageDetails packageDetails = this.refreshAndGetPackageDetailsFromPyPI(packageName, false);
                callback.consume((Object)packageDetails.getInfo());
            }
            catch (IOException e) {
                callback.consume((Throwable)e);
            }
        });
    }

    @NotNull
    private PackageDetails refreshAndGetPackageDetailsFromPyPI(@NotNull String packageName, boolean alwaysRefresh) throws IOException {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(12);
        }
        if (alwaysRefresh) {
            this.myPackageToDetails.invalidate((Object)packageName);
        }
        PackageDetails packageDetails = PyPIPackageUtil.getCachedValueOrRethrowIO(this.myPackageToDetails, packageName);
        if (packageDetails == null) {
            PyPIPackageUtil.$$$reportNull$$$0(13);
        }
        return packageDetails;
    }

    public void usePackageReleases(@NotNull String packageName, @NotNull CatchingConsumer<List<String>, Exception> callback) {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(14);
        }
        if (callback == null) {
            PyPIPackageUtil.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (packageName == null) {
                PyPIPackageUtil.$$$reportNull$$$0(36);
            }
            if (callback == null) {
                PyPIPackageUtil.$$$reportNull$$$0(37);
            }
            try {
                List<String> releasesFromSimpleIndex = this.getPackageVersionsFromAdditionalRepositories(packageName);
                if (releasesFromSimpleIndex.isEmpty()) {
                    List<String> releasesFromPyPI = this.getPackageVersionsFromPyPI(packageName, true);
                    callback.consume(releasesFromPyPI);
                } else {
                    callback.consume(releasesFromSimpleIndex);
                }
            }
            catch (Exception e) {
                callback.consume((Throwable)e);
            }
        });
    }

    @NotNull
    private List<String> getPackageVersionsFromPyPI(@NotNull String packageName, boolean force) throws IOException {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(16);
        }
        PackageDetails details = this.refreshAndGetPackageDetailsFromPyPI(packageName, force);
        List<String> result2 = details.getReleases();
        result2.sort(PyPackageVersionComparator.getSTR_COMPARATOR().reversed());
        List<String> list2 = Collections.unmodifiableList(result2);
        if (list2 == null) {
            PyPIPackageUtil.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @Nullable
    private String getLatestPackageVersionFromPyPI(@NotNull String packageName) throws IOException {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(18);
        }
        LOG.debug("Requesting the latest PyPI version for the package " + packageName);
        List<String> versions = this.getPackageVersionsFromPyPI(packageName, true);
        return (String)ContainerUtil.getFirstItem(versions);
    }

    @NotNull
    private List<String> getPackageVersionsFromAdditionalRepositories(@NotNull String packageName) throws IOException {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(19);
        }
        List<String> list2 = PyPIPackageUtil.getCachedValueOrRethrowIO(this.myAdditionalPackagesReleases, packageName);
        if (list2 == null) {
            PyPIPackageUtil.$$$reportNull$$$0(20);
        }
        return list2;
    }

    @NotNull
    private static <T> T getCachedValueOrRethrowIO(@NotNull LoadingCache<String, ? extends T> cache, @NotNull String key) throws IOException {
        Object object;
        if (cache == null) {
            PyPIPackageUtil.$$$reportNull$$$0(21);
        }
        if (key == null) {
            PyPIPackageUtil.$$$reportNull$$$0(22);
        }
        try {
            object = cache.get((Object)key);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw cause instanceof IOException ? (IOException)cause : new IOException("Unexpected non-IO error", cause);
        }
        if (object == null) {
            PyPIPackageUtil.$$$reportNull$$$0(23);
        }
        return (T)object;
    }

    @Nullable
    private String getLatestPackageVersionFromAdditionalRepositories(@NotNull String packageName) throws IOException {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(24);
        }
        List<String> versions = this.getPackageVersionsFromAdditionalRepositories(packageName);
        return (String)ContainerUtil.getFirstItem(versions);
    }

    @Nullable
    public String fetchLatestPackageVersion(@NotNull String packageName) throws IOException {
        String extraVersion;
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(25);
        }
        String version = null;
        if (PyPIPackageCache.getInstance().containsPackage(packageName)) {
            version = this.getLatestPackageVersionFromPyPI(packageName);
        }
        if (!PyPackageService.getInstance().additionalRepositories.isEmpty() && (extraVersion = this.getLatestPackageVersionFromAdditionalRepositories(packageName)) != null) {
            version = extraVersion;
        }
        return version;
    }

    @NotNull
    private static List<String> parsePackageVersionsFromArchives(@NotNull String archivesUrl) throws IOException {
        if (archivesUrl == null) {
            PyPIPackageUtil.$$$reportNull$$$0(26);
        }
        List list2 = (List)HttpRequests.request((String)archivesUrl).userAgent(PyPIPackageUtil.getUserAgent()).connect(request -> {
            final ArrayList<String> versions = new ArrayList<String>();
            BufferedReader reader = request.getReader();
            new ParserDelegator().parse(reader, new HTMLEditorKit.ParserCallback(){
                HTML.Tag myTag;

                @Override
                public void handleStartTag(HTML.Tag tag, MutableAttributeSet set2, int i) {
                    this.myTag = tag;
                }

                @Override
                public void handleText(@NotNull char[] data, int pos) {
                    if (data == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (this.myTag != null && "a".equals(this.myTag.toString())) {
                        String packageVersion = String.valueOf(data);
                        String suffix = ".tar.gz";
                        if (!packageVersion.endsWith(".tar.gz")) {
                            return;
                        }
                        packageVersion = StringUtil.trimEnd((String)packageVersion, (String)".tar.gz");
                        versions.add(PyPIPackageUtil.splitNameVersion((String)packageVersion).second);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/python/packaging/PyPIPackageUtil$3", "handleText"));
                }
            }, true);
            versions.sort(PyPackageVersionComparator.getSTR_COMPARATOR().reversed());
            return versions;
        });
        if (list2 == null) {
            PyPIPackageUtil.$$$reportNull$$$0(27);
        }
        return list2;
    }

    @NotNull
    private static String composeSimpleUrl(@NonNls @NotNull String packageName, @NotNull String rep) {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(28);
        }
        if (rep == null) {
            PyPIPackageUtil.$$$reportNull$$$0(29);
        }
        String suffix = "";
        String repository = StringUtil.trimEnd((String)rep, (String)"/");
        if (!repository.endsWith("+simple") && !repository.endsWith("/simple")) {
            suffix = "/+simple";
        }
        suffix = suffix + "/" + packageName;
        String string = repository + suffix;
        if (string == null) {
            PyPIPackageUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    public void updatePyPICache() throws IOException {
        PyPackageService service = PyPackageService.getInstance();
        if (service.PYPI_REMOVED.booleanValue()) {
            return;
        }
        List<String> decodedNames = PyPIPackageUtil.parsePyPIList(PyPIPackageUtil.parsePyPIListFromWeb(PYPI_LIST_URL, true));
        PyPIPackageCache.reload(decodedNames);
        service.LAST_TIME_CHECKED = System.currentTimeMillis();
    }

    @NotNull
    private static List<String> parsePyPIList(@NotNull List<String> packages) {
        if (packages == null) {
            PyPIPackageUtil.$$$reportNull$$$0(31);
        }
        ArrayList<String> decodedNames = new ArrayList<String>();
        for (String pyPackage : packages) {
            try {
                String packageName = URLDecoder.decode(pyPackage, "UTF-8");
                if (packageName.contains(" ")) continue;
                decodedNames.add(packageName);
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn(e.getMessage());
            }
        }
        ArrayList<String> arrayList = decodedNames;
        if (arrayList == null) {
            PyPIPackageUtil.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> parsePyPIListFromWeb(@NotNull String url, final boolean isSimpleIndex) throws IOException {
        if (url == null) {
            PyPIPackageUtil.$$$reportNull$$$0(33);
        }
        LOG.debug("Fetching index of all packages available on " + url);
        List list2 = (List)HttpRequests.request((String)url).userAgent(PyPIPackageUtil.getUserAgent()).connect(request -> {
            final ArrayList packages = new ArrayList();
            BufferedReader reader = request.getReader();
            new ParserDelegator().parse(reader, new HTMLEditorKit.ParserCallback(){
                boolean inTable = false;
                HTML.Tag myTag;

                @Override
                public void handleStartTag(@NotNull HTML.Tag tag, @NotNull MutableAttributeSet set2, int i) {
                    if (tag == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (set2 == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    this.myTag = tag;
                    if (!isSimpleIndex) {
                        if ("table".equals(tag.toString())) {
                            boolean bl = this.inTable = !this.inTable;
                        }
                        if (this.inTable && "a".equals(tag.toString())) {
                            packages.add(String.valueOf(set2.getAttribute(HTML.Attribute.HREF)));
                        }
                    }
                }

                @Override
                public void handleText(@NotNull char[] data, int pos) {
                    if (data == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    if (isSimpleIndex && this.myTag != null && "a".equals(this.myTag.toString())) {
                        packages.add(String.valueOf(data));
                    }
                }

                @Override
                public void handleEndTag(@NotNull HTML.Tag tag, int i) {
                    if (tag == null) {
                        4.$$$reportNull$$$0(3);
                    }
                    if (!isSimpleIndex && "table".equals(tag.toString())) {
                        this.inTable = !this.inTable;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "tag";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "set";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "data";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/python/packaging/PyPIPackageUtil$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleStartTag";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleText";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleEndTag";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, true);
            return packages;
        });
        if (list2 == null) {
            PyPIPackageUtil.$$$reportNull$$$0(34);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAndGetPackages() throws IOException {
        Object object = this.myPyPIPackageCacheUpdateLock;
        synchronized (object) {
            PyPIPackageCache cache = PyPIPackageCache.getInstance();
            if (cache.getPackageNames().isEmpty()) {
                this.updatePyPICache();
            }
        }
    }

    public boolean isInPyPI(@NotNull String packageName) {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(35);
        }
        return PyPIPackageCache.getInstance().containsPackage(packageName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPIPackageUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyPackage";
                break;
            }
            case 8: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 11: 
            case 15: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archivesUrl";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rep";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserAgent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPackageAliases";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPIPackageUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "splitNameVersion";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPackages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndGetAdditionalPackages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesFromAdditionalRepository";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshAndGetPackageDetailsFromPyPI";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageVersionsFromPyPI";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageVersionsFromAdditionalRepositories";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedValueOrRethrowIO";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePackageVersionsFromArchives";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "composeSimpleUrl";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePyPIList";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePyPIListFromWeb";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "splitNameVersion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPackagesFromAdditionalRepository";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fillPackageDetails";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndGetPackageDetailsFromPyPI";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "usePackageReleases";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPackageVersionsFromPyPI";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLatestPackageVersionFromPyPI";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPackageVersionsFromAdditionalRepositories";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValueOrRethrowIO";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLatestPackageVersionFromAdditionalRepositories";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fetchLatestPackageVersion";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageVersionsFromArchives";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "composeSimpleUrl";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "parsePyPIList";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "parsePyPIListFromWeb";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isInPyPI";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$usePackageReleases$2";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fillPackageDetails$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class PackageDetails {
        @SerializedName(value="info")
        private Info info = new Info();
        @SerializedName(value="releases")
        private Map<String, Object> releases = Collections.emptyMap();

        @NotNull
        public Info getInfo() {
            Info info = this.info;
            if (info == null) {
                PackageDetails.$$$reportNull$$$0(0);
            }
            return info;
        }

        @NotNull
        public List<String> getReleases() {
            ArrayList<String> arrayList = new ArrayList<String>(this.releases.keySet());
            if (arrayList == null) {
                PackageDetails.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/python/packaging/PyPIPackageUtil$PackageDetails";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReleases";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }

        public static final class Info {
            @SerializedName(value="version")
            private String version = "";
            @SerializedName(value="author")
            private String author = "";
            @SerializedName(value="author_email")
            private String authorEmail = "";
            @SerializedName(value="home_page")
            private String homePage = "";
            @SerializedName(value="summary")
            private String summary = "";

            @NotNull
            public String getVersion() {
                String string = StringUtil.notNullize((String)this.version);
                if (string == null) {
                    Info.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getAuthor() {
                String string = StringUtil.notNullize((String)this.author);
                if (string == null) {
                    Info.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            public String getAuthorEmail() {
                String string = StringUtil.notNullize((String)this.authorEmail);
                if (string == null) {
                    Info.$$$reportNull$$$0(2);
                }
                return string;
            }

            @NotNull
            public String getHomePage() {
                String string = StringUtil.notNullize((String)this.homePage);
                if (string == null) {
                    Info.$$$reportNull$$$0(3);
                }
                return string;
            }

            @NotNull
            public String getSummary() {
                String string = StringUtil.notNullize((String)this.summary);
                if (string == null) {
                    Info.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/python/packaging/PyPIPackageUtil$PackageDetails$Info";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVersion";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAuthor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAuthorEmail";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHomePage";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSummary";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
    }
}

