/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class PySuperMethodsSearchExecutor
implements QueryExecutor<PsiElement, PySuperMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull PySuperMethodsSearch.SearchParameters queryParameters, @NotNull Processor<PsiElement> consumer) {
        if (queryParameters == null) {
            PySuperMethodsSearchExecutor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PySuperMethodsSearchExecutor.$$$reportNull$$$0(1);
        }
        PyFunction func = queryParameters.getDerivedMethod();
        String name = func.getName();
        PyClass containingClass = func.getContainingClass();
        HashSet<PyClass> foundMethodContainingClasses = new HashSet<PyClass>();
        TypeEvalContext context = queryParameters.getContext();
        if (name != null && containingClass != null) {
            for (PyClass superClass : containingClass.getAncestorClasses(context)) {
                PyClassLikeType classLikeType;
                PyFunction superMethod;
                if (!queryParameters.isDeepSearch()) {
                    boolean isAlreadyFound = false;
                    for (PyClass alreadyFound : foundMethodContainingClasses) {
                        if (!alreadyFound.isSubclass(superClass, context)) continue;
                        isAlreadyFound = true;
                    }
                    if (isAlreadyFound) continue;
                }
                if ((superMethod = superClass.findMethodByName(name, false, context)) != null) {
                    Property property = func.getProperty();
                    Property superProperty = superMethod.getProperty();
                    if (property != null && superProperty != null) {
                        AccessDirection direction = PyUtil.getPropertyAccessDirection(func);
                        PyCallable callable = superProperty.getByDirection(direction).valueOrNull();
                        PyFunction pyFunction = superMethod = callable instanceof PyFunction ? (PyFunction)callable : null;
                    }
                }
                if (superMethod == null && context != null && (classLikeType = PyUtil.as(context.getType(superClass), PyClassLikeType.class)) != null) {
                    for (PyFunction function : PyTypeUtil.getMembersOfType((PyClassLikeType)classLikeType.toInstance(), PyFunction.class, true, context)) {
                        String elemName = function.getName();
                        if (elemName == null || !elemName.equals(func.getName())) continue;
                        consumer.process((Object)function);
                    }
                }
                if (superMethod == null) continue;
                foundMethodContainingClasses.add(superClass);
                if (consumer.process((Object)superMethod)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/psi/search/PySuperMethodsSearchExecutor";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

