/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PathMapper;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleType;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevConsoleRunnerFactory;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.actions.ShowVarsAction;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonScriptCommandLineState
extends PythonCommandLineState {
    private final PythonRunConfiguration myConfig;

    public PythonScriptCommandLineState(PythonRunConfiguration runConfiguration, ExecutionEnvironment env) {
        super(runConfiguration, env);
        this.myConfig = runConfiguration;
    }

    @Override
    public ExecutionResult execute(Executor executor, PythonCommandLineState.PythonProcessStarter processStarter, CommandLinePatcher ... patchers) throws ExecutionException {
        Project project = this.myConfig.getProject();
        if (this.myConfig.showCommandLineAfterwards() && !this.myConfig.emulateTerminal()) {
            if (executor.getId() != DefaultDebugExecutor.EXECUTOR_ID && executor.getId() != DefaultRunExecutor.EXECUTOR_ID) {
                return super.execute(executor, processStarter, patchers);
            }
            if (executor.getId() == DefaultDebugExecutor.EXECUTOR_ID) {
                return super.execute(executor, processStarter, (CommandLinePatcher[])ArrayUtil.append((Object[])patchers, (Object)new CommandLinePatcher(){

                    @Override
                    public void patchCommandLine(GeneralCommandLine commandLine) {
                        commandLine.getParametersList().getParamsGroup("Debugger").addParameterAt(1, "--cmd-line");
                    }
                }));
            }
            if (this.myConfig.isModuleMode()) {
                patchers = (CommandLinePatcher[])ArrayUtil.append((Object[])patchers, (Object)new CommandLinePatcher(){

                    @Override
                    public void patchCommandLine(GeneralCommandLine commandLine) {
                        ParamsGroup moduleParams;
                        ParametersList parametersList = commandLine.getParametersList();
                        boolean isModule = PyDebugRunner.patchExeParams(parametersList);
                        if (isModule && (moduleParams = parametersList.getParamsGroup("Module")) != null) {
                            moduleParams.addParameterAt(0, "--module");
                        }
                    }
                });
            }
            Module module2 = this.myConfig.getModule();
            PyConsoleOptions.PyConsoleSettings settingsProvider = PyConsoleOptions.getInstance(project).getPythonConsoleSettings();
            PyRemotePathMapper pathMapper = PydevConsoleRunner.getPathMapper(project, this.myConfig.getSdk(), settingsProvider);
            String workingDir = this.myConfig.getWorkingDirectory();
            if (StringUtil.isEmptyOrSpaces((String)workingDir)) {
                workingDir = PydevConsoleRunnerFactory.getWorkingDir(project, module2, (PathMapper)pathMapper, settingsProvider);
            }
            String[] setupFragment = PydevConsoleRunnerFactory.createSetupFragment(module2, workingDir, (PathMapper)pathMapper, settingsProvider);
            if (this.myConfig.getSdk() == null) {
                throw new ExecutionException("Cannot find SDK for Run configuration " + this.myConfig.getName());
            }
            HashMap unitedEnvs = Maps.newHashMap(settingsProvider.getEnvs());
            unitedEnvs.putAll(this.myConfig.getEnvs());
            PydevConsoleRunnerFactory.putIPythonEnvFlag(project, unitedEnvs);
            PythonScriptWithConsoleRunner runner = new PythonScriptWithConsoleRunner(project, this.myConfig.getSdk(), PyConsoleType.PYTHON, workingDir, unitedEnvs, patchers, settingsProvider, setupFragment);
            runner.setEnableAfterConnection(false);
            runner.runSync();
            if (runner.getProcessHandler() == null) {
                return null;
            }
            runner.getPydevConsoleCommunication().setConsoleView(runner.getConsoleView());
            ArrayList actions = Lists.newArrayList((Object[])this.createActions(runner.getConsoleView(), (ProcessHandler)runner.getProcessHandler()));
            actions.add(new ShowVarsAction(runner.getConsoleView(), runner.getPydevConsoleCommunication()));
            return new DefaultExecutionResult((ExecutionConsole)runner.getConsoleView(), (ProcessHandler)runner.getProcessHandler(), actions.toArray(new AnAction[actions.size()]));
        }
        if (this.myConfig.emulateTerminal()) {
            this.setRunWithPty(true);
            ProcessHandler processHandler2 = this.startProcess(processStarter, patchers);
            TerminalExecutionConsole executeConsole = new TerminalExecutionConsole(this.myConfig.getProject(), processHandler2);
            executeConsole.addMessageFilter(this.myConfig.getProject(), new PythonTracebackFilter(this.myConfig.getProject()));
            executeConsole.addMessageFilter(this.myConfig.getProject(), (Filter)new UrlFilter());
            processHandler2.startNotify();
            return new DefaultExecutionResult((ExecutionConsole)executeConsole, processHandler2, AnAction.EMPTY_ARRAY);
        }
        return super.execute(executor, processStarter, patchers);
    }

    @Override
    public void customizeEnvironmentVars(Map<String, String> envs, boolean passParentEnvs) {
        super.customizeEnvironmentVars(envs, passParentEnvs);
        if (this.myConfig.emulateTerminal() && !SystemInfo.isWindows) {
            envs.put("TERM", "xterm-256color");
        }
    }

    @Override
    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        if (this.myConfig.emulateTerminal()) {
            return new OSProcessHandler(commandLine){

                @NotNull
                protected BaseOutputReader.Options readerOptions() {
                    BaseOutputReader.Options options = new BaseOutputReader.Options(){

                        public BaseDataReader.SleepingPolicy policy() {
                            return BaseDataReader.SleepingPolicy.BLOCKING;
                        }

                        public boolean splitToLines() {
                            return false;
                        }

                        public boolean withSeparators() {
                            return true;
                        }
                    };
                    if (options == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return options;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/run/PythonScriptCommandLineState$3", "readerOptions"));
                }
            };
        }
        return super.doCreateProcess(commandLine);
    }

    @Override
    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
        ParametersList parametersList = commandLine.getParametersList();
        ParamsGroup exeOptions = parametersList.getParamsGroup("Exe Options");
        assert (exeOptions != null);
        exeOptions.addParametersString(this.myConfig.getInterpreterOptions());
        ParamsGroup scriptParameters = parametersList.getParamsGroup("Script");
        assert (scriptParameters != null);
        if (this.myConfig.isModuleMode()) {
            ParamsGroup moduleParameters = parametersList.getParamsGroup("Module");
            assert (moduleParameters != null);
            moduleParameters.addParameter("-m");
            moduleParameters.addParameters(new String[]{this.myConfig.getScriptName()});
        } else if (!StringUtil.isEmptyOrSpaces((String)this.myConfig.getScriptName())) {
            scriptParameters.addParameter(this.myConfig.getScriptName());
        }
        String scriptOptionsString = this.myConfig.getScriptParameters();
        if (scriptOptionsString != null) {
            scriptParameters.addParametersString(scriptOptionsString);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfig.getWorkingDirectory())) {
            commandLine.setWorkDirectory(this.myConfig.getWorkingDirectory());
        }
    }

    public class PythonScriptWithConsoleRunner
    extends PydevConsoleRunnerImpl {
        private CommandLinePatcher[] myPatchers;
        private String PYDEV_RUN_IN_CONSOLE_PY;

        public PythonScriptWithConsoleRunner(@NotNull Project project, @NotNull Sdk sdk, @Nullable PyConsoleType consoleType, String workingDir, Map<String, String> environmentVariables, CommandLinePatcher[] patchers, PyConsoleOptions.PyConsoleSettings consoleSettings, String ... statementsToExecute) {
            if (project == null) {
                PythonScriptWithConsoleRunner.$$$reportNull$$$0(0);
            }
            if (sdk == null) {
                PythonScriptWithConsoleRunner.$$$reportNull$$$0(1);
            }
            if (consoleType == null) {
                PythonScriptWithConsoleRunner.$$$reportNull$$$0(2);
            }
            super(project, sdk, consoleType, workingDir, environmentVariables, consoleSettings, (Consumer<String>)((Consumer)s -> {}), statementsToExecute);
            this.PYDEV_RUN_IN_CONSOLE_PY = "pydev/pydev_run_in_console.py";
            this.myPatchers = patchers;
        }

        @Override
        protected void createContentDescriptorAndActions() {
            ConsoleExecuteAction a = new ConsoleExecuteAction(super.getConsoleView(), this.myConsoleExecuteActionHandler, this.myConsoleExecuteActionHandler.getEmptyExecuteAction(), this.myConsoleExecuteActionHandler);
            AbstractConsoleRunnerWithHistory.registerActionShortcuts(Lists.newArrayList((Object[])new AnAction[]{a}), this.getConsoleView().getConsoleEditor().getComponent());
        }

        @Override
        protected String getRunnerFileFromHelpers() {
            return this.PYDEV_RUN_IN_CONSOLE_PY;
        }

        @Override
        protected GeneralCommandLine createCommandLine(@NotNull Sdk sdk, @NotNull Map<String, String> environmentVariables, @Nullable String workingDir, @NotNull int[] ports) {
            if (sdk == null) {
                PythonScriptWithConsoleRunner.$$$reportNull$$$0(3);
            }
            if (environmentVariables == null) {
                PythonScriptWithConsoleRunner.$$$reportNull$$$0(4);
            }
            if (ports == null) {
                PythonScriptWithConsoleRunner.$$$reportNull$$$0(5);
            }
            GeneralCommandLine consoleCmdLine = this.doCreateConsoleCmdLine(sdk, environmentVariables, workingDir, ports, PythonHelper.RUN_IN_CONSOLE);
            GeneralCommandLine cmd = PythonScriptCommandLineState.this.generateCommandLine(this.myPatchers);
            ParamsGroup group = consoleCmdLine.getParametersList().getParamsGroup("Script");
            assert (group != null);
            group.addParameters(cmd.getParametersList().getList());
            PythonEnvUtil.mergePythonPath(consoleCmdLine.getEnvironment(), cmd.getEnvironment());
            consoleCmdLine.getEnvironment().putAll(cmd.getEnvironment());
            return consoleCmdLine;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environmentVariables";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ports";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/run/PythonScriptCommandLineState$PythonScriptWithConsoleRunner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createCommandLine";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

