/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.NullableConsumer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.add.PyAddSdkDialog;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkDetailsStep
extends BaseListPopupStep<String> {
    @Nullable
    private DialogWrapper myShowAll;
    private final Project myProject;
    private final Component myOwnerComponent;
    private final Sdk[] myExistingSdks;
    private final NullableConsumer<Sdk> mySdkAddedCallback;
    private static final String LOCAL = PyBundle.message("sdk.details.step.add.local", new Object[0]);
    private static final String REMOTE = PyBundle.message("sdk.details.step.add.remote", new Object[0]);
    private static final String ALL = PyBundle.message("sdk.details.step.show.all", new Object[0]);
    @Nullable
    private String myNewProjectPath;

    public static void show(@Nullable Project project, @NotNull Sdk[] existingSdks, @Nullable DialogWrapper showAllDialog, @NotNull JComponent ownerComponent, @NotNull Point popupPoint, @Nullable String newProjectPath, @NotNull NullableConsumer<Sdk> sdkAddedCallback) {
        if (existingSdks == null) {
            PythonSdkDetailsStep.$$$reportNull$$$0(0);
        }
        if (ownerComponent == null) {
            PythonSdkDetailsStep.$$$reportNull$$$0(1);
        }
        if (popupPoint == null) {
            PythonSdkDetailsStep.$$$reportNull$$$0(2);
        }
        if (sdkAddedCallback == null) {
            PythonSdkDetailsStep.$$$reportNull$$$0(3);
        }
        PythonSdkDetailsStep sdkHomesStep = new PythonSdkDetailsStep(project, showAllDialog, ownerComponent, existingSdks, sdkAddedCallback);
        sdkHomesStep.myNewProjectPath = newProjectPath;
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)sdkHomesStep);
        popup2.showInScreenCoordinates((Component)ownerComponent, popupPoint);
    }

    public PythonSdkDetailsStep(@Nullable Project project, @Nullable DialogWrapper showAllDialog, @NotNull Component ownerComponent, @NotNull Sdk[] existingSdks, @NotNull NullableConsumer<Sdk> sdkAddedCallback) {
        if (ownerComponent == null) {
            PythonSdkDetailsStep.$$$reportNull$$$0(4);
        }
        if (existingSdks == null) {
            PythonSdkDetailsStep.$$$reportNull$$$0(5);
        }
        if (sdkAddedCallback == null) {
            PythonSdkDetailsStep.$$$reportNull$$$0(6);
        }
        super(null, PythonSdkDetailsStep.getAvailableOptions(showAllDialog != null));
        this.myProject = project;
        this.myShowAll = showAllDialog;
        this.myOwnerComponent = ownerComponent;
        this.myExistingSdks = existingSdks;
        this.mySdkAddedCallback = sdkAddedCallback;
    }

    private static List<String> getAvailableOptions(boolean showAll) {
        ArrayList<String> options = new ArrayList<String>();
        options.add(LOCAL);
        if (PythonRemoteInterpreterManager.getInstance() != null) {
            options.add(REMOTE);
        }
        if (showAll) {
            options.add(ALL);
        }
        return options;
    }

    @Nullable
    public ListSeparator getSeparatorAbove(String value) {
        return ALL.equals(value) ? new ListSeparator() : null;
    }

    private void optionSelected(String selectedValue) {
        if (!ALL.equals(selectedValue) && this.myShowAll != null) {
            Disposer.dispose((Disposable)this.myShowAll.getDisposable());
        }
        if (LOCAL.equals(selectedValue)) {
            this.createLocalSdk();
        } else if (REMOTE.equals(selectedValue)) {
            this.createRemoteSdk();
        } else if (this.myShowAll != null) {
            this.myShowAll.show();
        }
    }

    private void createLocalSdk() {
        Project project = this.myNewProjectPath != null ? null : this.myProject;
        PyAddSdkDialog dialog2 = new PyAddSdkDialog(project, Arrays.asList(this.myExistingSdks), this.myNewProjectPath);
        Sdk sdk = dialog2.showAndGet() ? dialog2.getOrCreateSdk() : null;
        this.mySdkAddedCallback.consume((Object)sdk);
    }

    private void createRemoteSdk() {
        PythonRemoteInterpreterManager remoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
        if (remoteInterpreterManager != null) {
            remoteInterpreterManager.addRemoteSdk(this.myProject, this.myOwnerComponent, Lists.newArrayList((Object[])this.myExistingSdks), this.mySdkAddedCallback);
        } else {
            String pathToPluginsPage = ShowSettingsUtil.getSettingsMenuName() + " | Plugins";
            Messages.showErrorDialog((String)PyBundle.message("remote.interpreter.error.plugin.missing", pathToPluginsPage), (String)PyBundle.message("remote.interpreter.add.title", new Object[0]));
        }
    }

    public boolean canBeHidden(String value) {
        return true;
    }

    public void canceled() {
        if (this.getFinalRunnable() == null && this.myShowAll != null) {
            Disposer.dispose((Disposable)this.myShowAll.getDisposable());
        }
    }

    public PopupStep onChosen(String selectedValue, boolean finalChoice) {
        return this.doFinalStep(() -> this.optionSelected(selectedValue));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupPoint";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAddedCallback";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkDetailsStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

