/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubCreatePullRequestWorker;
import org.jetbrains.plugins.github.api.GithubFullPath;

public class GithubCreatePullRequestPanel {
    private JTextField myTitleTextField;
    private JTextArea myDescriptionTextArea;
    private ComboBox myBranchComboBox;
    private SortedComboBoxModel<GithubCreatePullRequestWorker.ForkInfo> myForkModel;
    private SortedComboBoxModel<GithubCreatePullRequestWorker.BranchInfo> myBranchModel;
    private JPanel myPanel;
    private JButton myShowDiffButton;
    private JButton mySelectForkButton;
    private JLabel myForkLabel;
    private ComboBox myForkComboBox;
    private boolean myTitleDescriptionUserModified = false;

    public GithubCreatePullRequestPanel() {
        this.$$$setupUI$$$();
        this.myDescriptionTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.myBranchModel = new SortedComboBoxModel((o1, o2) -> StringUtil.naturalCompare((String)o1.getRemoteName(), (String)o2.getRemoteName()));
        this.myBranchComboBox.setModel(this.myBranchModel);
        this.myForkModel = new SortedComboBoxModel((o1, o2) -> StringUtil.naturalCompare((String)o1.getPath().getUser(), (String)o2.getPath().getUser()));
        this.myForkComboBox.setModel(this.myForkModel);
        DocumentAdapter userModifiedDocumentListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GithubCreatePullRequestPanel.this.myTitleDescriptionUserModified = true;
            }
        };
        this.myTitleTextField.getDocument().addDocumentListener((DocumentListener)userModifiedDocumentListener);
        this.myDescriptionTextArea.getDocument().addDocumentListener((DocumentListener)userModifiedDocumentListener);
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitleTextField.getText();
        if (string == null) {
            GithubCreatePullRequestPanel.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescriptionTextArea.getText();
        if (string == null) {
            GithubCreatePullRequestPanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public GithubCreatePullRequestWorker.ForkInfo getSelectedFork() {
        return (GithubCreatePullRequestWorker.ForkInfo)this.myForkModel.getSelectedItem();
    }

    @Nullable
    public GithubCreatePullRequestWorker.BranchInfo getSelectedBranch() {
        return (GithubCreatePullRequestWorker.BranchInfo)this.myBranchModel.getSelectedItem();
    }

    public void setSelectedFork(@Nullable GithubFullPath path) {
        if (path != null) {
            for (GithubCreatePullRequestWorker.ForkInfo info : this.myForkModel.getItems()) {
                if (!path.equals(info.getPath())) continue;
                this.myForkModel.setSelectedItem((Object)info);
                return;
            }
        }
        if (this.myForkModel.getSize() > 0) {
            this.myForkModel.setSelectedItem(this.myForkModel.get(0));
        }
    }

    public void setSelectedBranch(@Nullable String branch) {
        if (branch != null) {
            for (GithubCreatePullRequestWorker.BranchInfo info : this.myBranchModel.getItems()) {
                if (!branch.equals(info.getRemoteName())) continue;
                this.myBranchModel.setSelectedItem((Object)info);
                return;
            }
        }
        if (this.myBranchModel.getSize() > 0) {
            this.myBranchModel.setSelectedItem(this.myBranchModel.get(0));
        }
    }

    public void setForks(@NotNull Collection<GithubCreatePullRequestWorker.ForkInfo> forks) {
        if (forks == null) {
            GithubCreatePullRequestPanel.$$$reportNull$$$0(2);
        }
        this.myForkModel.setSelectedItem(null);
        this.myForkModel.setAll(forks);
    }

    public void setBranches(@NotNull Collection<GithubCreatePullRequestWorker.BranchInfo> branches) {
        if (branches == null) {
            GithubCreatePullRequestPanel.$$$reportNull$$$0(3);
        }
        this.myBranchModel.setSelectedItem(null);
        this.myBranchModel.setAll(branches);
    }

    public void setTitle(@Nullable String title) {
        this.myTitleTextField.setText(title);
        this.myTitleDescriptionUserModified = false;
    }

    public void setDescription(@Nullable String title) {
        this.myDescriptionTextArea.setText(title);
        this.myTitleDescriptionUserModified = false;
    }

    public boolean isTitleDescriptionEmptyOrNotModified() {
        return !this.myTitleDescriptionUserModified || StringUtil.isEmptyOrSpaces((String)this.myTitleTextField.getText()) && StringUtil.isEmptyOrSpaces((String)this.myDescriptionTextArea.getText());
    }

    public void setDiffEnabled(boolean enabled) {
        this.myShowDiffButton.setEnabled(enabled);
    }

    @NotNull
    public JComponent getTitleTextField() {
        JTextField jTextField = this.myTitleTextField;
        if (jTextField == null) {
            GithubCreatePullRequestPanel.$$$reportNull$$$0(4);
        }
        return jTextField;
    }

    @NotNull
    public JButton getSelectForkButton() {
        JButton jButton = this.mySelectForkButton;
        if (jButton == null) {
            GithubCreatePullRequestPanel.$$$reportNull$$$0(5);
        }
        return jButton;
    }

    @NotNull
    public JButton getShowDiffButton() {
        JButton jButton = this.myShowDiffButton;
        if (jButton == null) {
            GithubCreatePullRequestPanel.$$$reportNull$$$0(6);
        }
        return jButton;
    }

    @NotNull
    public ComboBox getForkComboBox() {
        ComboBox comboBox = this.myForkComboBox;
        if (comboBox == null) {
            GithubCreatePullRequestPanel.$$$reportNull$$$0(7);
        }
        return comboBox;
    }

    @NotNull
    public ComboBox getBranchComboBox() {
        ComboBox comboBox = this.myBranchComboBox;
        if (comboBox == null) {
            GithubCreatePullRequestPanel.$$$reportNull$$$0(8);
        }
        return comboBox;
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    @NotNull
    public JComponent getPreferredComponent() {
        JTextField jTextField = this.myTitleTextField;
        if (jTextField == null) {
            GithubCreatePullRequestPanel.$$$reportNull$$$0(9);
        }
        return jTextField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleTextField";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectForkButton";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShowDiffButton";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getForkComboBox";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchComboBox";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setForks";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setBranches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JTextField jTextField;
        JButton jButton;
        ComboBox comboBox;
        JButton jButton2;
        ComboBox comboBox2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Base fork:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForkComboBox = comboBox2 = new ComboBox();
        jPanel.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.mySelectForkButton = jButton2 = new JButton();
        jButton2.setText("Select Other Fork");
        jPanel.add((Component)jButton2, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Base branch:");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBranchComboBox = comboBox = new ComboBox();
        comboBox.setEditable(false);
        comboBox.setToolTipText("");
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myShowDiffButton = jButton = new JButton();
        jButton.setText("Show Diff");
        jPanel.add((Component)jButton, new GridConstraints(1, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Title:");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTitleTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Description:");
        jPanel.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(4, 0, 1, 3, 0, 3, 7, 7, new Dimension(150, 50), null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myDescriptionTextArea = jTextArea = new JTextArea();
        jBScrollPane.setViewportView(jTextArea);
        jLabel.setLabelFor((Component)comboBox2);
        jBLabel.setLabelFor((Component)comboBox);
        jBLabel2.setLabelFor(jTextField);
        jBLabel3.setLabelFor(jTextArea);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

