/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging;

import com.drew.imaging.FileType;
import com.drew.lang.ByteTrie;
import com.drew.lang.annotations.NotNull;
import java.io.BufferedInputStream;
import java.io.IOException;

public class FileTypeDetector {
    private static final ByteTrie<FileType> _root = new ByteTrie();

    private FileTypeDetector() throws Exception {
        throw new Exception("Not intended for instantiation");
    }

    @NotNull
    public static FileType detectFileType(@NotNull BufferedInputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IOException("Stream must support mark/reset");
        }
        int maxByteCount = _root.getMaxDepth();
        inputStream.mark(maxByteCount);
        byte[] bytes = new byte[maxByteCount];
        int bytesRead = inputStream.read(bytes);
        if (bytesRead == -1) {
            throw new IOException("Stream ended before file's magic number could be determined.");
        }
        inputStream.reset();
        return _root.find(bytes);
    }

    static {
        _root.setDefaultValue(FileType.Unknown);
        _root.addPath(FileType.Jpeg, new byte[][]{{-1, -40}});
        _root.addPath(FileType.Tiff, "II".getBytes(), {42, 0});
        _root.addPath(FileType.Tiff, "MM".getBytes(), {0, 42});
        _root.addPath(FileType.Psd, new byte[][]{"8BPS".getBytes()});
        _root.addPath(FileType.Png, new byte[][]{{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82}});
        _root.addPath(FileType.Bmp, new byte[][]{"BM".getBytes()});
        _root.addPath(FileType.Gif, new byte[][]{"GIF87a".getBytes()});
        _root.addPath(FileType.Gif, new byte[][]{"GIF89a".getBytes()});
        _root.addPath(FileType.Ico, new byte[][]{{0, 0, 1, 0}});
        _root.addPath(FileType.Pcx, new byte[][]{{10, 0, 1}});
        _root.addPath(FileType.Pcx, new byte[][]{{10, 2, 1}});
        _root.addPath(FileType.Pcx, new byte[][]{{10, 3, 1}});
        _root.addPath(FileType.Pcx, new byte[][]{{10, 5, 1}});
        _root.addPath(FileType.Riff, new byte[][]{"RIFF".getBytes()});
        _root.addPath(FileType.Arw, "II".getBytes(), {42, 0, 8, 0});
        _root.addPath(FileType.Crw, "II".getBytes(), {26, 0, 0, 0}, "HEAPCCDR".getBytes());
        _root.addPath(FileType.Cr2, "II".getBytes(), {42, 0, 16, 0, 0, 0, 67, 82});
        _root.addPath(FileType.Nef, "MM".getBytes(), {0, 42, 0, 0, 0, -128, 0});
        _root.addPath(FileType.Orf, "IIRO".getBytes(), {8, 0});
        _root.addPath(FileType.Orf, "IIRS".getBytes(), {8, 0});
        _root.addPath(FileType.Raf, new byte[][]{"FUJIFILMCCD-RAW".getBytes()});
        _root.addPath(FileType.Rw2, "II".getBytes(), {85, 0});
    }
}

